/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer;

import javarequirementstracer.TraceProperties;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractScanner {
    private final TraceProperties properties;

    AbstractScanner(TraceProperties properties) {
        this.properties = properties;
    }

    TraceProperties getProperties() {
        return this.properties;
    }

    boolean isTestCode(Class<?> cl) {
        int index = cl.getName().lastIndexOf(46);
        String name = cl.getName().substring(index + 1);
        return name.startsWith("Test") || name.endsWith("Test") || name.endsWith("TestCase") || name.contains("Test$") || name.contains("TestCase$");
    }

    boolean exclude(Class<?> cl) {
        if (!this.properties.isIncludeTestCode() && this.isTestCode(cl)) {
            return true;
        }
        for (String excludePackageName : this.properties.getExcludePackageNames()) {
            if (!cl.getName().startsWith(excludePackageName)) continue;
            return true;
        }
        for (String excludeTypeName : this.properties.getExcludeTypeNames()) {
            if (!cl.getName().equals(excludeTypeName)) continue;
            return true;
        }
        return false;
    }

    void setResourceLoader(ClassPathScanningCandidateComponentProvider classPathScanner) {
        if (this.properties.getClassLoader() != null) {
            classPathScanner.setResourceLoader((ResourceLoader)new DefaultResourceLoader(this.properties.getClassLoader()));
        }
    }

    ClassLoader getClassLoader() {
        return this.properties.getClassLoader();
    }
}

