/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javarequirementstracer;

import java.io.IOException;

import junit.framework.Assert;

import org.junit.Test;



/**
 * @author Ronald Koster
 */
public class ReporterUtilsTest {
	
	@Test
	public void getPercentageGraph() throws IOException {
		Assert.assertTrue(ReporterUtils.getPercentageGraph(0.12345D).contains("12px"));
		Assert.assertTrue(ReporterUtils.getPercentageGraph(0.1249D).contains("12px"));
		Assert.assertTrue(ReporterUtils.getPercentageGraph(0.1250D).contains("13px"));
		Assert.assertTrue(ReporterUtils.getPercentageGraph(Double.NaN).contains("0px"));
	}
}