/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javarequirementstracer;


/**
 * IDs for key elements in the XHTML report.
 * Key elements have an id attribute, enabling the report to be parsed by tools. 
 * 
 * @author Ronald Koster
 */
@Requirements("UC-Parseable-Report")
public enum AttributeId {
	REPORTER_INFO,
	TIMESTAMP,
	BUILD_NUMBER,
	COVERAGES,
	CODE_COVERAGE,
	CODE_COVERAGE_DESCRIPTION,
	REQUIREMENTS_COVERAGE,
	REQUIREMENTS_COVERAGE_DESCRIPTION,
	REQUIRED_LABEL_COUNT,
	ALL_TYPES_COUNT,
	ROOT_PACKAGE_NAME,
	INCLUDE_PACKAGE_NAMES,
	EXCLUDE_PACKAGE_NAMES,
	EXCLUDE_TYPE_NAMES,
	INCLUDE_TEST_CODE,
	MISSING_REQUIREMENTS,
	UNKNOWN_REQUIREMENTS,
	UNTRACEABLE_TYPES,
	REQUIREMENT_TO_CODE_ELEMENTS,
	CODE_ELEMENT_TO_REQUIREMENTS,
	REQUIREMENT_DESCRIPTIONS;
}