/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import javarequirementstracer.Logger;
import javarequirementstracer.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class UniqueProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getInstance(UniqueProperties.class);

    UniqueProperties() {
    }

    @Override
    public Object put(Object key, Object value) {
        if (this.containsKey(key)) {
            throw new IllegalArgumentException("Unique violation: " + key);
        }
        return super.put(key, value);
    }

    void load(File propertiesFile) {
        LOGGER.info("$user.dir = " + System.getProperty("user.dir"));
        LOGGER.info("propertiesFilename = " + propertiesFile.getAbsolutePath());
        try {
            this.load(new FileInputStream(propertiesFile));
        }
        catch (FileNotFoundException fnfex) {
            LOGGER.error(fnfex);
            throw new UncheckedException(fnfex);
        }
        catch (IOException ioex) {
            LOGGER.error(ioex);
            throw new UncheckedException(ioex);
        }
    }

    SortedMap<String, String> getAsSortedMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            map.put(key, value);
        }
        return map;
    }
}

