/*
 * Decompiled with CFR 0.152.
 */
package javarequirementstracer;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javarequirementstracer.AttributeId;
import javarequirementstracer.Logger;
import javarequirementstracer.ReporterUtils;
import javarequirementstracer.TraceProperties;
import javarequirementstracer.XhtmlBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TraceReporter {
    private static final Logger LOGGER = Logger.getInstance(TraceReporter.class);
    private final File reportFile;
    private final TraceProperties properties;
    private final SortedMap<String, SortedSet<String>> codeNamesToLabels;
    private final SortedSet<String> untraceableTypes;
    private final SortedMap<String, SortedSet<String>> labelsToCodeNames = new TreeMap<String, SortedSet<String>>();
    private final SortedSet<String> missingLabels = new TreeSet<String>();
    private final SortedSet<String> unknownLabels = new TreeSet<String>();

    TraceReporter(TraceProperties properties, SortedMap<String, SortedSet<String>> codeNamesToLabels, SortedSet<String> untraceableTypes) {
        this.properties = properties;
        this.reportFile = new File(this.properties.getReportFilename());
        this.codeNamesToLabels = codeNamesToLabels;
        this.untraceableTypes = untraceableTypes;
        LOGGER.info("*** Report parameters: ");
        LOGGER.info("reportFile = " + this.reportFile.getAbsolutePath());
        LOGGER.debug("codeNamesToLabelsCount = " + this.codeNamesToLabels.size());
        LOGGER.debug("untraceableTypesCount = " + this.untraceableTypes.size());
    }

    void run() {
        this.initRun();
        XhtmlBuilder bldr = new XhtmlBuilder();
        bldr.start("Traceabilities for " + this.properties.getProjectName());
        ReporterUtils.appendReporterInfo(bldr);
        this.appendSummary(bldr);
        this.appendSettings(bldr);
        this.appendMissingUnknownUntraceable(bldr);
        this.appendMappingSection(bldr, AttributeId.REQUIREMENT_TO_CODE_ELEMENTS, this.labelsToCodeNames, "Requirement", "Code Elements");
        this.appendMappingSection(bldr, AttributeId.CODE_ELEMENT_TO_REQUIREMENTS, this.codeNamesToLabels, "Code Element", "Requirements");
        this.appendRequirementsDescriptions(bldr);
        bldr.end();
        bldr.write(this.reportFile);
    }

    private void initRun() {
        for (String codeName : this.codeNamesToLabels.keySet()) {
            Set labels = (Set)this.codeNamesToLabels.get(codeName);
            for (String label : labels) {
                TreeSet<String> codeNames = (TreeSet<String>)this.labelsToCodeNames.get(label);
                if (codeNames == null) {
                    codeNames = new TreeSet<String>();
                    this.labelsToCodeNames.put(label, codeNames);
                }
                codeNames.add(codeName);
            }
        }
        for (String label : this.properties.getExpectedLabels().keySet()) {
            if (this.labelsToCodeNames.containsKey(label)) continue;
            this.missingLabels.add(label);
        }
        for (String label : this.labelsToCodeNames.keySet()) {
            if (this.properties.getExpectedLabels().containsKey(label)) continue;
            this.unknownLabels.add(label);
        }
    }

    private void appendSummary(XhtmlBuilder bldr) {
        bldr.heading(2, "Summary");
        ReporterUtils.appendTimestampBuildNumber(bldr, this.properties.getBuildNumber());
        TreeSet<String> traceableTypes = new TreeSet<String>();
        for (String codeName : this.codeNamesToLabels.keySet()) {
            int index = codeName.indexOf("#");
            if (index < 0) {
                traceableTypes.add(codeName);
                continue;
            }
            traceableTypes.add(codeName.substring(0, index));
        }
        ArrayList<Collection<String>> statistics = new ArrayList<Collection<String>>();
        int traceableTypeCount = traceableTypes.size();
        int untraceableTypeCount = this.untraceableTypes.size();
        int allTypesCount = traceableTypeCount + untraceableTypeCount;
        statistics.add(Arrays.asList("CodeCoverage", this.span(this.getPercentage(traceableTypeCount, allTypesCount), AttributeId.CODE_COVERAGE), this.span("= traceableTypeCount/allTypesCount = " + traceableTypeCount + "/" + allTypesCount, AttributeId.CODE_COVERAGE_DESCRIPTION)));
        int foundLabelCount = this.labelsToCodeNames.size();
        int unknownLabelCount = this.unknownLabels.size();
        int requiredLabelCount = this.properties.getExpectedLabels().size();
        statistics.add(Arrays.asList("RequirementsCoverage", this.span(this.getPercentage(foundLabelCount - unknownLabelCount, requiredLabelCount), AttributeId.REQUIREMENTS_COVERAGE), this.span("= (foundLabelCount - unknownLabelCount)/requiredLabelCount = " + (foundLabelCount - unknownLabelCount) + "/" + requiredLabelCount, AttributeId.REQUIREMENTS_COVERAGE_DESCRIPTION)));
        bldr.table(AttributeId.COVERAGES, statistics, new String[0]);
        bldr.parStart().append("<b>Checksums:</b>");
        this.appendChecksumLine(bldr, AttributeId.REQUIRED_LABEL_COUNT, "requiredLabelCount", requiredLabelCount, "missingLabelCount + foundLabelCount - unknownLabelCount", this.missingLabels.size() + " + " + foundLabelCount + " - " + unknownLabelCount, this.missingLabels.size() + foundLabelCount - unknownLabelCount);
        this.appendChecksumLine(bldr, AttributeId.ALL_TYPES_COUNT, "allTypesCount", allTypesCount, "traceableTypeCount + untraceableTypeCount", traceableTypeCount + " + " + untraceableTypeCount, traceableTypeCount + untraceableTypeCount);
        bldr.parEnd();
        ReporterUtils.appendProgressIndicatorEstimate(bldr, false);
    }

    private void appendChecksumLine(XhtmlBuilder bldr, AttributeId id, String quantityName, long quantityValue, String sumMsg, String sumValues, long sum) {
        bldr.br().spanStart(id).append(quantityName).append(" = ").append(quantityValue).append(" =? ").append(sumMsg).append(" = ").append(sumValues).append(" = ").append(sum).tab().append("...").append(quantityValue == sum ? "OK" : "<b><big>NOK!!!</big></b>").spanEnd();
    }

    private String getPercentage(int numerator, int denominator) {
        float fnum = numerator;
        float fdenom = denominator;
        return String.format("%.2f", Float.valueOf(100.0f * fnum / fdenom)) + "%";
    }

    private String span(String str, AttributeId attId) {
        return "<span id='" + (Object)((Object)attId) + "'>" + str + "</span>";
    }

    private void appendSettings(XhtmlBuilder bldr) {
        bldr.heading(2, "Settings");
        bldr.parStart();
        bldr.append("<b>rootPackageName:</b> ").append(AttributeId.ROOT_PACKAGE_NAME, this.properties.getRootPackageName());
        bldr.br().append("<b>includePackageNames:</b> ").append(AttributeId.INCLUDE_PACKAGE_NAMES, this.properties.getIncludePackageNames());
        bldr.br().append("<b>excludePackageNames:</b> ").append(AttributeId.EXCLUDE_PACKAGE_NAMES, this.properties.getExcludePackageNames());
        bldr.br().append("<b>excludeTypeNames:</b> ").append(AttributeId.EXCLUDE_TYPE_NAMES, this.properties.getExcludeTypeNames());
        bldr.br().append("<b>includeTestCode:</b> ").append(AttributeId.INCLUDE_TEST_CODE, this.properties.isIncludeTestCode());
        bldr.parEnd();
    }

    private void appendMissingUnknownUntraceable(XhtmlBuilder bldr) {
        bldr.heading(2, "Missing, Unknown or Untraceable");
        this.appendSet(bldr, AttributeId.MISSING_REQUIREMENTS, this.missingLabels, "Missing Requirements");
        bldr.br();
        this.appendSet(bldr, AttributeId.UNKNOWN_REQUIREMENTS, this.unknownLabels, "Unknown Requirements");
        bldr.br();
        this.appendSet(bldr, AttributeId.UNTRACEABLE_TYPES, this.untraceableTypes, "Untraceable Types");
    }

    private void appendSet(XhtmlBuilder bldr, AttributeId id, SortedSet<String> labels, String header) {
        ArrayList<Collection<String>> rows = new ArrayList<Collection<String>>();
        ArrayList<String> row = new ArrayList<String>();
        rows.add(row);
        row.add(this.toString(labels));
        bldr.table(id, rows, header + " (count = " + labels.size() + ")");
    }

    private String toString(SortedSet<String> items) {
        if (items.size() == 0) {
            return "-";
        }
        String str = items.toString();
        return str.substring(1, str.length() - 1);
    }

    private void appendMappingSection(XhtmlBuilder bldr, AttributeId id, SortedMap<String, SortedSet<String>> map, String ... headers) {
        bldr.heading(2, headers[0] + " &rarr; " + headers[1]);
        TreeMap<String, String> newMap = new TreeMap<String, String>();
        for (Map.Entry<String, SortedSet<String>> entry : map.entrySet()) {
            newMap.put(entry.getKey(), this.toString(entry.getValue()));
        }
        this.appendMapOfStrings(bldr, id, newMap, headers);
    }

    private void appendRequirementsDescriptions(XhtmlBuilder bldr) {
        bldr.heading(2, "Requirements Descriptions");
        this.appendMapOfStrings(bldr, AttributeId.REQUIREMENT_DESCRIPTIONS, this.properties.getExpectedLabels(), "Label", "Description");
    }

    private void appendMapOfStrings(XhtmlBuilder bldr, AttributeId id, SortedMap<String, String> map, String ... headers) {
        bldr.table(id, map, headers[0] + " (count = " + map.size() + ")", headers[1]);
    }
}

