/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javarequirementstracer;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import junit.framework.Assert;

import org.junit.Test;



/**
 * @author Ronald Koster
 */
public class UniquePropertiesTest {
	
	@Test
	public void loadOK() throws IOException {
		Properties props = new UniqueProperties();
		props.load(new FileInputStream("src/test/config/unique.properties"));
		Assert.assertEquals(3, props.size());
	}
	
	@Test
	public void loadNOK() throws IOException {
		Properties props = new UniqueProperties();
		IllegalArgumentException ex = null;
		try {
			props.load(new FileInputStream("src/test/config/not-unique.properties"));
		} catch (IllegalArgumentException iaex) {
			ex = iaex;
		}
		Assert.assertNotNull(ex);
		Assert.assertTrue(ex.getMessage().endsWith("prop2"));
	}
}