/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javarequirementstracer;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.util.Date;
import java.util.Properties;


/**
 * @author Ronald Koster
 */
@SuppressTraceabilityWarnings
public final class ReporterUtils {
	
	static final String CODE_COVERAGE_DEF = "= traceableTypeCount/allTypesCount = ";
	static final String REQUIREMENTS_COVERAGE_DEF = "= (foundLabelCount - unknownLabelCount)/requiredLabelCount = ";
	
	
	private ReporterUtils() {
		// Util class.
	}

	static void appendReporterInfo(XhtmlBuilder bldr) {
		bldr.append("<small>Generated with ").spanStart(AttributeId.REPORTER_INFO);
		bldr.append("<a href='http://reqtracer.sourceforge.net'>JavaRequirementsTracer</a> ").append(getVersion());
		bldr.spanEnd().append(".</small>");
	}

	static void appendTimestampBuildNumber(XhtmlBuilder bldr, String buildNr) {
		bldr.parStart();
		bldr.append("<b>Timestamp:</b> ").append(AttributeId.TIMESTAMP, new Date());
		bldr.br().append("\n<b>Build Number:</b> ").append(AttributeId.BUILD_NUMBER, buildNr == null ? "???" : buildNr);
		bldr.parEnd();
	}
	
	static void appendProgressIndicatorEstimate(XhtmlBuilder bldr, boolean total) {
		String prefix = total ? "Total" : ""; 
		bldr.parStart().append("<b>").append(prefix).append(" Project Completeness estimates:</b>").parEnd();
		bldr.append("\n<ol>");
		bldr.append("\n<li>Best choice: ")
				.append(prefix).append("ProjectCompleteness").nbsp().append("=").nbsp()
				.append(prefix).append("SytemTestCodeRequirementsCoverage").nbsp().append("*").nbsp()
				.append(prefix).append("PercentageSuccessfulSystemTests</li>");
		bldr.append("\n<li>Next best choice (no System Test code): ")
				.append(prefix).append("ProjectCompleteness").nbsp().append("=").nbsp()
				.append(prefix).append("MainCodeRequirementsCoverage").nbsp().append("*").nbsp()
				.append(prefix).append("PercentageSuccessfulManualSystemTests</li>");
		bldr.append("\n</ol>");
	}

	private static String getVersion() {
		Properties props = new Properties();
		try {
			props.load(ReporterUtils.class.getResourceAsStream("/jrt-reporter.properties"));
		} catch (IOException ioex) {
			throw new UncheckedException(ioex);
		}
		return props.getProperty("version");
	}
	
	public static String formatPercentage(double d) {
		return String.format("%.2f", 100F * d) + "%";
	}
	
	public static String formatPercentage(String integerPart, String fraction) {
		return integerPart + getDecimalSeparator() + fraction + "%";
	}
	
	public static char getDecimalSeparator() {
		return DecimalFormatSymbols.getInstance().getDecimalSeparator();
	}
}
