/*
 * Copyright 2008-2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package javarequirementstracer;

/**
 * This class encapsulates all logging output.
 * 
 * @author Ronald Koster
 */
final class Logger {
	
	private final String name;
	
	
	private Logger(String name) {
		this.name = name;
	}
	
	static Logger getInstance(String name) {
		return new Logger(name);
	}
	
	static Logger getInstance(Class<?> clazz) {
		return getInstance(clazz.getName());
	}
	
	void debug(final String str) {
		debug(str, null);
	}
	
	void debug(final String str, final Throwable th) {
		log("DEBUG ", str, th);
	}
		
	void info(final String str) {
		log("INFO ", str);
	}
	
	void warn(final String str) {
		log("WARN ", str);
	}
	
	void error(final String str) {
		error(str, null);
	}
	
	void error(final Throwable th) {
		error("Unexpected exception in " + this.name, th);
	}
	
	void error(final String str, final Throwable th) {
		log("ERROR ", str, th);
	}
	
	private void log(final String prefix, final String msg) {
		log(prefix, msg, null);
	}
	
	private void log(final String prefix, final String msg, final Throwable th) {
		System.out.println(prefix + msg);
		if (th != null) {
			th.printStackTrace();
		}
	}
}
