/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.ast.internal;

import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.xml.ast.XmlNode;
import net.sourceforge.pmd.lang.xml.ast.internal.XmlParserImpl;
import net.sourceforge.pmd.util.DataMap;
import net.sourceforge.pmd.util.IteratorUtil;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class XmlNodeWrapper
implements XmlNode {
    private DataMap<DataMap.DataKey<?, ?>> dataMap;
    private final XmlParserImpl parser;
    private final org.w3c.dom.Node node;
    int startOffset;
    int endOffset;
    TextDocument textDoc;

    XmlNodeWrapper(XmlParserImpl parser, org.w3c.dom.Node domNode) {
        this.node = domNode;
        this.parser = parser;
        domNode.setUserData("pmd.node", this, null);
    }

    protected XmlNode wrap(org.w3c.dom.Node domNode) {
        return this.parser.wrapDomNode(domNode);
    }

    public TextRegion getTextRegion() {
        return TextRegion.fromBothOffsets((int)this.startOffset, (int)this.endOffset);
    }

    public XmlNode getParent() {
        org.w3c.dom.Node parent = this.node.getParentNode();
        return parent != null ? this.parser.wrapDomNode(parent) : null;
    }

    public int getIndexInParent() {
        org.w3c.dom.Node parent = this.node.getParentNode();
        if (parent == null) {
            return -1;
        }
        NodeList childNodes = parent.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (this.node != childNodes.item(i)) continue;
            return i;
        }
        throw new IllegalStateException("This node is not a child of its parent: " + this.node);
    }

    public XmlNode getChild(int index) {
        return this.parser.wrapDomNode(this.node.getChildNodes().item(index));
    }

    public int getNumChildren() {
        return this.node.hasChildNodes() ? this.node.getChildNodes().getLength() : 0;
    }

    public String getImage() {
        return this.node instanceof Text ? ((Text)this.node).getData() : null;
    }

    public boolean hasImageEqualTo(String image) {
        return Objects.equals(image, this.getImage());
    }

    public boolean isFindBoundary() {
        return false;
    }

    public DataMap<DataMap.DataKey<?, ?>> getUserMap() {
        if (this.dataMap == null) {
            this.dataMap = DataMap.newDataMap();
        }
        return this.dataMap;
    }

    public String getXPathNodeName() {
        return this.node.getNodeName().replace("#", "");
    }

    public String toString() {
        return this.node.getNodeName().replace("#", "");
    }

    public Iterator<Attribute> getXPathAttributesIterator() {
        if (this.node instanceof Text) {
            return Collections.singletonList(new Attribute((Node)this, "Image", ((Text)this.node).getData())).iterator();
        }
        if (this.node.getAttributes() == null) {
            return Collections.emptyIterator();
        }
        return IteratorUtil.map(XmlNodeWrapper.asList(this.node.getAttributes()).iterator(), n -> new Attribute((Node)this, n.getNodeName(), n.getNodeValue()));
    }

    private static List<org.w3c.dom.Node> asList(final NamedNodeMap nodeList) {
        return new AbstractList<org.w3c.dom.Node>(){

            @Override
            public org.w3c.dom.Node get(int index) {
                return nodeList.item(index);
            }

            @Override
            public int size() {
                return nodeList.getLength();
            }
        };
    }

    @Override
    public org.w3c.dom.Node getNode() {
        return this.node;
    }
}

