/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.xml.ast;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.xpath.Attribute;
import net.sourceforge.pmd.lang.xml.XmlParserOptions;
import net.sourceforge.pmd.lang.xml.ast.XmlNode;
import net.sourceforge.pmd.util.CompoundIterator;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public class XmlParser {
    protected final XmlParserOptions parserOptions;
    protected Map<org.w3c.dom.Node, XmlNode> nodeCache = new HashMap<org.w3c.dom.Node, XmlNode>();

    public XmlParser(XmlParserOptions parserOptions) {
        this.parserOptions = parserOptions;
    }

    protected Document parseDocument(Reader reader) throws ParseException {
        this.nodeCache.clear();
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxParserFactory.setNamespaceAware(this.parserOptions.isNamespaceAware());
            saxParserFactory.setValidating(this.parserOptions.isValidating());
            saxParserFactory.setXIncludeAware(this.parserOptions.isXincludeAware());
            SAXParser saxParser = saxParserFactory.newSAXParser();
            LineNumberAwareSaxHandler handler = new LineNumberAwareSaxHandler(this.parserOptions);
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            xmlReader.setProperty("http://xml.org/sax/properties/declaration-handler", handler);
            xmlReader.setEntityResolver(this.parserOptions.getEntityResolver());
            xmlReader.parse(new InputSource(reader));
            return handler.getDocument();
        }
        catch (ParserConfigurationException e) {
            throw new ParseException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ParseException((Throwable)e);
        }
        catch (IOException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public XmlNode parse(Reader reader) {
        Document document = this.parseDocument(reader);
        return this.createProxy(document);
    }

    public XmlNode createProxy(org.w3c.dom.Node node) {
        XmlNode proxy = this.nodeCache.get(node);
        if (proxy != null) {
            return proxy;
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        interfaces.add(XmlNode.class);
        if (node instanceof Document) {
            interfaces.add(RootNode.class);
        }
        this.addAllInterfaces(interfaces, node.getClass());
        proxy = (XmlNode)Proxy.newProxyInstance(XmlParser.class.getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new XmlNodeInvocationHandler(node));
        this.nodeCache.put(node, proxy);
        return proxy;
    }

    public void addAllInterfaces(Set<Class<?>> interfaces, Class<?> clazz) {
        interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
        if (clazz.getSuperclass() != null) {
            this.addAllInterfaces(interfaces, clazz.getSuperclass());
        }
    }

    public class XmlNodeInvocationHandler
    implements InvocationHandler {
        private final org.w3c.dom.Node node;
        private Object userData;

        public XmlNodeInvocationHandler(org.w3c.dom.Node node) {
            this.node = node;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass().isAssignableFrom(XmlNode.class) && !"java.lang.Object".equals(method.getDeclaringClass().getName())) {
                if ("jjtGetNumChildren".equals(method.getName())) {
                    return this.node.hasChildNodes() ? this.node.getChildNodes().getLength() : 0;
                }
                if ("jjtGetChild".equals(method.getName())) {
                    return XmlParser.this.createProxy(this.node.getChildNodes().item((Integer)args[0]));
                }
                if ("getImage".equals(method.getName())) {
                    if (this.node instanceof Text) {
                        return ((Text)this.node).getData();
                    }
                    return null;
                }
                if ("jjtGetParent".equals(method.getName())) {
                    org.w3c.dom.Node parent = this.node.getParentNode();
                    if (parent != null && !(parent instanceof Document)) {
                        return XmlParser.this.createProxy(parent);
                    }
                    return null;
                }
                if ("getAttributeIterator".equals(method.getName())) {
                    ArrayList<Iterator<Attribute>> iterators = new ArrayList<Iterator<Attribute>>();
                    final NamedNodeMap attributes = this.node.getAttributes();
                    iterators.add(new Iterator<Attribute>(){
                        private int index;

                        @Override
                        public boolean hasNext() {
                            return attributes != null && this.index < attributes.getLength();
                        }

                        @Override
                        public Attribute next() {
                            org.w3c.dom.Node attributeNode = attributes.item(this.index++);
                            return new Attribute((Node)XmlParser.this.createProxy(XmlNodeInvocationHandler.this.node), attributeNode.getNodeName(), attributeNode.getNodeValue());
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    });
                    if (proxy instanceof Text) {
                        iterators.add(Collections.singletonList(new Attribute((Node)proxy, "Image", ((Text)proxy).getData())).iterator());
                    }
                    return new CompoundIterator(iterators.toArray(new Iterator[iterators.size()]));
                }
                if ("getBeginLine".equals(method.getName())) {
                    return this.getUserData("pmd:beginLine");
                }
                if ("getBeginColumn".equals(method.getName())) {
                    return this.getUserData("pmd:beginColumn");
                }
                if ("getEndLine".equals(method.getName())) {
                    return this.getUserData("pmd:endLine");
                }
                if ("getEndColumn".equals(method.getName())) {
                    return this.getUserData("pmd:endColumn");
                }
                if ("getNode".equals(method.getName())) {
                    return this.node;
                }
                if ("getUserData".equals(method.getName())) {
                    return this.userData;
                }
                if ("setUserData".equals(method.getName())) {
                    this.userData = args[0];
                    return null;
                }
                if ("isFindBoundary".equals(method.getName())) {
                    return false;
                }
                throw new UnsupportedOperationException("Method not supported for XmlNode: " + method);
            }
            if ("toString".equals(method.getName())) {
                String s = this.node.getNodeName();
                s = s.replace("#", "");
                return s;
            }
            Object result = method.invoke((Object)this.node, args);
            return result;
        }

        private Integer getUserData(String key) {
            if (this.node.getUserData(key) != null) {
                return (Integer)this.node.getUserData(key);
            }
            return -1;
        }
    }

    private static class LineNumberAwareSaxHandler
    extends DefaultHandler2 {
        public static final String BEGIN_LINE = "pmd:beginLine";
        public static final String BEGIN_COLUMN = "pmd:beginColumn";
        public static final String END_LINE = "pmd:endLine";
        public static final String END_COLUMN = "pmd:endColumn";
        private Stack<org.w3c.dom.Node> nodeStack = new Stack();
        private StringBuilder text = new StringBuilder();
        private int beginLineText = -1;
        private int beginColumnText = -1;
        private Locator locator;
        private final DocumentBuilder documentBuilder = new DocumentBuilderFactoryImpl().newDocumentBuilder();
        private final Document document = this.documentBuilder.newDocument();
        private boolean cdataEnded = false;
        private boolean coalescing;
        private boolean expandEntityReferences;
        private boolean ignoringComments;
        private boolean ignoringElementContentWhitespace;
        private boolean namespaceAware;

        public LineNumberAwareSaxHandler(XmlParserOptions options) throws ParserConfigurationException {
            this.coalescing = options.isCoalescing();
            this.expandEntityReferences = options.isExpandEntityReferences();
            this.ignoringComments = options.isIgnoringComments();
            this.ignoringElementContentWhitespace = options.isIgnoringElementContentWhitespace();
            this.namespaceAware = options.isNamespaceAware();
        }

        public Document getDocument() {
            return this.document;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.addTextIfNeeded(false);
            Element element = this.namespaceAware ? this.document.createElementNS(uri, qName) : this.document.createElement(qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr a;
                String attQName = attributes.getQName(i);
                String attNamespaceURI = attributes.getURI(i);
                String attValue = attributes.getValue(i);
                if (this.namespaceAware) {
                    a = this.document.createAttributeNS(attNamespaceURI, attQName);
                    element.setAttributeNodeNS(a);
                } else {
                    a = this.document.createAttribute(attQName);
                    element.setAttributeNode(a);
                }
                a.setValue(attValue);
            }
            element.setUserData(BEGIN_LINE, this.locator.getLineNumber(), null);
            element.setUserData(BEGIN_COLUMN, this.locator.getColumnNumber(), null);
            this.nodeStack.push(element);
        }

        private void addTextIfNeeded(boolean alwaysAdd) {
            if (this.text.length() > 0) {
                this.addTextNode(this.text.toString(), this.cdataEnded || alwaysAdd);
                this.text.setLength(0);
                this.cdataEnded = false;
            }
        }

        private void addTextNode(String s, boolean alwaysAdd) {
            if (alwaysAdd || !this.ignoringElementContentWhitespace || s.trim().length() > 0) {
                Text textNode = this.document.createTextNode(s);
                textNode.setUserData(BEGIN_LINE, this.beginLineText, null);
                textNode.setUserData(BEGIN_COLUMN, this.beginColumnText, null);
                textNode.setUserData(END_LINE, this.locator.getLineNumber(), null);
                textNode.setUserData(END_COLUMN, this.locator.getColumnNumber(), null);
                this.appendChild(textNode);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.characters(ch, start, length);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.text.length() == 0) {
                this.beginLineText = this.locator.getLineNumber();
                this.beginColumnText = this.locator.getColumnNumber();
            }
            this.text.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.addTextIfNeeded(false);
            org.w3c.dom.Node element = this.nodeStack.pop();
            element.setUserData(END_LINE, this.locator.getLineNumber(), null);
            element.setUserData(END_COLUMN, this.locator.getColumnNumber(), null);
            this.appendChild(element);
        }

        @Override
        public void startDocument() throws SAXException {
            this.document.setUserData(BEGIN_LINE, this.locator.getLineNumber(), null);
            this.document.setUserData(BEGIN_COLUMN, this.locator.getColumnNumber(), null);
        }

        @Override
        public void endDocument() throws SAXException {
            this.addTextIfNeeded(false);
            this.document.setUserData(END_LINE, this.locator.getLineNumber(), null);
            this.document.setUserData(END_COLUMN, this.locator.getColumnNumber(), null);
        }

        @Override
        public void startCDATA() throws SAXException {
            if (!this.coalescing) {
                this.addTextIfNeeded(true);
            }
        }

        @Override
        public void endCDATA() throws SAXException {
            if (!this.coalescing) {
                CDATASection cdataSection = this.document.createCDATASection(this.text.toString());
                cdataSection.setUserData(BEGIN_LINE, this.beginLineText, null);
                cdataSection.setUserData(BEGIN_COLUMN, this.beginColumnText, null);
                cdataSection.setUserData(END_LINE, this.locator.getLineNumber(), null);
                cdataSection.setUserData(END_COLUMN, this.locator.getColumnNumber(), null);
                this.appendChild(cdataSection);
                this.text.setLength(0);
                this.cdataEnded = true;
            }
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (!this.ignoringComments) {
                this.addTextIfNeeded(false);
                Comment comment = this.document.createComment(new String(ch, start, length));
                comment.setUserData(BEGIN_LINE, this.locator.getLineNumber(), null);
                comment.setUserData(BEGIN_COLUMN, this.locator.getColumnNumber(), null);
                comment.setUserData(END_LINE, this.locator.getLineNumber(), null);
                comment.setUserData(END_COLUMN, this.locator.getColumnNumber(), null);
                this.appendChild(comment);
            }
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            DocumentType docType = this.documentBuilder.getDOMImplementation().createDocumentType(name, publicId, systemId);
            docType.setUserData(BEGIN_LINE, this.locator.getLineNumber(), null);
            docType.setUserData(BEGIN_COLUMN, this.locator.getColumnNumber(), null);
            this.document.appendChild(docType);
        }

        @Override
        public void startEntity(String name) throws SAXException {
            if (!this.expandEntityReferences) {
                this.addTextIfNeeded(false);
            }
        }

        @Override
        public void endEntity(String name) throws SAXException {
            if (!this.expandEntityReferences) {
                EntityReference entity = this.document.createEntityReference(name);
                entity.setUserData(BEGIN_LINE, this.beginLineText, null);
                entity.setUserData(BEGIN_COLUMN, this.beginColumnText, null);
                entity.setUserData(END_LINE, this.locator.getLineNumber(), null);
                entity.setUserData(END_COLUMN, this.locator.getColumnNumber(), null);
                this.appendChild(entity);
                this.text.setLength(0);
            }
        }

        @Override
        public void endDTD() throws SAXException {
            DocumentType doctype = this.document.getDoctype();
            doctype.setUserData(END_LINE, this.locator.getLineNumber(), null);
            doctype.setUserData(END_COLUMN, this.locator.getColumnNumber(), null);
        }

        @Override
        public void internalEntityDecl(String name, String value) throws SAXException {
            ChangeableEntity entity = new ChangeableEntity(this.document, name);
            entity.appendChild(this.document.createTextNode(value));
            NamedNodeMap entities = this.document.getDoctype().getEntities();
            entities.setNamedItem((org.w3c.dom.Node)((Object)entity));
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            ProcessingInstruction pi = this.document.createProcessingInstruction(target, data);
            this.appendChild(pi);
        }

        private void appendChild(org.w3c.dom.Node node) {
            if (this.nodeStack.isEmpty()) {
                this.document.appendChild(node);
            } else {
                this.nodeStack.peek().appendChild(node);
            }
        }

        private static class ChangeableEntity
        extends EntityImpl {
            public ChangeableEntity(Document document, String name) {
                super((CoreDocumentImpl)document, name);
                this.flags = (short)(this.flags & 0xFFFFFFFE);
            }
        }
    }
}

