/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vf;

import apex.jorje.semantic.symbol.type.BasicType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.ParserOptions;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.vf.ApexClassPropertyTypesVisitor;
import net.sourceforge.pmd.lang.vf.DataType;
import net.sourceforge.pmd.lang.vf.SalesforceFieldTypes;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.tuple.Pair;

class ApexClassPropertyTypes
extends SalesforceFieldTypes {
    private static final Logger LOGGER = Logger.getLogger(ApexClassPropertyTypes.class.getName());
    private static final String APEX_CLASS_FILE_SUFFIX = ".cls";

    ApexClassPropertyTypes() {
    }

    @Override
    public void findDataType(String expression, List<Path> apexDirectories) {
        String[] parts = expression.split("\\.");
        if (parts.length >= 2) {
            String className = parts[0];
            for (Path apexDirectory : apexDirectories) {
                Path apexFilePath = apexDirectory.resolve(className + APEX_CLASS_FILE_SUFFIX);
                if (!Files.exists(apexFilePath, new LinkOption[0]) || !Files.isRegularFile(apexFilePath, new LinkOption[0])) continue;
                Parser parser = this.getApexParser();
                try (BufferedReader reader = Files.newBufferedReader(apexFilePath, StandardCharsets.UTF_8);){
                    Node node = parser.parse(apexFilePath.toString(), (Reader)reader);
                    ApexClassPropertyTypesVisitor visitor = new ApexClassPropertyTypesVisitor();
                    visitor.visit((ApexNode)node, null);
                    for (Pair<String, BasicType> variable : visitor.getVariables()) {
                        this.putDataType((String)variable.getKey(), DataType.fromBasicType((BasicType)variable.getValue()));
                    }
                }
                catch (IOException e) {
                    throw new ContextedRuntimeException((Throwable)e).addContextValue("expression", (Object)expression).addContextValue("apexFilePath", (Object)apexFilePath);
                }
                if (!this.containsExpression(expression)) continue;
                break;
            }
        }
    }

    @Override
    protected DataType putDataType(String name, DataType dataType) {
        DataType previousType = super.putDataType(name, dataType);
        if (previousType != null && !previousType.equals((Object)dataType)) {
            super.putDataType(name, DataType.Unknown);
            LOGGER.warning("Conflicting types for " + name + ". CurrentType=" + (Object)((Object)dataType) + ", PreviousType=" + (Object)((Object)previousType));
        }
        return previousType;
    }

    private Parser getApexParser() {
        LanguageVersion languageVersion = LanguageRegistry.getLanguage((String)"Apex").getDefaultVersion();
        ParserOptions parserOptions = languageVersion.getLanguageVersionHandler().getDefaultParserOptions();
        return languageVersion.getLanguageVersionHandler().getParser(parserOptions);
    }
}

