/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vf.rule.security;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.vf.ast.ASTArguments;
import net.sourceforge.pmd.lang.vf.ast.ASTAttribute;
import net.sourceforge.pmd.lang.vf.ast.ASTContent;
import net.sourceforge.pmd.lang.vf.ast.ASTDotExpression;
import net.sourceforge.pmd.lang.vf.ast.ASTElExpression;
import net.sourceforge.pmd.lang.vf.ast.ASTElement;
import net.sourceforge.pmd.lang.vf.ast.ASTExpression;
import net.sourceforge.pmd.lang.vf.ast.ASTHtmlScript;
import net.sourceforge.pmd.lang.vf.ast.ASTIdentifier;
import net.sourceforge.pmd.lang.vf.ast.ASTLiteral;
import net.sourceforge.pmd.lang.vf.ast.ASTNegationExpression;
import net.sourceforge.pmd.lang.vf.ast.ASTText;
import net.sourceforge.pmd.lang.vf.ast.AbstractVFNode;
import net.sourceforge.pmd.lang.vf.rule.AbstractVfRule;

public class VfUnescapeElRule
extends AbstractVfRule {
    private static final String A_CONST = "a";
    private static final String APEXIFRAME_CONST = "apex:iframe";
    private static final String IFRAME_CONST = "iframe";
    private static final String HREF = "href";
    private static final String SRC = "src";
    private static final String APEX_PARAM = "apex:param";
    private static final String VALUE = "value";
    private static final String ITEM_VALUE = "itemvalue";
    private static final String ESCAPE = "escape";
    private static final String ITEM_ESCAPED = "itemescaped";
    private static final String APEX_OUTPUT_TEXT = "apex:outputtext";
    private static final String APEX_PAGE_MESSAGE = "apex:pagemessage";
    private static final String APEX_PAGE_MESSAGES = "apex:pagemessages";
    private static final String APEX_SELECT_OPTION = "apex:selectoption";
    private static final String FALSE = "false";
    private static final Pattern ON_EVENT = Pattern.compile("^on(\\w)+$");
    private static final Pattern PLACEHOLDERS = Pattern.compile("\\{(\\w|,|\\.|'|:|\\s)*\\}");

    @Override
    public Object visit(ASTHtmlScript node, Object data) {
        this.checkIfCorrectlyEscaped(node, data);
        return super.visit(node, data);
    }

    private void checkIfCorrectlyEscaped(ASTHtmlScript node, Object data) {
        ASTText prevText = null;
        for (int i = 0; i < node.getNumChildren(); ++i) {
            Node n = node.getChild(i);
            if (n instanceof ASTText) {
                prevText = (ASTText)n;
                continue;
            }
            if (!(n instanceof ASTElExpression)) continue;
            this.processElInScriptContext((ASTElExpression)n, prevText, data);
        }
    }

    private void processElInScriptContext(ASTElExpression elExpression, ASTText prevText, Object data) {
        boolean quoted = false;
        boolean jsonParse = false;
        if (prevText != null) {
            jsonParse = this.isJsonParse(prevText);
            if (this.isUnbalanced(prevText.getImage(), '\'') || this.isUnbalanced(prevText.getImage(), '\"')) {
                quoted = true;
            }
        }
        if (quoted) {
            if (!jsonParse && !this.startsWithSafeResource(elExpression) && !this.containsSafeFields(elExpression) && this.doesElContainAnyUnescapedIdentifiers(elExpression, EnumSet.of(Escaping.JSENCODE, Escaping.JSINHTMLENCODE))) {
                this.addViolation(data, elExpression);
            }
        } else if (!this.startsWithSafeResource(elExpression) && !this.containsSafeFields(elExpression)) {
            boolean hasUnscaped = this.doesElContainAnyUnescapedIdentifiers(elExpression, EnumSet.of(Escaping.JSENCODE, Escaping.JSINHTMLENCODE));
            if (!jsonParse || hasUnscaped) {
                this.addViolation(data, elExpression);
            }
        }
    }

    private boolean isJsonParse(ASTText prevText) {
        String text = prevText.getImage().endsWith("'") ? prevText.getImage().substring(0, prevText.getImage().length() - 1) : prevText.getImage();
        return text.endsWith("JSON.parse(") || text.endsWith("jQuery.parseJSON(") || text.endsWith("$.parseJSON(");
    }

    private boolean isUnbalanced(String image, char pattern) {
        char[] array = image.toCharArray();
        boolean foundPattern = false;
        for (int i = array.length - 1; i > 0; --i) {
            if (array[i] == pattern) {
                foundPattern = true;
            }
            if (array[i] != ';') continue;
            return foundPattern;
        }
        return foundPattern;
    }

    @Override
    public Object visit(ASTElement node, Object data) {
        if (this.doesTagSupportEscaping(node)) {
            this.checkApexTagsThatSupportEscaping(node, data);
        } else {
            this.checkLimitedFlags(node, data);
            this.checkAllOnEventTags(node, data);
        }
        return super.visit(node, data);
    }

    private void checkLimitedFlags(ASTElement node, Object data) {
        switch (node.getName().toLowerCase(Locale.ROOT)) {
            case "iframe": 
            case "apex:iframe": 
            case "a": {
                break;
            }
            default: {
                return;
            }
        }
        List attributes = node.findChildrenOfType(ASTAttribute.class);
        boolean isEL = false;
        HashSet<ASTElExpression> toReport = new HashSet<ASTElExpression>();
        for (ASTAttribute attr : attributes) {
            ASTElExpression el;
            String lowerCaseImage;
            String name = attr.getName().toLowerCase(Locale.ROOT);
            if (!HREF.equalsIgnoreCase(name) && !SRC.equalsIgnoreCase(name)) continue;
            boolean startingWithSlashText = false;
            ASTText attrText = (ASTText)attr.getFirstDescendantOfType(ASTText.class);
            if (attrText != null && 0 == attrText.getIndexInParent() && ((lowerCaseImage = attrText.getImage().toLowerCase(Locale.ROOT)).startsWith("/") || lowerCaseImage.startsWith("http") || lowerCaseImage.startsWith("mailto"))) {
                startingWithSlashText = true;
            }
            if (startingWithSlashText) continue;
            List elsInVal = attr.findDescendantsOfType(ASTElExpression.class);
            Iterator iterator = elsInVal.iterator();
            while (iterator.hasNext() && !this.startsWithSlashLiteral(el = (ASTElExpression)iterator.next()) && !this.startsWithSafeResource(el)) {
                if (!this.doesElContainAnyUnescapedIdentifiers(el, Escaping.URLENCODE)) continue;
                isEL = true;
                toReport.add(el);
            }
        }
        if (isEL) {
            for (ASTElExpression expr : toReport) {
                this.addViolation(data, expr);
            }
        }
    }

    private void checkAllOnEventTags(ASTElement node, Object data) {
        List attributes = node.findChildrenOfType(ASTAttribute.class);
        boolean isEL = false;
        HashSet<ASTElExpression> toReport = new HashSet<ASTElExpression>();
        for (ASTAttribute attr : attributes) {
            String name = attr.getName().toLowerCase(Locale.ROOT);
            if (!ON_EVENT.matcher(name).matches()) continue;
            List elsInVal = attr.findDescendantsOfType(ASTElExpression.class);
            for (ASTElExpression el : elsInVal) {
                if (this.startsWithSafeResource(el) || !this.doesElContainAnyUnescapedIdentifiers(el, EnumSet.of(Escaping.ANY))) continue;
                isEL = true;
                toReport.add(el);
            }
        }
        if (isEL) {
            for (ASTElExpression expr : toReport) {
                this.addViolation(data, expr);
            }
        }
    }

    private boolean startsWithSafeResource(ASTElExpression el) {
        ASTExpression expression = (ASTExpression)el.getFirstChildOfType(ASTExpression.class);
        if (expression != null) {
            ASTNegationExpression negation = (ASTNegationExpression)expression.getFirstChildOfType(ASTNegationExpression.class);
            if (negation != null) {
                return true;
            }
            ASTIdentifier id = (ASTIdentifier)expression.getFirstChildOfType(ASTIdentifier.class);
            if (id != null) {
                String lowerCaseId = id.getImage().toLowerCase(Locale.ROOT);
                List args = expression.findChildrenOfType(ASTArguments.class);
                if (!args.isEmpty()) {
                    switch (lowerCaseId) {
                        case "urlfor": 
                        case "casesafeid": 
                        case "begins": 
                        case "contains": 
                        case "len": 
                        case "getrecordids": 
                        case "linkto": 
                        case "sqrt": 
                        case "round": 
                        case "mod": 
                        case "log": 
                        case "ln": 
                        case "exp": 
                        case "abs": 
                        case "floor": 
                        case "ceiling": 
                        case "nullvalue": 
                        case "isnumber": 
                        case "isnull": 
                        case "isnew": 
                        case "isblank": 
                        case "isclone": 
                        case "year": 
                        case "month": 
                        case "day": 
                        case "datetimevalue": 
                        case "datevalue": 
                        case "date": 
                        case "now": 
                        case "today": {
                            return true;
                        }
                    }
                } else {
                    switch (lowerCaseId) {
                        case "$action": 
                        case "$page": 
                        case "$site": 
                        case "$resource": 
                        case "$label": 
                        case "$objecttype": 
                        case "$component": 
                        case "$remoteaction": {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean startsWithSlashLiteral(ASTElExpression elExpression) {
        String lowerCaseLiteral;
        ASTLiteral literal;
        ASTExpression expression = (ASTExpression)elExpression.getFirstChildOfType(ASTExpression.class);
        return expression != null && (literal = (ASTLiteral)expression.getFirstChildOfType(ASTLiteral.class)) != null && literal.getIndexInParent() == 0 && ((lowerCaseLiteral = literal.getImage().toLowerCase(Locale.ROOT)).startsWith("'/") || lowerCaseLiteral.startsWith("\"/") || lowerCaseLiteral.startsWith("'http") || lowerCaseLiteral.startsWith("\"http"));
    }

    private void checkApexTagsThatSupportEscaping(ASTElement node, Object data) {
        List attributes = node.findChildrenOfType(ASTAttribute.class);
        HashSet<ASTElExpression> toReport = new HashSet<ASTElExpression>();
        boolean isUnescaped = false;
        boolean isEL = false;
        boolean hasPlaceholders = false;
        for (ASTAttribute attr : attributes) {
            String name;
            switch (name = attr.getName().toLowerCase(Locale.ROOT)) {
                case "escape": 
                case "itemescaped": {
                    ASTText text = (ASTText)attr.getFirstDescendantOfType(ASTText.class);
                    if (text == null || !text.getImage().equalsIgnoreCase(FALSE)) break;
                    isUnescaped = true;
                    break;
                }
                case "value": 
                case "itemvalue": {
                    List elsInVal = attr.findDescendantsOfType(ASTElExpression.class);
                    for (ASTElExpression el : elsInVal) {
                        if (this.startsWithSafeResource(el) || !this.doesElContainAnyUnescapedIdentifiers(el, Escaping.HTMLENCODE)) continue;
                        isEL = true;
                        toReport.add(el);
                    }
                    ASTText textValue = (ASTText)attr.getFirstDescendantOfType(ASTText.class);
                    if (textValue == null || !PLACEHOLDERS.matcher(textValue.getImage()).matches()) break;
                    hasPlaceholders = true;
                    break;
                }
            }
        }
        if (hasPlaceholders && isUnescaped) {
            for (ASTElExpression expr : this.hasELInInnerElements(node)) {
                this.addViolation(data, expr);
            }
        }
        if (isEL && isUnescaped) {
            for (ASTElExpression expr : toReport) {
                this.addViolation(data, expr);
            }
        }
    }

    private boolean doesElContainAnyUnescapedIdentifiers(ASTElExpression elExpression, Escaping escape) {
        return this.doesElContainAnyUnescapedIdentifiers(elExpression, EnumSet.of(escape));
    }

    private boolean doesElContainAnyUnescapedIdentifiers(ASTElExpression elExpression, EnumSet<Escaping> escapes) {
        if (elExpression == null) {
            return false;
        }
        HashSet<ASTIdentifier> nonEscapedIds = new HashSet<ASTIdentifier>();
        List exprs = elExpression.findChildrenOfType(ASTExpression.class);
        for (ASTExpression expr : exprs) {
            if (this.innerContainsSafeFields(expr)) continue;
            List ids = expr.findChildrenOfType(ASTIdentifier.class);
            for (ASTIdentifier id : ids) {
                boolean isEscaped = false;
                block2: for (Escaping e : escapes) {
                    if (id.getImage().equalsIgnoreCase(e.toString())) {
                        isEscaped = true;
                        break;
                    }
                    if (!e.equals((Object)Escaping.ANY)) continue;
                    for (Escaping esc : Escaping.values()) {
                        if (!id.getImage().equalsIgnoreCase(esc.toString())) continue;
                        isEscaped = true;
                        continue block2;
                    }
                }
                if (isEscaped) continue;
                nonEscapedIds.add(id);
            }
        }
        return !nonEscapedIds.isEmpty();
    }

    private boolean containsSafeFields(AbstractVFNode expression) {
        ASTExpression ex = (ASTExpression)expression.getFirstChildOfType(ASTExpression.class);
        return ex != null && this.innerContainsSafeFields(ex);
    }

    private boolean innerContainsSafeFields(AbstractVFNode expression) {
        for (int i = 0; i < expression.getNumChildren(); ++i) {
            Node child = expression.getChild(i);
            if (child instanceof ASTIdentifier) {
                switch (child.getImage().toLowerCase(Locale.ROOT)) {
                    case "id": 
                    case "size": 
                    case "caseNumber": {
                        return true;
                    }
                }
            }
            if (child instanceof ASTArguments && this.containsSafeFields((ASTArguments)child)) {
                return true;
            }
            if (!(child instanceof ASTDotExpression) || !this.innerContainsSafeFields((ASTDotExpression)child)) continue;
            return true;
        }
        return false;
    }

    private boolean doesTagSupportEscaping(ASTElement node) {
        if (node.getName() == null) {
            return false;
        }
        switch (node.getName().toLowerCase(Locale.ROOT)) {
            case "apex:outputtext": 
            case "apex:pagemessage": 
            case "apex:pagemessages": 
            case "apex:selectoption": {
                return true;
            }
        }
        return false;
    }

    private Set<ASTElExpression> hasELInInnerElements(ASTElement node) {
        HashSet<ASTElExpression> toReturn = new HashSet<ASTElExpression>();
        ASTContent content = (ASTContent)node.getFirstChildOfType(ASTContent.class);
        if (content != null) {
            List innerElements = content.findChildrenOfType(ASTElement.class);
            for (ASTElement element : innerElements) {
                if (!element.getName().equalsIgnoreCase(APEX_PARAM)) continue;
                List innerAttributes = element.findChildrenOfType(ASTAttribute.class);
                for (ASTAttribute attrib : innerAttributes) {
                    List elsInVal = attrib.findDescendantsOfType(ASTElExpression.class);
                    for (ASTElExpression el : elsInVal) {
                        if (this.startsWithSafeResource(el) || !this.doesElContainAnyUnescapedIdentifiers(el, Escaping.HTMLENCODE)) continue;
                        toReturn.add(el);
                    }
                }
            }
        }
        return toReturn;
    }

    static enum Escaping {
        HTMLENCODE("HTMLENCODE"),
        URLENCODE("URLENCODE"),
        JSINHTMLENCODE("JSINHTMLENCODE"),
        JSENCODE("JSENCODE"),
        ANY("ANY");

        private final String text;

        private Escaping(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

