/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.controls;

import java.util.Locale;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import net.sourceforge.pmd.util.fxdesigner.model.MetricResult;

public class MetricResultListCell
extends ListCell<MetricResult> {
    protected void updateItem(MetricResult item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.setText(item.getKey().name() + " = " + this.niceDoubleString(item.getValue()));
        }
    }

    private String niceDoubleString(double val) {
        if (val == (double)((int)val)) {
            return String.valueOf((int)val);
        }
        return String.format(Locale.ROOT, "%.4f", val);
    }

    public static Callback<ListView<MetricResult>, MetricResultListCell> callback() {
        return param -> new MetricResultListCell();
    }
}

