/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.controls;

import java.util.Collection;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import net.sourceforge.pmd.util.fxdesigner.util.TextAwareNodeWrapper;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyledDocument;

public class XpathViolationListCell
extends ListCell<TextAwareNodeWrapper> {
    protected void updateItem(TextAwareNodeWrapper item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.setGraphic((Node)XpathViolationListCell.richTextForNode(item));
        }
    }

    private static TextFlow richTextForNode(TextAwareNodeWrapper node) {
        StyledDocument<Collection<String>, String, Collection<String>> richText = node.getNodeRichText();
        TextFlow result = new TextFlow();
        int lastSpanEnd = 0;
        for (StyleSpan span : richText.getStyleSpans(0, richText.length())) {
            String spanText = richText.getText(lastSpanEnd, lastSpanEnd + span.getLength());
            int truncateTo = spanText.indexOf("\n");
            Text text = new Text(truncateTo < 0 ? spanText : spanText.substring(0, truncateTo));
            text.getStyleClass().addAll((Collection)span.getStyle());
            result.getChildren().add((Object)text);
            lastSpanEnd += text.getText().length();
            if (truncateTo <= 0) continue;
            break;
        }
        if (lastSpanEnd < richText.length()) {
            result.getChildren().add((Object)new Text("..."));
        }
        return result;
    }
}

