/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.controls;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class TreeViewWrapper<T> {
    private final TreeView<T> wrapped;
    private Method treeViewFirstVisibleMethod;
    private Method treeViewLastVisibleMethod;
    private Object virtualFlow = null;

    public TreeViewWrapper(TreeView<T> wrapped) {
        Objects.requireNonNull(wrapped);
        this.wrapped = wrapped;
        this.initialiseTreeViewReflection();
    }

    private void initialiseTreeViewReflection() {
        Skin<?> dftSkin = new TreeView<Object>(){

            protected Skin<?> createDefaultSkin() {
                return super.createDefaultSkin();
            }
        }.createDefaultSkin();
        Object flow = TreeViewWrapper.getVirtualFlow(dftSkin);
        if (flow == null) {
            return;
        }
        this.treeViewFirstVisibleMethod = MethodUtils.getMatchingMethod(flow.getClass(), (String)"getFirstVisibleCell", (Class[])new Class[0]);
        this.treeViewLastVisibleMethod = MethodUtils.getMatchingMethod(flow.getClass(), (String)"getLastVisibleCell", (Class[])new Class[0]);
    }

    public boolean isIndexVisible(int index) {
        if (this.virtualFlow == null && this.wrapped.getSkin() == null) {
            return false;
        }
        if (this.virtualFlow == null && this.wrapped.getSkin() != null) {
            this.virtualFlow = TreeViewWrapper.getVirtualFlow(this.wrapped.getSkin());
        }
        if (this.virtualFlow == null) {
            return false;
        }
        Optional<TreeCell<T>> first = this.getFirstVisibleCell();
        Optional<TreeCell<T>> last = this.getLastVisibleCell();
        return first.isPresent() && last.isPresent() && first.get().getIndex() <= index && last.get().getIndex() >= index;
    }

    private Optional<TreeCell<T>> getCellFromAccessor(Method accessor) {
        return Optional.ofNullable(accessor).map(m -> {
            try {
                TreeCell cell = (TreeCell)m.invoke(this.virtualFlow, new Object[0]);
                return cell;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    private Optional<TreeCell<T>> getFirstVisibleCell() {
        return this.getCellFromAccessor(this.treeViewFirstVisibleMethod);
    }

    private Optional<TreeCell<T>> getLastVisibleCell() {
        return this.getCellFromAccessor(this.treeViewLastVisibleMethod);
    }

    private static Object getVirtualFlow(Skin<?> skin) {
        try {
            return FieldUtils.readField(skin, (String)"flow", (boolean)true);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }
}

