/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.codearea;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.NamedArg;
import javafx.scene.control.IndexRange;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.NodeStyleSpan;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.StyleLayer;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.SyntaxHighlightingCodeArea;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.UniformStyleCollection;
import org.fxmisc.richtext.model.StyleSpans;

public class HighlightLayerCodeArea<K extends Enum<K>>
extends SyntaxHighlightingCodeArea {
    private final Map<K, StyleLayer> layersById;

    public HighlightLayerCodeArea(@NamedArg(value="idEnum") Class<K> idEnum) {
        this.layersById = EnumSet.allOf(idEnum).stream().collect(Collectors.toConcurrentMap(id -> id, id -> new StyleLayer()));
    }

    public void styleNodes(Collection<? extends Node> nodes, K layerId, boolean resetLayer) {
        Objects.requireNonNull(nodes, "Pass an empty collection to represent absence, not null!");
        if (nodes.isEmpty() && resetLayer) {
            this.clearStyleLayer(layerId);
            return;
        }
        List<NodeStyleSpan> wrappedNodes = nodes.stream().map(n -> NodeStyleSpan.fromNode(n, this)).collect(Collectors.toList());
        UniformStyleCollection collection = new UniformStyleCollection(Collections.singleton(((LayerId)layerId).getStyleClass()), wrappedNodes);
        this.updateStyling(() -> this.layersById.get(layerId).styleNodes(resetLayer, collection));
    }

    private void updateStyling(Runnable update) {
        update.run();
        try {
            this.setStyleSpans(0, this.recomputePainting());
        }
        catch (Exception e) {
            if ("StyleSpan's length cannot be negative".equals(e.getMessage()) || e.getMessage().contains("is not a valid range within")) {
                return;
            }
            throw new RuntimeException("Unhandled error while recomputing the styling", e);
        }
    }

    public void clearStyleLayers() {
        this.updateStyling(() -> {
            this.layersById.values().forEach(StyleLayer::clearStyles);
            this.clearSyntaxHighlighting();
        });
    }

    public void clearStyleLayer(K id) {
        this.updateStyling(this.layersById.get(id)::clearStyles);
    }

    private StyleSpans<Collection<String>> recomputePainting() {
        List allSpans = this.layersById.values().stream().flatMap(layer -> layer.getCollections().stream()).filter(c -> !c.isEmpty()).map(UniformStyleCollection::toSpans).collect(Collectors.toList());
        if (allSpans.isEmpty()) {
            return (StyleSpans)this.syntaxHighlight.getOrElse(this.emptySpan());
        }
        if (this.syntaxHighlight.getOpt().map(StyleSpans::length).filter(l -> l.intValue() != this.getLength()).isPresent()) {
            this.updateSyntaxHighlightingSynchronously();
        }
        this.syntaxHighlight.ifPresent(allSpans::add);
        StyleSpans base = (StyleSpans)allSpans.get(0);
        return allSpans.stream().filter(spans -> spans != base).filter(spans -> spans.length() <= this.getLength()).reduce(base, (accumulator, elt) -> accumulator.overlay(elt, SyntaxHighlightingCodeArea::additiveOverlay));
    }

    @Override
    protected final StyleSpans<Collection<String>> styleSyntaxHighlightChange(Optional<StyleSpans<Collection<String>>> oldSyntax, StyleSpans<Collection<String>> newSyntax) {
        StyleSpans currentSpans = this.getStyleSpans(new IndexRange(0, this.getLength()));
        StyleSpans base = oldSyntax.map(s -> HighlightLayerCodeArea.subtract((StyleSpans<Collection<String>>)currentSpans, (StyleSpans<Collection<String>>)s)).orElse(currentSpans);
        return Optional.ofNullable(newSyntax).map(s -> base.overlay(s, SyntaxHighlightingCodeArea::additiveOverlay)).orElse(base).subView(0, this.getLength());
    }

    private static StyleSpans<Collection<String>> subtract(StyleSpans<Collection<String>> base, StyleSpans<Collection<String>> diff) {
        return base.overlay(diff, (style1, style2) -> {
            if (style2.isEmpty()) {
                return style1;
            }
            HashSet styles = new HashSet(style1);
            styles.removeAll((Collection<?>)style2);
            return styles;
        });
    }

    public static interface LayerId {
        public String getStyleClass();
    }
}

