/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.util.beans;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.util.fxdesigner.util.beans.BeanModelNode;
import net.sourceforge.pmd.util.fxdesigner.util.beans.BeanModelNodeSeq;
import net.sourceforge.pmd.util.fxdesigner.util.beans.BeanNodeVisitor;

public class SimpleBeanModelNode
extends BeanModelNode {
    private final Class<?> nodeType;
    private final Map<String, Object> propertyValues = new HashMap<String, Object>();
    private final Map<String, Class<?>> propertyTypes = new HashMap();
    private final Map<Class<?>, BeanModelNode> children = new HashMap();
    private final Set<BeanModelNodeSeq<?>> sequenceProperties = new HashSet();

    public SimpleBeanModelNode(Class<?> nodeType) {
        this.nodeType = nodeType;
    }

    public void addProperty(String propertyKey, Object value, Class<?> type) {
        this.propertyValues.put(propertyKey, value);
        this.propertyTypes.put(propertyKey, type);
    }

    public void addChild(BeanModelNodeSeq<?> seq) {
        this.sequenceProperties.add(seq);
    }

    public void addChild(SimpleBeanModelNode child) {
        this.children.put(child.nodeType, child);
    }

    public Map<String, Object> getSettingsValues() {
        return Collections.unmodifiableMap(this.propertyValues);
    }

    public Map<String, Class<?>> getSettingsTypes() {
        return Collections.unmodifiableMap(this.propertyTypes);
    }

    public Map<Class<?>, BeanModelNode> getChildrenByType() {
        return Collections.unmodifiableMap(this.children);
    }

    @Override
    public List<? extends BeanModelNode> getChildrenNodes() {
        HashSet<BeanModelNode> allChildren = new HashSet<BeanModelNode>(this.children.values());
        allChildren.addAll(this.sequenceProperties);
        return new ArrayList<BeanModelNode>(allChildren);
    }

    public Set<BeanModelNodeSeq<?>> getSequenceProperties() {
        return this.sequenceProperties;
    }

    public Class<?> getNodeType() {
        return this.nodeType;
    }

    protected <U> void accept(BeanNodeVisitor<U> visitor, U data) {
        visitor.visit(this, data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleBeanModelNode that = (SimpleBeanModelNode)o;
        return Objects.equals(this.nodeType, that.nodeType) && Objects.equals(this.propertyValues, that.propertyValues) && Objects.equals(this.propertyTypes, that.propertyTypes) && Objects.equals(this.children, that.children) && Objects.equals(this.sequenceProperties, that.sequenceProperties);
    }

    public int hashCode() {
        return Objects.hash(this.nodeType, this.propertyValues, this.propertyTypes, this.children, this.sequenceProperties);
    }
}

