/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.popups;

import java.net.URL;
import java.util.Objects;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.stage.Stage;
import net.sourceforge.pmd.properties.PropertyTypeId;
import net.sourceforge.pmd.properties.ValueParser;
import net.sourceforge.pmd.properties.ValueParserConstants;
import net.sourceforge.pmd.util.fxdesigner.util.DesignerUtil;
import net.sourceforge.pmd.util.fxdesigner.util.PropertyDescriptorSpec;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.reactfx.util.Try;
import org.reactfx.value.Var;

public class EditPropertyDialogController
implements Initializable {
    private final Var<PropertyTypeId> typeId = Var.newSimpleVar((Object)PropertyTypeId.STRING);
    private final Var<Runnable> commitHandler = Var.newSimpleVar(null);
    private Var<PropertyDescriptorSpec> backingDescriptor = Var.newSimpleVar(null);
    private Var<ObservableList<PropertyDescriptorSpec>> backingDescriptorList = Var.newSimpleVar(null);
    private ValidationSupport validationSupport = new ValidationSupport();
    @FXML
    private TextField nameField;
    @FXML
    private TextField descriptionField;
    @FXML
    private ChoiceBox<PropertyTypeId> typeChoiceBox;
    @FXML
    private TextField valueField;
    @FXML
    private Button commitButton;

    public EditPropertyDialogController() {
    }

    public EditPropertyDialogController(Runnable commitHandler) {
        this.commitHandler.setValue((Object)commitHandler);
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.commitButton.setOnAction(e -> {
            this.commitHandler.ifPresent(Runnable::run);
            this.getStage().close();
            this.free();
        });
        this.commitButton.disableProperty().bind((ObservableValue)this.validationSupport.invalidProperty());
        Platform.runLater(() -> {
            this.typeId.bind((ObservableValue)this.typeChoiceBox.getSelectionModel().selectedItemProperty());
            this.typeChoiceBox.setConverter(DesignerUtil.stringConverter(PropertyTypeId::getStringId, PropertyTypeId::lookupMnemonic));
            this.typeChoiceBox.getItems().addAll(PropertyTypeId.typeIdsToConstants().values());
            FXCollections.sort((ObservableList)this.typeChoiceBox.getItems());
        });
        Platform.runLater(this::registerBasicValidators);
        this.typeIdProperty().values().filter(Objects::nonNull).subscribe(this::registerTypeDependentValidators);
    }

    private Stage getStage() {
        return (Stage)this.commitButton.getScene().getWindow();
    }

    public void free() {
        this.backingDescriptor.ifPresent(PropertyDescriptorSpec::unbind);
        this.backingDescriptor.setValue(null);
        this.backingDescriptorList.setValue(null);
        this.nameProperty().setValue((Object)"");
    }

    public void bindToDescriptor(PropertyDescriptorSpec spec, ObservableList<PropertyDescriptorSpec> allDescriptors) {
        this.backingDescriptor.setValue((Object)spec);
        this.backingDescriptorList.setValue(allDescriptors);
        DesignerUtil.rewire(spec.nameProperty(), this.nameProperty(), this::setName);
        DesignerUtil.rewire(spec.typeIdProperty(), this.typeIdProperty(), this::setTypeId);
        DesignerUtil.rewire(spec.valueProperty(), this.valueProperty(), this::setValue);
        DesignerUtil.rewire(spec.descriptionProperty(), this.descriptionProperty(), this::setDescription);
    }

    private void registerBasicValidators() {
        Validator noWhitespaceName = Validator.createRegexValidator((String)"Name cannot contain whitespace", (String)"\\S*+", (Severity)Severity.ERROR);
        Validator emptyName = Validator.createEmptyValidator((String)"Name required");
        Validator uniqueName = (c, val) -> {
            long sameNameDescriptors = ((ObservableList)this.backingDescriptorList.getOrElse((Object)FXCollections.emptyObservableList())).stream().map(PropertyDescriptorSpec::getName).filter(this.getName()::equals).count();
            return new ValidationResult().addErrorIf(c, "The name must be unique", sameNameDescriptors > 1L);
        };
        this.validationSupport.registerValidator((Control)this.nameField, Validator.combine((Validator[])new Validator[]{noWhitespaceName, emptyName, uniqueName}));
        Validator noWhitespaceDescription = Validator.createRegexValidator((String)"Message cannot be whitespace", (String)"(\\s*+\\S.*)?", (Severity)Severity.ERROR);
        Validator emptyDescription = Validator.createEmptyValidator((String)"Message required");
        this.validationSupport.registerValidator((Control)this.descriptionField, Validator.combine((Validator[])new Validator[]{noWhitespaceDescription, emptyDescription}));
    }

    private void registerTypeDependentValidators(PropertyTypeId typeId) {
        Validator valueValidator = (c, val) -> ValidationResult.fromErrorIf((Control)this.valueField, (String)"The value couldn't be parsed", (boolean)Try.tryGet(() -> this.getValueParser(typeId).valueOf(this.getValue())).isFailure());
        this.validationSupport.registerValidator((Control)this.valueField, valueValidator);
    }

    private ValueParser<?> getValueParser(PropertyTypeId typeId) {
        ValueParser parser = typeId.getValueParser();
        if (typeId.isPropertyMultivalue()) {
            char delimiter = typeId.isPropertyNumeric() ? (char)',' : '|';
            parser = ValueParserConstants.multi((ValueParser)parser, (char)delimiter);
        }
        return parser;
    }

    public String getName() {
        return this.nameField.getText();
    }

    public void setName(String name) {
        this.nameField.setText(name);
    }

    public Property<String> nameProperty() {
        return this.nameField.textProperty();
    }

    public String getDescription() {
        return this.descriptionField.getText();
    }

    public void setDescription(String description) {
        this.descriptionField.setText(description);
    }

    public Property<String> descriptionProperty() {
        return this.descriptionField.textProperty();
    }

    public PropertyTypeId getTypeId() {
        return (PropertyTypeId)this.typeId.getValue();
    }

    public void setTypeId(PropertyTypeId typeId) {
        this.typeChoiceBox.getSelectionModel().select((Object)typeId);
    }

    public Var<PropertyTypeId> typeIdProperty() {
        return this.typeId;
    }

    public String getValue() {
        return this.valueField.getText();
    }

    public void setValue(String value) {
        this.valueField.setText(value);
    }

    public Property<String> valueProperty() {
        return this.valueField.textProperty();
    }
}

