/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.model;

import java.util.Optional;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RulePriority;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.rules.RuleBuilder;
import net.sourceforge.pmd.util.fxdesigner.util.PropertyDescriptorSpec;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsOwner;
import net.sourceforge.pmd.util.fxdesigner.util.beans.SettingsPersistenceUtil;
import org.reactfx.collection.LiveArrayList;
import org.reactfx.value.Var;

public class ObservableRuleBuilder
implements SettingsOwner {
    private Var<Language> language = Var.newSimpleVar((Object)LanguageRegistry.getDefaultLanguage());
    private Var<String> name = Var.newSimpleVar((Object)"");
    private Var<Class<?>> clazz = Var.newSimpleVar(null);
    private ListProperty<PropertyDescriptorSpec> ruleProperties = new SimpleListProperty(FXCollections.observableArrayList(PropertyDescriptorSpec.extractor()));
    private Var<ObservableList<String>> examples = Var.newSimpleVar((Object)new LiveArrayList());
    private Var<LanguageVersion> minimumVersion = Var.newSimpleVar(null);
    private Var<LanguageVersion> maximumVersion = Var.newSimpleVar(null);
    private Var<String> since = Var.newSimpleVar((Object)"");
    private Var<String> message = Var.newSimpleVar((Object)"");
    private Var<String> externalInfoUrl = Var.newSimpleVar((Object)"");
    private Var<String> description = Var.newSimpleVar((Object)"");
    private Var<RulePriority> priority = Var.newSimpleVar((Object)RulePriority.MEDIUM);
    private Var<Boolean> deprecated = Var.newSimpleVar((Object)false);
    private Var<Boolean> usesDfa = Var.newSimpleVar((Object)false);
    private Var<Boolean> usesMultifile = Var.newSimpleVar((Object)false);
    private Var<Boolean> usesTypeResolution = Var.newSimpleVar((Object)false);

    public Language getLanguage() {
        return (Language)this.language.getValue();
    }

    public void setLanguage(Language language) {
        this.language.setValue((Object)language);
    }

    public Var<Language> languageProperty() {
        return this.language;
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getName() {
        return (String)this.name.getValue();
    }

    public void setName(String name) {
        this.name.setValue((Object)name);
    }

    public Var<String> nameProperty() {
        return this.name;
    }

    @SettingsPersistenceUtil.PersistentProperty
    public Class<?> getClazz() {
        return (Class)this.clazz.getValue();
    }

    public void setClazz(Class<?> clazz) {
        this.clazz.setValue(clazz);
    }

    public Var<Class<?>> clazzProperty() {
        return this.clazz;
    }

    @SettingsPersistenceUtil.PersistentSequence
    public ObservableList<PropertyDescriptorSpec> getRuleProperties() {
        return this.ruleProperties.getValue();
    }

    public void setRuleProperties(ObservableList<PropertyDescriptorSpec> ruleProperties) {
        this.ruleProperties.setValue(ruleProperties);
    }

    public ListProperty<PropertyDescriptorSpec> rulePropertiesProperty() {
        return this.ruleProperties;
    }

    public LanguageVersion getMinimumVersion() {
        return (LanguageVersion)this.minimumVersion.getValue();
    }

    public void setMinimumVersion(LanguageVersion minimumVersion) {
        this.minimumVersion.setValue((Object)minimumVersion);
    }

    public Var<LanguageVersion> minimumVersionProperty() {
        return this.minimumVersion;
    }

    public LanguageVersion getMaximumVersion() {
        return (LanguageVersion)this.maximumVersion.getValue();
    }

    public void setMaximumVersion(LanguageVersion maximumVersion) {
        this.maximumVersion.setValue((Object)maximumVersion);
    }

    public Var<LanguageVersion> maximumVersionProperty() {
        return this.maximumVersion;
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getSince() {
        return (String)this.since.getValue();
    }

    public void setSince(String since) {
        this.since.setValue((Object)since);
    }

    public Var<String> sinceProperty() {
        return this.since;
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getMessage() {
        return (String)this.message.getValue();
    }

    public void setMessage(String message) {
        this.message.setValue((Object)message);
    }

    public Var<String> messageProperty() {
        return this.message;
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getExternalInfoUrl() {
        return (String)this.externalInfoUrl.getValue();
    }

    public void setExternalInfoUrl(String externalInfoUrl) {
        this.externalInfoUrl.setValue((Object)externalInfoUrl);
    }

    public Var<String> externalInfoUrlProperty() {
        return this.externalInfoUrl;
    }

    @SettingsPersistenceUtil.PersistentProperty
    public String getDescription() {
        return (String)this.description.getValue();
    }

    public void setDescription(String description) {
        this.description.setValue((Object)description);
    }

    public Var<String> descriptionProperty() {
        return this.description;
    }

    public Var<ObservableList<String>> getExamples() {
        return this.examples;
    }

    public void setExamples(ObservableList<String> examples) {
        this.examples.setValue(examples);
    }

    @SettingsPersistenceUtil.PersistentProperty
    public RulePriority getPriority() {
        return (RulePriority)this.priority.getValue();
    }

    public void setPriority(RulePriority priority) {
        this.priority.setValue((Object)priority);
    }

    public Var<RulePriority> priorityProperty() {
        return this.priority;
    }

    public boolean isDeprecated() {
        return (Boolean)this.deprecated.getValue();
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated.setValue((Object)deprecated);
    }

    public Var<Boolean> deprecatedProperty() {
        return this.deprecated;
    }

    public boolean isUsesDfa() {
        return (Boolean)this.usesDfa.getValue();
    }

    public void setUsesDfa(boolean usesDfa) {
        this.usesDfa.setValue((Object)usesDfa);
    }

    public Var<Boolean> usesDfaProperty() {
        return this.usesDfa;
    }

    public boolean isUsesMultifile() {
        return (Boolean)this.usesMultifile.getValue();
    }

    public void setUsesMultifile(boolean usesMultifile) {
        this.usesMultifile.setValue((Object)usesMultifile);
    }

    public Var<Boolean> usesMultifileProperty() {
        return this.usesMultifile;
    }

    public boolean getUsesTypeResolution() {
        return (Boolean)this.usesTypeResolution.getValue();
    }

    public void setUsesTypeResolution(boolean usesTypeResolution) {
        this.usesTypeResolution.setValue((Object)usesTypeResolution);
    }

    public Var<Boolean> usesTypeResolutionProperty() {
        return this.usesTypeResolution;
    }

    public boolean canBuild() {
        try {
            this.build();
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Optional<Rule> build() throws IllegalArgumentException {
        try {
            RuleBuilder builder = new RuleBuilder((String)this.name.getValue(), ((Class)this.clazz.getValue()).getCanonicalName(), ((Language)this.language.getValue()).getTerseName());
            builder.minimumLanguageVersion(((LanguageVersion)this.minimumVersion.getValue()).getTerseName());
            builder.maximumLanguageVersion(((LanguageVersion)this.maximumVersion.getValue()).getTerseName());
            builder.message((String)this.message.getValue());
            builder.since((String)this.since.getValue());
            builder.externalInfoUrl((String)this.externalInfoUrl.getValue());
            builder.description((String)this.description.getValue());
            builder.priority(((RulePriority)this.priority.getValue()).getPriority());
            builder.setDeprecated(((Boolean)this.deprecated.getValue()).booleanValue());
            builder.usesDFA(((Boolean)this.usesDfa.getValue()).booleanValue());
            builder.usesTyperesolution(((Boolean)this.usesTypeResolution.getValue()).booleanValue());
            builder.usesMultifile(((Boolean)this.usesMultifile.getValue()).booleanValue());
            this.ruleProperties.getValue().stream().map(PropertyDescriptorSpec::build).forEach(arg_0 -> ((RuleBuilder)builder).defineProperty(arg_0));
            ((ObservableList)this.examples.getValue()).forEach(arg_0 -> ((RuleBuilder)builder).addExample(arg_0));
            return Optional.of(builder.build());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }
}

