/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.model;

import java.util.Date;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class LogEntry {
    private final Throwable throwable;
    private final Category category;
    private final Date timestamp;

    public LogEntry(Throwable thrown, Category cat) {
        this.throwable = thrown;
        this.category = cat;
        this.timestamp = new Date();
    }

    public Throwable getThrown() {
        return this.throwable;
    }

    public String getMessage() {
        return this.throwable.getMessage();
    }

    public Category getCategory() {
        return this.category;
    }

    public String getStackTrace() {
        return ExceptionUtils.getStackTrace((Throwable)this.throwable);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public static enum Category {
        PARSE_EXCEPTION("Parse exception"),
        TYPERESOLUTION_EXCEPTION("Type resolution exception"),
        QUALIFIED_NAME_RESOLUTION_EXCEPTION("Qualified name resolution exception"),
        SYMBOL_FACADE_EXCEPTION("Symbol fa\u00e7ade exception"),
        XPATH_EVALUATION_EXCEPTION("XPath evaluation exception"),
        OTHER("Other");

        public final String name;

        private Category(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

