/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.fxdesigner.popups;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.util.StringConverter;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.util.fxdesigner.util.DesignerUtil;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.SyntaxHighlightingCodeArea;
import net.sourceforge.pmd.util.fxdesigner.util.codearea.syntaxhighlighting.XmlSyntaxHighlighter;

public class ExportXPathWizardController
implements Initializable {
    private final ObservableValue<String> xpathExpression;
    Map<ObservableValue<?>, ChangeListener<Object>> registeredListeners = new WeakHashMap();
    @FXML
    private SyntaxHighlightingCodeArea exportResultArea;
    @FXML
    private TextField descriptionField;
    @FXML
    private TextField messageField;
    @FXML
    private Slider prioritySlider;
    @FXML
    private ChoiceBox<Language> languageChoiceBox;
    @FXML
    private TextField nameField;

    public ExportXPathWizardController(ObservableValue<String> xpathExpression) {
        this.xpathExpression = xpathExpression;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.languageChoiceBox.getItems().addAll((Collection)DesignerUtil.getSupportedLanguageVersions().stream().map(LanguageVersion::getLanguage).distinct().collect(Collectors.toList()));
        this.languageChoiceBox.setConverter((StringConverter)new StringConverter<Language>(){

            public String toString(Language object) {
                return object.getTerseName();
            }

            public Language fromString(String string) {
                return LanguageRegistry.findLanguageByTerseName((String)string);
            }
        });
        this.languageChoiceBox.getSelectionModel().select((Object)LanguageRegistry.getDefaultLanguage());
        this.exportResultArea.setSyntaxHighlighter(new XmlSyntaxHighlighter());
        this.registerListener((ObservableValue)this.nameField.textProperty(), this.updateResultListener());
        this.registerListener((ObservableValue)this.messageField.textProperty(), this.updateResultListener());
        this.registerListener((ObservableValue)this.descriptionField.textProperty(), this.updateResultListener());
        this.registerListener((ObservableValue)this.prioritySlider.valueProperty(), this.updateResultListener());
        this.registerListener((ObservableValue)this.languageChoiceBox.getSelectionModel().selectedItemProperty(), this.updateResultListener());
        this.registerListener(this.xpathExpression, this.updateResultListener());
        this.updateResultListener().changed(null, null, null);
    }

    public void shutdown() {
        this.registeredListeners.entrySet().stream().filter(e -> e.getKey() != null).forEach(e -> ((ObservableValue)e.getKey()).removeListener((ChangeListener)e.getValue()));
    }

    private <T> void registerListener(ObservableValue<T> value, ChangeListener<Object> listener) {
        ChangeListener<Object> previous = this.registeredListeners.put(value, listener);
        if (previous != null) {
            value.removeListener(previous);
        }
        value.addListener(listener);
    }

    private ChangeListener<Object> updateResultListener() {
        return (observable, oldValue, newValue) -> this.exportResultArea.replaceText(this.getUpToDateRuleElement());
    }

    private String getUpToDateRuleElement() {
        String template = "<rule name=\"%s\"\n      language=\"%s\"\n      message=\"%s\"\n      class=\"net.sourceforge.pmd.lang.rule.XPathRule\"\n      <!-- externalInfoUrl=\"%s\"--> >\n    <description>\n%s\n    </description>\n    <priority>%d</priority>\n    <properties>\n        <property name=\"xpath\">\n            <value>\n<![CDATA[\n%s\n]]>\n            </value>\n        </property>\n    </properties>\n    <!--<example><![CDATA[]]></example>-->\n</rule>";
        return String.format("<rule name=\"%s\"\n      language=\"%s\"\n      message=\"%s\"\n      class=\"net.sourceforge.pmd.lang.rule.XPathRule\"\n      <!-- externalInfoUrl=\"%s\"--> >\n    <description>\n%s\n    </description>\n    <priority>%d</priority>\n    <properties>\n        <property name=\"xpath\">\n            <value>\n<![CDATA[\n%s\n]]>\n            </value>\n        </property>\n    </properties>\n    <!--<example><![CDATA[]]></example>-->\n</rule>", this.nameField.getText(), ((Language)this.languageChoiceBox.getSelectionModel().getSelectedItem()).getTerseName(), this.messageField.getText(), "TODO", this.descriptionField.getText(), (int)this.prioritySlider.getValue(), this.xpathExpression.getValue());
    }
}

