/* The following code was generated by JFlex 1.7.0 */

/*
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 *
 * --------------
 *
 * NOTICE
 *
 * This lexer originates from JetBrains's IntelliJ Scala plugin.
 *    https://github.com/JetBrains/intellij-scala/blob/9d20b09792f7867e49f6ce7f9efee09ccd0209b2/scala/scala-impl/src/org/jetbrains/plugins/scala/lang/lexer/core/scala.flex
 *
 * It has been extensively modified.
 *
 * The original copyright notice is the following:
 *
 *    Copyright 2007-2017 JetBrains s.r.o.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        https://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */



package net.sourceforge.pmd.util.fxdesigner.util.codearea.syntaxhighlighting;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import java.util.HashSet;

import org.apache.commons.lang3.mutable.MutableInt;

import net.sourceforge.pmd.util.fxdesigner.util.codearea.LexerBasedHighlighter.JflexLexer;
import static net.sourceforge.pmd.util.fxdesigner.util.codearea.syntaxhighlighting.HighlightClasses.*;


/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>/home/travis/build/pmd/pmd-designer/src/main/jflex/Scala.jflex</tt>
 */
class ScalaLexer implements JflexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int COMMON_STATE = 2;
  public static final int WAIT_FOR_INTERPOLATED_STRING = 4;
  public static final int INSIDE_INTERPOLATED_STRING = 6;
  public static final int INSIDE_MULTI_LINE_INTERPOLATED_STRING = 8;
  public static final int INJ_COMMON_STATE = 10;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5, 5
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\65\1\76\1\71\1\67\1\67\1\66\16\65\4\0\1\76\1\51"+
    "\1\74\1\52\1\75\1\53\1\60\1\72\1\106\1\106\1\54\1\55"+
    "\1\106\1\47\1\45\1\62\1\35\1\110\1\107\5\41\1\36\1\112"+
    "\1\56\1\106\1\77\1\53\1\53\1\100\1\57\1\73\1\40\1\102"+
    "\1\43\1\46\1\44\5\115\1\34\6\115\1\32\1\103\3\115\1\37"+
    "\2\115\1\101\1\61\1\106\1\53\1\42\1\50\1\2\1\26\1\1"+
    "\1\7\1\4\1\10\1\31\1\6\1\15\1\27\1\30\1\12\1\20"+
    "\1\14\1\11\1\24\1\22\1\17\1\3\1\5\1\23\1\25\1\21"+
    "\1\13\1\16\1\33\1\104\1\63\1\105\1\60\6\65\1\70\32\65"+
    "\2\0\4\64\4\0\1\64\2\0\1\65\7\0\1\64\4\0\1\64"+
    "\5\0\27\115\1\0\7\115\30\64\1\0\10\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\2\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\2\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\2\115\1\64\1\115\1\64\1\115"+
    "\3\64\2\115\1\64\1\115\1\64\2\115\1\64\3\115\2\64\4\115"+
    "\1\64\2\115\1\64\3\115\3\64\2\115\1\64\2\115\1\64\1\115"+
    "\1\64\1\115\1\64\2\115\1\64\1\115\2\64\1\115\1\64\2\115"+
    "\1\64\3\115\1\64\1\115\1\64\2\115\3\64\1\115\7\64\1\115"+
    "\2\64\1\115\2\64\1\115\2\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\2\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\2\64\1\115"+
    "\2\64\1\115\1\64\3\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\7\64\2\115\1\64\2\115\2\64\1\115\1\64\4\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\163\64\4\0"+
    "\14\64\16\0\5\64\7\0\1\64\1\0\1\64\21\0\160\65\1\115"+
    "\1\64\1\115\2\64\1\0\1\115\1\64\2\0\4\64\1\0\1\115"+
    "\6\0\1\115\1\0\3\115\1\0\1\115\1\0\2\115\1\64\21\115"+
    "\1\0\11\115\43\64\1\115\2\64\3\115\3\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\5\64\1\115\1\64\1\0\1\115\1\64\2\115\2\64\63\115\60\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\0\5\65\2\0\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\2\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\2\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\0\46\115\2\0\1\64\7\0\47\64\7\0\1\64\1\0"+
    "\55\65\1\0\1\65\1\0\2\65\1\0\2\65\1\0\1\65\10\0"+
    "\33\64\5\0\3\64\15\0\6\65\5\0\1\64\4\0\13\65\1\0"+
    "\1\65\3\0\53\64\37\65\4\0\2\64\1\65\143\64\1\0\1\64"+
    "\10\65\1\0\6\65\2\64\2\65\1\0\4\65\2\64\12\65\3\64"+
    "\2\0\1\64\17\0\1\65\1\64\1\65\36\64\33\65\2\0\131\64"+
    "\13\65\1\64\16\0\12\65\41\64\11\65\2\64\4\0\1\64\5\0"+
    "\26\64\4\65\1\64\11\65\1\64\3\65\1\64\5\65\22\0\31\64"+
    "\3\65\4\0\13\64\65\0\25\64\1\0\10\64\26\0\60\65\66\64"+
    "\3\65\1\64\22\65\1\64\7\65\12\64\2\65\2\0\12\65\1\0"+
    "\20\64\3\65\1\0\10\64\2\0\2\64\2\0\26\64\1\0\7\64"+
    "\1\0\1\64\3\0\4\64\2\0\1\65\1\64\7\65\2\0\2\65"+
    "\2\0\3\65\1\64\10\0\1\65\4\0\2\64\1\0\3\64\2\65"+
    "\2\0\12\65\4\64\7\0\2\64\4\0\3\65\1\0\6\64\4\0"+
    "\2\64\2\0\26\64\1\0\7\64\1\0\2\64\1\0\2\64\1\0"+
    "\2\64\2\0\1\65\1\0\5\65\4\0\2\65\2\0\3\65\3\0"+
    "\1\65\7\0\4\64\1\0\1\64\7\0\14\65\3\64\1\65\13\0"+
    "\3\65\1\0\11\64\1\0\3\64\1\0\26\64\1\0\7\64\1\0"+
    "\2\64\1\0\5\64\2\0\1\65\1\64\10\65\1\0\3\65\1\0"+
    "\3\65\2\0\1\64\17\0\2\64\2\65\2\0\12\65\1\0\1\64"+
    "\7\0\1\64\6\65\1\0\3\65\1\0\10\64\2\0\2\64\2\0"+
    "\26\64\1\0\7\64\1\0\2\64\1\0\5\64\2\0\1\65\1\64"+
    "\7\65\2\0\2\65\2\0\3\65\10\0\2\65\4\0\2\64\1\0"+
    "\3\64\2\65\2\0\12\65\1\0\1\64\20\0\1\65\1\64\1\0"+
    "\6\64\3\0\3\64\1\0\4\64\3\0\2\64\1\0\1\64\1\0"+
    "\2\64\3\0\2\64\3\0\3\64\3\0\14\64\4\0\5\65\3\0"+
    "\3\65\1\0\4\65\2\0\1\64\6\0\1\65\16\0\12\65\11\0"+
    "\1\64\6\0\4\65\1\0\10\64\1\0\3\64\1\0\27\64\1\0"+
    "\20\64\3\0\1\64\7\65\1\0\3\65\1\0\4\65\7\0\2\65"+
    "\1\0\3\64\5\0\2\64\2\65\2\0\12\65\20\0\1\64\3\65"+
    "\1\0\10\64\1\0\3\64\1\0\27\64\1\0\12\64\1\0\5\64"+
    "\2\0\1\65\1\64\7\65\1\0\3\65\1\0\4\65\7\0\2\65"+
    "\7\0\1\64\1\0\2\64\2\65\2\0\12\65\1\0\2\64\15\0"+
    "\4\65\1\0\10\64\1\0\3\64\1\0\51\64\2\65\1\64\7\65"+
    "\1\0\3\65\1\0\4\65\1\64\5\0\3\64\1\65\7\0\3\64"+
    "\2\65\2\0\12\65\12\0\6\64\2\0\2\65\1\0\22\64\3\0"+
    "\30\64\1\0\11\64\1\0\1\64\2\0\7\64\3\0\1\65\4\0"+
    "\6\65\1\0\1\65\1\0\10\65\6\0\12\65\2\0\2\65\15\0"+
    "\60\64\1\65\2\64\7\65\4\0\10\64\10\65\1\0\12\65\47\0"+
    "\2\64\1\0\1\64\2\0\2\64\1\0\1\64\2\0\1\64\6\0"+
    "\4\64\1\0\7\64\1\0\3\64\1\0\1\64\1\0\1\64\2\0"+
    "\2\64\1\0\4\64\1\65\2\64\6\65\1\0\2\65\1\64\2\0"+
    "\5\64\1\0\1\64\1\0\6\65\2\0\12\65\2\0\4\64\40\0"+
    "\1\64\27\0\2\65\6\0\12\65\13\0\1\65\1\0\1\65\1\0"+
    "\1\65\4\0\2\65\10\64\1\0\44\64\4\0\24\65\1\0\2\65"+
    "\5\64\13\65\1\0\44\65\11\0\1\65\71\0\53\64\24\65\1\64"+
    "\12\65\6\0\6\64\4\65\4\64\3\65\1\64\3\65\2\64\7\65"+
    "\3\64\4\65\15\64\14\65\1\64\17\65\2\0\46\115\1\0\1\115"+
    "\5\0\1\115\2\0\53\64\1\0\u014d\64\1\0\4\64\2\0\7\64"+
    "\1\0\1\64\1\0\4\64\2\0\51\64\1\0\4\64\2\0\41\64"+
    "\1\0\4\64\2\0\7\64\1\0\1\64\1\0\4\64\2\0\17\64"+
    "\1\0\71\64\1\0\4\64\2\0\103\64\2\0\3\65\40\0\20\64"+
    "\20\0\126\115\2\0\6\64\3\0\u026c\64\2\0\21\64\1\0\32\64"+
    "\5\0\113\64\3\0\13\64\7\0\15\64\1\0\4\64\3\65\13\0"+
    "\22\64\3\65\13\0\22\64\2\65\14\0\15\64\1\0\3\64\1\0"+
    "\2\65\14\0\64\64\40\65\3\0\1\64\3\0\2\64\1\65\2\0"+
    "\12\65\41\0\4\65\1\0\12\65\6\0\130\64\10\0\5\64\2\65"+
    "\42\64\1\65\1\64\5\0\106\64\12\0\37\64\1\0\14\65\4\0"+
    "\14\65\12\0\12\65\36\64\2\0\5\64\13\0\54\64\4\0\32\64"+
    "\6\0\12\65\46\0\27\64\5\65\4\0\65\64\12\65\1\0\35\65"+
    "\2\0\13\65\6\0\12\65\15\0\1\64\10\0\16\65\102\0\5\65"+
    "\57\64\21\65\7\64\4\0\12\65\21\0\11\65\14\0\3\65\36\64"+
    "\15\65\2\64\12\65\54\64\16\65\14\0\44\64\24\65\10\0\12\65"+
    "\3\0\3\64\12\65\44\64\2\0\11\64\107\0\3\65\1\0\25\65"+
    "\4\64\1\65\4\64\3\65\2\64\3\65\6\0\300\64\72\65\1\0"+
    "\5\65\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\11\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\11\64\10\115"+
    "\6\64\2\0\6\115\2\0\10\64\10\115\10\64\10\115\6\64\2\0"+
    "\6\115\2\0\10\64\1\0\1\115\1\0\1\115\1\0\1\115\1\0"+
    "\1\115\10\64\10\115\16\64\2\0\65\64\1\0\2\64\4\115\1\64"+
    "\1\0\1\64\3\0\3\64\1\0\2\64\4\115\1\64\3\0\4\64"+
    "\2\0\2\64\4\115\4\0\10\64\5\115\5\0\3\64\1\0\2\64"+
    "\4\115\1\64\16\0\5\65\30\0\1\67\1\67\5\65\20\0\2\64"+
    "\23\0\1\64\13\0\5\65\1\0\12\65\1\0\1\64\15\0\1\64"+
    "\20\0\15\64\3\0\40\64\20\0\15\65\4\0\1\65\3\0\14\65"+
    "\21\0\1\115\4\0\1\115\2\0\1\64\3\115\2\64\3\115\1\64"+
    "\1\0\1\115\3\0\5\115\6\0\1\115\1\0\1\115\1\0\1\115"+
    "\1\0\4\115\1\0\1\64\4\115\6\64\2\0\2\64\2\115\5\0"+
    "\1\115\4\64\4\0\1\64\21\0\20\115\23\64\1\115\5\64\7\0"+
    "\1\113\101\0\1\111\u02e3\0\32\114\u01c4\0\1\53\u056b\0\57\115\1\0"+
    "\57\64\1\0\1\115\1\64\3\115\2\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\4\115\1\64\1\115\2\64\1\115\10\64\3\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\2\64\6\0\1\115"+
    "\1\64\1\115\1\64\3\65\1\115\1\64\14\0\46\64\1\0\1\64"+
    "\5\0\1\64\2\0\70\64\7\0\1\64\17\0\1\65\27\64\11\0"+
    "\7\64\1\0\7\64\1\0\7\64\1\0\7\64\1\0\7\64\1\0"+
    "\7\64\1\0\7\64\1\0\7\64\1\0\40\65\57\0\1\64\u01d5\0"+
    "\3\64\31\0\11\64\6\65\1\0\5\64\2\0\5\64\4\0\126\64"+
    "\2\0\2\65\2\0\3\64\1\0\132\64\1\0\4\64\5\0\52\64"+
    "\2\0\136\64\21\0\33\64\65\0\20\64\u0200\0\u19b6\64\112\0\u51eb\64"+
    "\25\0\u048d\64\103\0\56\64\2\0\u010d\64\3\0\20\64\12\65\2\64"+
    "\24\0\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\2\64\1\65\4\0\12\65"+
    "\1\0\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\3\64"+
    "\2\65\120\64\2\65\45\0\11\64\2\0\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\3\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64"+
    "\1\115\12\64\1\115\1\64\1\115\1\64\2\115\1\64\1\115\1\64"+
    "\1\115\1\64\1\115\1\64\1\115\2\64\2\0\1\115\1\64\1\115"+
    "\2\64\1\115\1\64\1\115\3\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115\1\64\1\115"+
    "\1\64\1\115\1\64\1\115\1\64\5\115\1\0\5\115\1\64\1\115"+
    "\1\64\77\0\13\64\1\65\3\64\1\65\4\64\1\65\27\64\5\65"+
    "\20\0\1\64\7\0\64\64\14\0\2\65\62\64\22\65\12\0\12\65"+
    "\6\0\22\65\6\64\3\0\1\64\1\0\1\64\2\0\12\65\34\64"+
    "\10\65\2\0\27\64\15\65\14\0\35\64\3\0\4\65\57\64\16\65"+
    "\16\0\1\64\12\65\6\0\5\64\1\65\12\64\12\65\5\64\1\0"+
    "\51\64\16\65\11\0\3\64\1\65\10\64\2\65\2\0\12\65\6\0"+
    "\27\64\3\0\1\64\3\65\62\64\1\65\1\64\3\65\2\64\2\65"+
    "\5\64\2\65\1\64\1\65\1\64\30\0\3\64\2\0\13\64\5\65"+
    "\2\0\3\64\2\65\12\0\6\64\2\0\6\64\2\0\6\64\11\0"+
    "\7\64\1\0\7\64\1\0\53\64\1\0\12\64\12\0\163\64\10\65"+
    "\1\0\2\65\2\0\12\65\6\0\u2ba4\64\14\0\27\64\4\0\61\64"+
    "\u2104\0\u016e\64\2\0\152\64\46\0\7\64\14\0\5\64\5\0\1\64"+
    "\1\65\12\64\1\0\15\64\1\0\5\64\1\0\1\64\1\0\2\64"+
    "\1\0\2\64\1\0\154\64\41\0\u016b\64\22\0\100\64\2\0\66\64"+
    "\50\0\15\64\3\0\20\65\20\0\20\65\3\0\2\64\30\0\3\64"+
    "\31\0\1\64\6\0\5\64\1\0\207\64\2\0\1\65\4\0\1\64"+
    "\13\0\12\65\7\0\32\115\4\0\1\64\1\0\32\64\13\0\131\64"+
    "\3\0\6\64\2\0\6\64\2\0\6\64\2\0\3\64\3\0\2\64"+
    "\3\0\2\64\22\0\3\65\4\0\14\64\1\0\32\64\1\0\23\64"+
    "\1\0\2\64\1\0\17\64\2\0\16\64\42\0\173\64\105\0\65\64"+
    "\210\0\1\65\202\0\35\64\3\0\61\64\17\0\1\65\37\0\40\64"+
    "\15\0\36\64\5\0\46\64\5\65\5\0\36\64\2\0\44\64\4\0"+
    "\10\64\1\0\5\64\52\0\50\115\166\64\2\0\12\65\6\0\44\115"+
    "\4\0\44\64\4\0\50\64\10\0\64\64\234\0\u0137\64\11\0\26\64"+
    "\12\0\10\64\230\0\6\64\2\0\1\64\1\0\54\64\1\0\2\64"+
    "\3\0\1\64\2\0\27\64\12\0\27\64\11\0\37\64\101\0\23\64"+
    "\1\0\2\64\12\0\26\64\12\0\32\64\106\0\70\64\6\0\2\64"+
    "\100\0\1\64\3\65\1\0\2\65\5\0\4\65\4\64\1\0\3\64"+
    "\1\0\33\64\4\0\3\65\4\0\1\65\40\0\35\64\3\0\35\64"+
    "\43\0\10\64\1\0\34\64\2\65\31\0\66\64\12\0\26\64\12\0"+
    "\23\64\15\0\22\64\156\0\111\64\67\0\63\115\15\0\63\64\u030d\0"+
    "\3\65\65\64\17\65\37\0\12\65\17\0\4\65\55\64\13\65\2\0"+
    "\1\65\22\0\31\64\7\0\12\65\6\0\3\65\44\64\16\65\1\0"+
    "\12\65\20\0\43\64\1\65\2\0\1\64\11\0\3\65\60\64\16\65"+
    "\4\64\5\0\3\65\3\0\12\65\1\64\1\0\1\64\43\0\22\64"+
    "\1\0\31\64\14\65\6\0\1\65\101\0\7\64\1\0\1\64\1\0"+
    "\4\64\1\0\17\64\1\0\12\64\7\0\57\64\14\65\5\0\12\65"+
    "\6\0\4\65\1\0\10\64\2\0\2\64\2\0\26\64\1\0\7\64"+
    "\1\0\2\64\1\0\5\64\2\0\1\65\1\64\7\65\2\0\2\65"+
    "\2\0\3\65\2\0\1\64\6\0\1\65\5\0\5\64\2\65\2\0"+
    "\7\65\3\0\5\65\213\0\65\64\22\65\4\64\5\0\12\65\46\0"+
    "\60\64\24\65\2\64\1\0\1\64\10\0\12\65\246\0\57\64\7\65"+
    "\2\0\11\65\27\0\4\64\2\65\42\0\60\64\21\65\3\0\1\64"+
    "\13\0\12\65\46\0\53\64\15\65\10\0\12\65\66\0\32\64\3\0"+
    "\17\65\4\0\12\65\u0166\0\40\115\40\64\12\65\25\0\1\64\u0100\0"+
    "\1\64\12\65\50\64\7\65\1\64\4\65\10\0\1\65\10\0\1\64"+
    "\13\65\50\64\2\0\4\64\20\65\46\0\71\64\u0107\0\11\64\1\0"+
    "\45\64\10\65\1\0\10\65\1\64\17\0\12\65\30\0\36\64\2\0"+
    "\26\65\1\0\16\65\111\0\7\64\1\0\2\64\1\0\46\64\6\65"+
    "\3\0\1\65\1\0\2\65\1\0\7\65\1\64\1\65\10\0\12\65"+
    "\u02a6\0\u039a\64\146\0\157\64\21\0\304\64\u0abc\0\u042f\64\u0fd1\0\u0247\64"+
    "\u21b9\0\u0239\64\7\0\37\64\1\0\12\65\146\0\36\64\2\0\5\65"+
    "\13\0\60\64\7\65\11\0\4\64\14\0\12\65\11\0\25\64\5\0"+
    "\23\64\u0370\0\105\64\13\0\1\64\56\65\20\0\4\65\15\64\100\0"+
    "\2\64\36\0\u17ed\64\23\0\u02f3\64\u250d\0\u011f\64\121\0\u018c\64\u0904\0"+
    "\153\64\5\0\15\64\3\0\11\64\7\0\12\64\3\0\2\65\1\0"+
    "\4\65\u14c1\0\5\65\3\0\26\65\2\0\7\65\36\0\4\65\224\0"+
    "\3\65\u01bb\0\32\115\32\64\32\115\7\64\1\0\22\64\32\115\32\64"+
    "\1\115\1\0\2\115\2\0\1\115\2\0\2\115\2\0\4\115\1\0"+
    "\10\115\4\64\1\0\1\64\1\0\7\64\1\0\13\64\32\115\32\64"+
    "\2\115\1\0\4\115\2\0\10\115\1\0\7\115\1\0\32\64\2\115"+
    "\1\0\4\115\1\0\5\115\1\0\1\115\3\0\7\115\1\0\32\64"+
    "\32\115\32\64\32\115\32\64\32\115\32\64\32\115\32\64\32\115\32\64"+
    "\32\115\34\64\2\0\31\115\1\0\31\64\1\0\6\64\31\115\1\0"+
    "\31\64\1\0\6\64\31\115\1\0\31\64\1\0\6\64\31\115\1\0"+
    "\31\64\1\0\6\64\31\115\1\0\31\64\1\0\6\64\1\115\1\64"+
    "\2\0\62\65\u0200\0\67\65\4\0\62\65\10\0\1\65\16\0\1\65"+
    "\26\0\5\65\1\0\17\65\u0550\0\7\65\1\0\21\65\2\0\7\65"+
    "\1\0\2\65\1\0\5\65\u07d5\0\305\64\13\0\7\65\51\0\42\115"+
    "\42\64\7\65\5\0\12\65\u04a6\0\4\64\1\0\33\64\1\0\2\64"+
    "\1\0\1\64\2\0\1\64\1\0\12\64\1\0\4\64\1\0\1\64"+
    "\1\0\1\64\6\0\1\64\4\0\1\64\1\0\1\64\1\0\1\64"+
    "\1\0\3\64\1\0\2\64\1\0\1\64\2\0\1\64\1\0\1\64"+
    "\1\0\1\64\1\0\1\64\1\0\1\64\1\0\2\64\1\0\1\64"+
    "\2\0\4\64\1\0\7\64\1\0\4\64\1\0\4\64\1\0\1\64"+
    "\1\0\12\64\1\0\21\64\5\0\3\64\1\0\5\64\1\0\21\64"+
    "\u0274\0\32\114\6\0\32\114\6\0\32\114\u0e76\0\ua6d7\64\51\0\u1035\64"+
    "\13\0\336\64\2\0\u1682\64\16\0\u1d31\64\u0c1f\0\u021e\64\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\uffff\0\u05ee\0"+
    "\1\65\36\0\140\65\200\0\360\65\uffff\0\uffff\0\ufe12\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\12\0\1\1\23\2\1\3\2\4\2\5\1\1\2\6"+
    "\1\5\3\6\1\7\1\1\1\10\1\7\1\6\1\5"+
    "\1\11\1\12\1\1\1\6\1\3\1\13\1\14\1\10"+
    "\2\15\1\16\1\10\1\14\3\10\3\17\2\10\16\0"+
    "\3\2\1\20\11\2\1\21\11\2\1\21\11\2\1\3"+
    "\1\0\1\4\1\0\1\4\1\0\2\4\2\0\2\6"+
    "\3\22\1\0\3\6\1\23\1\0\4\24\2\0\1\10"+
    "\1\0\1\14\2\25\2\6\1\3\1\13\3\0\3\26"+
    "\2\0\1\14\1\27\2\0\1\30\3\31\2\0\1\14"+
    "\1\17\1\0\1\17\14\0\5\2\1\6\1\20\2\0"+
    "\12\2\1\21\1\2\1\0\15\2\2\3\1\0\1\4"+
    "\1\0\2\4\5\32\2\0\1\6\1\0\2\6\1\0"+
    "\2\22\3\0\1\6\1\33\5\24\1\0\1\14\1\0"+
    "\1\6\1\0\2\3\1\0\1\34\2\26\2\0\1\16"+
    "\1\35\2\31\2\0\1\17\7\0\2\2\1\20\4\2"+
    "\1\36\1\2\1\37\5\2\1\40\1\41\11\2\1\0"+
    "\3\32\2\0\1\23\1\6\1\0\1\22\2\0\1\42"+
    "\1\0\1\24\6\0\1\26\1\43\1\31\2\0\3\2"+
    "\1\37\1\2\1\40\10\2\1\32\1\23\1\0\1\6"+
    "\3\0\1\42\1\24\7\0\1\2\1\40\7\2\1\0"+
    "\1\6\4\22\1\0\1\24\2\0\1\14\1\0\3\2"+
    "\1\0\1\6\1\22\1\0\1\2\1\0\1\23\1\0"+
    "\1\23";

  private static int [] zzUnpackAction() {
    int [] result = new int[394];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\116\0\234\0\352\0\u0138\0\u0186\0\u01d4\0\u0222"+
    "\0\u0270\0\u02be\0\u030c\0\u035a\0\u03a8\0\u03f6\0\u0444\0\u0492"+
    "\0\u04e0\0\u052e\0\u057c\0\u05ca\0\u0618\0\u0666\0\u06b4\0\u0702"+
    "\0\u0750\0\u079e\0\u07ec\0\u083a\0\u0888\0\u08d6\0\u0924\0\u0972"+
    "\0\u09c0\0\u0a0e\0\u0a5c\0\u0aaa\0\u0af8\0\u0a5c\0\u0b46\0\u0b94"+
    "\0\u0be2\0\u0c30\0\u0c7e\0\u0ccc\0\u0d1a\0\u030c\0\u0d68\0\u030c"+
    "\0\u030c\0\u030c\0\u0db6\0\u030c\0\u0e04\0\u0e52\0\u0ea0\0\u0eee"+
    "\0\u0f3c\0\u030c\0\u030c\0\u0f8a\0\u0fd8\0\u1026\0\u1074\0\u030c"+
    "\0\u10c2\0\u1110\0\u115e\0\u11ac\0\u115e\0\u11fa\0\u1248\0\u1296"+
    "\0\u12e4\0\u1332\0\u1380\0\u13ce\0\u141c\0\u146a\0\u14b8\0\u1506"+
    "\0\u1554\0\u15a2\0\u15f0\0\u163e\0\u168c\0\u16da\0\u1728\0\u1776"+
    "\0\u17c4\0\u1812\0\u1860\0\u18ae\0\u18fc\0\u194a\0\u1998\0\u19e6"+
    "\0\u04e0\0\u1a34\0\u1a82\0\u1ad0\0\u1b1e\0\u1b6c\0\u1bba\0\u1c08"+
    "\0\u1c56\0\u1ca4\0\u0666\0\u1cf2\0\u1d40\0\u1d8e\0\u1ddc\0\u1e2a"+
    "\0\u1e78\0\u1ec6\0\u1f14\0\u1f62\0\u1fb0\0\u1ffe\0\u030c\0\u204c"+
    "\0\u209a\0\u20e8\0\u2136\0\u2184\0\u0aaa\0\u21d2\0\u2220\0\u226e"+
    "\0\u22bc\0\u230a\0\u2358\0\u23a6\0\u23f4\0\u2442\0\u2490\0\u24de"+
    "\0\u252c\0\u257a\0\u25c8\0\u2616\0\u2664\0\u2616\0\u26b2\0\u2700"+
    "\0\u274e\0\u279c\0\u0a5c\0\u030c\0\u27ea\0\u2838\0\u2886\0\u28d4"+
    "\0\u2922\0\u2970\0\u0eee\0\u29be\0\u2a0c\0\u2a5a\0\u2aa8\0\u2a5a"+
    "\0\u2a0c\0\u030c\0\u2af6\0\u2b44\0\u030c\0\u2b92\0\u2be0\0\u2c2e"+
    "\0\u2c7c\0\u2c2e\0\u2be0\0\u2cca\0\u11ac\0\u030c\0\u2d18\0\u2d66"+
    "\0\u2db4\0\u2e02\0\u2e50\0\u2e9e\0\u2eec\0\u2f3a\0\u2f88\0\u030c"+
    "\0\u2fd6\0\u3024\0\u3072\0\u30c0\0\u310e\0\u315c\0\u31aa\0\u31f8"+
    "\0\u3246\0\u3294\0\u32e2\0\u3330\0\u337e\0\u33cc\0\u341a\0\u3468"+
    "\0\u34b6\0\u3504\0\u3552\0\u35a0\0\u35ee\0\u363c\0\u368a\0\u31f8"+
    "\0\u36d8\0\u3726\0\u3774\0\u37c2\0\u3810\0\u385e\0\u38ac\0\u38fa"+
    "\0\u3948\0\u3996\0\u39e4\0\u3a32\0\u3a80\0\u3ace\0\u3b1c\0\u3b6a"+
    "\0\u3bb8\0\u3c06\0\u3c54\0\u3ca2\0\u3cf0\0\u3d3e\0\u3d8c\0\u3dda"+
    "\0\u3e28\0\u3e76\0\u3e28\0\u0aaa\0\u3ec4\0\u3f12\0\u3f60\0\u3fae"+
    "\0\u3ffc\0\u404a\0\u4098\0\u40e6\0\u4134\0\u4182\0\u030c\0\u41d0"+
    "\0\u421e\0\u426c\0\u42ba\0\u4308\0\u4356\0\u030c\0\u43a4\0\u43f2"+
    "\0\u4440\0\u448e\0\u44dc\0\u44dc\0\u452a\0\u4578\0\u030c\0\u45c6"+
    "\0\u4614\0\u4662\0\u030c\0\u46b0\0\u030c\0\u46fe\0\u115e\0\u11ac"+
    "\0\u474c\0\u479a\0\u479a\0\u47e8\0\u4836\0\u1380\0\u2f3a\0\u4884"+
    "\0\u48d2\0\u4920\0\u496e\0\u49bc\0\u4a0a\0\u4a58\0\u04e0\0\u4aa6"+
    "\0\u04e0\0\u4af4\0\u4b42\0\u4b90\0\u4bde\0\u4c2c\0\u0666\0\u04e0"+
    "\0\u4c7a\0\u4cc8\0\u4d16\0\u4d64\0\u4db2\0\u4e00\0\u4e4e\0\u4e9c"+
    "\0\u4eea\0\u4f38\0\u4f86\0\u4fd4\0\u030c\0\u5022\0\u5070\0\u2220"+
    "\0\u50be\0\u23f4\0\u510c\0\u515a\0\u51a8\0\u0a5c\0\u426c\0\u51f6"+
    "\0\u5244\0\u5292\0\u52e0\0\u532e\0\u537c\0\u53ca\0\u2aa8\0\u4662"+
    "\0\u2c7c\0\u5418\0\u5466\0\u54b4\0\u5502\0\u5550\0\u0666\0\u559e"+
    "\0\u55ec\0\u563a\0\u5688\0\u56d6\0\u5724\0\u5772\0\u57c0\0\u580e"+
    "\0\u585c\0\u3e76\0\u3ec4\0\u58aa\0\u58f8\0\u5946\0\u5994\0\u59e2"+
    "\0\u030c\0\u5a30\0\u5a7e\0\u5acc\0\u5b1a\0\u5b68\0\u5bb6\0\u2eec"+
    "\0\u5c04\0\u5c52\0\u04e0\0\u5ca0\0\u5cee\0\u5d3c\0\u5d8a\0\u5dd8"+
    "\0\u5e26\0\u5e74\0\u5ec2\0\u5f10\0\u5f5e\0\u5fac\0\u5ffa\0\u6048"+
    "\0\u6096\0\u60e4\0\u6132\0\u6180\0\u61ce\0\u621c\0\u626a\0\u62b8"+
    "\0\u6306\0\u6354\0\u63a2\0\u63f0\0\u643e\0\u648c\0\u64da\0\u50be"+
    "\0\u6528\0\u58aa";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[394];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\13\1\14\1\15\1\16\1\17\1\20\1\21\1\22"+
    "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\26\1\21\1\35\1\36\1\21\3\26"+
    "\1\37\1\26\1\37\1\40\1\41\2\37\1\41\1\21"+
    "\2\37\1\42\1\37\1\43\1\44\1\43\1\45\1\46"+
    "\2\43\1\47\1\50\1\43\1\51\1\52\1\43\1\26"+
    "\1\13\4\53\1\54\1\37\1\55\1\26\1\56\1\57"+
    "\1\43\1\60\2\37\1\61\1\62\1\60\2\41\1\63"+
    "\1\41\1\64\1\65\1\37\1\13\1\14\1\15\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\30\1\31\1\32\1\33\1\34\1\26\1\21"+
    "\1\35\1\36\1\21\3\26\1\37\1\26\1\37\1\40"+
    "\1\41\2\37\1\41\1\21\2\37\1\42\1\37\1\43"+
    "\1\44\1\43\1\45\1\46\2\43\1\47\1\50\1\43"+
    "\1\51\1\52\1\43\1\26\1\13\4\53\1\54\1\37"+
    "\1\55\1\26\1\56\1\46\1\43\1\60\2\37\1\61"+
    "\1\62\1\60\2\41\1\63\1\41\1\64\1\65\1\37"+
    "\74\0\1\66\21\0\61\67\1\70\4\67\1\71\2\67"+
    "\1\72\2\67\1\73\1\74\20\67\74\75\1\76\1\77"+
    "\20\75\1\100\7\101\1\102\2\101\1\102\5\101\2\102"+
    "\1\101\2\102\1\101\6\102\2\100\2\102\1\100\1\101"+
    "\2\102\1\100\1\102\1\103\1\104\12\103\1\105\1\102"+
    "\6\100\1\102\1\100\1\102\1\100\2\103\1\100\2\102"+
    "\11\100\1\102\1\0\34\106\2\0\2\106\1\0\3\106"+
    "\1\0\1\106\15\0\1\106\6\0\1\106\1\0\1\106"+
    "\4\0\2\106\11\0\1\106\61\107\1\110\4\107\1\111"+
    "\2\107\1\111\2\107\1\112\1\113\20\107\35\0\1\114"+
    "\1\115\2\0\1\115\45\0\2\115\1\0\1\115\4\0"+
    "\7\116\1\117\2\116\1\117\5\116\2\117\1\116\2\117"+
    "\1\116\6\117\2\120\2\117\1\120\1\116\2\117\1\0"+
    "\1\117\1\121\1\122\12\121\1\123\1\117\1\120\2\0"+
    "\1\120\2\0\1\117\1\0\1\117\1\0\2\121\1\0"+
    "\2\117\3\0\2\120\1\0\1\120\2\0\1\117\117\0"+
    "\1\21\1\124\5\21\1\26\1\21\1\125\1\26\5\21"+
    "\2\26\1\21\2\26\1\21\13\26\1\126\2\26\1\0"+
    "\1\26\1\46\1\0\13\46\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\1\0\2\46\1\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\7\21\1\26"+
    "\2\21\1\26\5\21\2\26\1\21\2\26\1\130\13\26"+
    "\1\126\2\26\1\0\1\26\1\46\1\0\13\46\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\1\0\2\46"+
    "\1\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\3\21\1\131\3\21\1\26\2\21\1\26\5\21"+
    "\2\26\1\132\2\26\1\21\13\26\1\126\2\26\1\0"+
    "\1\26\1\46\1\0\13\46\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\1\0\2\46\1\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\7\21\1\26"+
    "\1\21\1\133\1\134\1\135\4\21\2\26\1\21\2\26"+
    "\1\21\13\26\1\126\2\26\1\0\1\26\1\46\1\0"+
    "\13\46\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\46\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\5\21\1\136\1\21\1\26\2\21"+
    "\1\26\3\21\1\137\1\21\2\26\1\21\2\26\1\21"+
    "\13\26\1\126\2\26\1\0\1\26\1\46\1\0\13\46"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\1\0"+
    "\2\46\1\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\7\21\1\26\2\21\1\26\5\21\2\26"+
    "\1\21\2\26\1\21\13\26\1\126\2\26\1\0\1\26"+
    "\1\46\1\0\13\46\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\1\0\2\46\1\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\1\0\3\21\1\140\3\21"+
    "\1\26\1\141\1\21\1\26\5\21\2\26\1\21\2\26"+
    "\1\21\13\26\1\126\2\26\1\0\1\26\1\46\1\0"+
    "\13\46\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\46\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\1\26\1\142\6\26\1\143\3\26"+
    "\1\144\24\26\1\145\2\26\1\0\1\26\15\0\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\4\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\7\21"+
    "\1\26\2\21\1\26\5\21\2\26\1\21\1\26\1\146"+
    "\1\147\13\26\1\126\2\26\1\0\1\26\1\46\1\0"+
    "\13\46\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\46\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\1\21\1\150\5\21\1\26\2\21"+
    "\1\26\5\21\2\26\1\21\2\26\1\21\13\26\1\126"+
    "\2\26\1\0\1\26\1\46\1\0\13\46\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\1\0\2\46\1\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\41\26\1\145\2\26\1\0\1\26\15\0\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\4\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\3\21\1\151"+
    "\3\21\1\26\2\21\1\26\5\21\2\26\1\152\2\26"+
    "\1\21\13\26\1\126\2\26\1\0\1\26\1\46\1\0"+
    "\13\46\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\46\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\7\21\1\153\2\21\1\26\4\21"+
    "\1\154\2\26\1\21\2\26\1\21\13\26\1\126\2\26"+
    "\1\0\1\26\1\46\1\0\13\46\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\1\0\2\46\1\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\7\21"+
    "\1\26\2\21\1\26\1\21\1\155\3\21\2\26\1\21"+
    "\2\26\1\21\13\26\1\126\2\26\1\0\1\26\1\46"+
    "\1\0\13\46\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\1\0\2\46\1\0\2\26\3\0\2\26\1\0"+
    "\1\26\2\0\1\26\1\0\3\21\1\156\3\21\1\26"+
    "\2\21\1\26\5\21\2\26\1\21\2\26\1\21\13\26"+
    "\1\126\2\26\1\0\1\26\1\46\1\0\13\46\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\1\0\2\46"+
    "\1\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\1\21\1\157\5\21\1\26\2\21\1\26\5\21"+
    "\2\26\1\21\2\26\1\21\13\26\1\126\2\26\1\0"+
    "\1\26\1\46\1\0\13\46\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\1\0\2\46\1\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\5\26\1\160"+
    "\6\26\1\161\24\26\1\145\2\26\1\0\1\26\15\0"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\4\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\1\26\1\162\14\26\1\163\22\26\1\145\2\26\1\0"+
    "\1\26\15\0\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\4\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\1\26\1\164\37\26\1\145\2\26\1\0"+
    "\1\26\15\0\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\4\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\41\37\1\165\2\37\1\0\1\37\15\0"+
    "\2\37\2\0\1\37\2\0\1\37\1\127\1\37\4\0"+
    "\2\37\3\0\2\37\1\0\1\37\2\0\1\37\4\0"+
    "\1\166\2\0\2\167\1\0\1\167\1\170\20\0\1\167"+
    "\1\171\1\172\1\170\1\0\2\171\2\167\1\173\1\166"+
    "\40\0\2\171\1\0\1\172\7\0\1\166\2\0\2\167"+
    "\1\0\1\167\21\0\1\167\2\41\2\0\2\41\2\167"+
    "\1\173\1\166\40\0\2\41\1\0\1\41\40\0\2\174"+
    "\2\0\1\174\45\0\2\174\1\0\1\174\4\0\7\46"+
    "\1\0\2\46\1\0\5\46\2\0\1\46\2\0\1\46"+
    "\13\0\1\46\4\0\1\46\1\0\13\46\13\0\2\46"+
    "\15\0\50\175\1\64\10\175\1\176\4\175\4\0\24\175"+
    "\1\0\7\46\1\0\2\46\1\0\5\46\2\0\1\46"+
    "\2\0\1\46\13\0\1\46\4\0\1\46\1\0\1\177"+
    "\12\46\13\0\2\46\16\0\7\46\1\0\2\46\1\0"+
    "\5\46\2\0\1\46\2\0\1\46\13\0\1\46\4\0"+
    "\1\46\1\0\5\46\1\200\5\46\13\0\2\46\16\0"+
    "\7\201\1\202\2\201\1\202\5\201\2\202\1\201\2\202"+
    "\1\201\6\202\2\0\2\202\1\0\1\201\2\202\1\0"+
    "\1\202\1\203\1\204\12\203\1\205\1\202\6\0\1\202"+
    "\1\0\1\202\1\0\2\203\1\0\2\202\11\0\1\202"+
    "\1\0\7\46\1\0\2\46\1\0\5\46\2\0\1\206"+
    "\2\0\1\46\13\0\1\46\4\0\1\46\1\0\13\46"+
    "\13\0\2\46\16\0\7\46\1\0\2\46\1\0\5\46"+
    "\2\0\1\46\2\0\1\46\13\0\1\46\4\0\1\46"+
    "\1\0\3\46\1\207\5\46\1\210\1\46\13\0\2\46"+
    "\103\0\4\53\4\0\1\53\17\0\1\211\7\212\1\213"+
    "\2\212\1\213\5\212\2\213\1\212\2\213\1\212\6\213"+
    "\2\211\2\213\1\211\1\212\2\213\1\211\1\213\1\214"+
    "\1\211\10\214\1\215\1\214\1\216\1\213\1\211\1\0"+
    "\2\211\1\0\1\217\1\213\1\211\1\213\1\211\2\214"+
    "\1\211\2\213\11\211\1\213\61\220\1\221\4\220\1\0"+
    "\2\220\1\0\2\220\1\222\21\220\1\0\7\223\1\224"+
    "\2\223\1\224\5\223\2\224\1\223\2\224\1\223\6\224"+
    "\2\0\2\224\1\0\1\223\2\224\1\0\1\224\1\46"+
    "\1\0\1\225\12\46\1\224\6\0\1\224\1\0\1\224"+
    "\1\0\1\46\1\226\1\0\2\224\11\0\1\224\42\0"+
    "\1\64\54\0\41\65\1\227\2\65\1\0\1\65\15\0"+
    "\2\65\2\0\1\65\2\0\1\65\1\0\1\65\4\0"+
    "\2\65\3\0\2\65\1\0\1\65\2\0\1\65\61\230"+
    "\1\231\4\230\1\0\2\230\1\0\2\230\1\232\1\0"+
    "\20\230\61\67\1\233\4\67\1\0\2\67\1\0\2\67"+
    "\2\0\106\67\1\0\2\67\1\0\24\67\71\0\1\72"+
    "\25\0\7\234\1\235\2\234\1\235\5\234\2\235\1\234"+
    "\2\235\1\234\6\235\2\0\2\235\1\0\1\234\2\235"+
    "\1\0\1\235\1\236\1\237\12\236\1\240\1\235\6\0"+
    "\1\235\1\0\1\241\1\0\2\236\1\0\2\235\1\242"+
    "\10\0\1\235\74\75\1\243\1\0\114\75\1\244\1\245"+
    "\20\75\1\0\7\246\1\247\2\246\1\247\5\246\2\247"+
    "\1\246\2\247\1\246\6\247\2\0\2\247\1\0\1\246"+
    "\2\247\1\0\1\247\1\250\1\251\12\250\1\252\1\247"+
    "\6\0\1\247\1\0\1\253\1\0\2\250\1\0\2\247"+
    "\1\242\10\0\1\247\1\0\7\101\1\102\2\101\1\102"+
    "\5\101\2\102\1\101\2\102\1\101\13\102\1\101\2\102"+
    "\1\0\1\102\1\103\1\0\13\103\2\102\2\0\1\102"+
    "\2\0\1\102\1\0\1\102\1\0\2\103\1\0\2\102"+
    "\3\0\2\102\1\0\1\102\2\0\1\102\1\0\41\102"+
    "\1\254\2\102\1\0\1\102\15\0\2\102\2\0\1\102"+
    "\2\0\1\102\1\0\1\102\4\0\2\102\3\0\2\102"+
    "\1\0\1\102\2\0\1\102\1\0\7\103\1\0\2\103"+
    "\1\0\5\103\2\0\1\103\2\0\1\103\13\0\1\103"+
    "\4\0\1\103\1\0\13\103\13\0\2\103\15\0\50\255"+
    "\1\256\10\255\1\257\4\255\4\0\24\255\1\0\41\106"+
    "\1\260\2\106\1\0\1\106\15\0\2\106\2\0\1\106"+
    "\2\0\1\106\1\0\1\106\4\0\2\106\3\0\2\106"+
    "\1\0\1\106\2\0\1\106\66\107\1\111\2\107\1\111"+
    "\2\107\1\261\1\113\20\107\61\111\1\262\12\111\1\263"+
    "\1\0\114\111\1\263\1\0\20\111\61\0\1\264\12\0"+
    "\1\265\102\0\1\264\47\0\1\266\21\0\1\267\1\0"+
    "\1\266\1\0\2\267\44\0\2\267\42\0\2\115\2\0"+
    "\2\115\44\0\2\115\1\0\1\115\4\0\7\116\1\117"+
    "\2\116\1\117\5\116\2\117\1\116\2\117\1\116\6\117"+
    "\2\120\2\117\1\120\1\116\2\117\1\270\1\117\1\121"+
    "\1\0\13\121\1\117\1\120\2\0\1\120\2\0\1\117"+
    "\1\0\1\117\1\0\2\121\1\0\2\117\3\0\2\120"+
    "\1\0\1\120\2\0\1\117\1\0\34\117\2\120\2\117"+
    "\1\120\3\117\1\270\1\117\15\0\1\117\1\120\2\0"+
    "\1\120\2\0\1\117\1\0\1\117\4\0\2\117\3\0"+
    "\2\120\1\0\1\120\2\0\1\117\1\0\34\117\2\120"+
    "\2\117\1\120\3\117\1\0\1\117\15\0\1\117\1\120"+
    "\2\0\1\120\2\0\1\117\1\0\1\117\4\0\2\117"+
    "\3\0\2\120\1\0\1\120\2\0\1\117\1\0\7\121"+
    "\1\0\2\121\1\0\5\121\2\0\1\121\2\0\1\121"+
    "\13\0\1\116\2\0\1\270\1\0\1\121\1\0\13\121"+
    "\13\0\2\121\15\0\50\122\1\271\15\122\1\0\2\272"+
    "\1\0\24\122\1\0\7\121\1\0\2\121\1\0\5\121"+
    "\2\0\1\121\2\0\1\121\13\0\1\121\4\0\1\121"+
    "\1\0\13\121\13\0\2\121\16\0\2\21\1\273\1\21"+
    "\1\274\2\21\1\26\2\21\1\26\5\21\2\26\1\21"+
    "\2\26\1\21\13\26\1\126\2\26\1\0\1\26\1\46"+
    "\1\0\13\46\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\1\0\2\46\1\0\2\26\3\0\2\26\1\0"+
    "\1\26\2\0\1\26\1\0\1\21\1\275\5\21\1\26"+
    "\2\21\1\26\5\21\2\26\1\21\2\26\1\21\13\26"+
    "\1\126\2\26\1\0\1\26\1\46\1\0\13\46\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\1\0\2\46"+
    "\1\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\7\276\1\26\2\276\1\26\5\276\2\26\1\276"+
    "\2\26\1\276\13\26\1\276\2\26\1\0\1\26\1\277"+
    "\1\0\12\277\1\300\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\1\0\2\277\1\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\61\301\1\302\4\301\1\0"+
    "\2\301\1\0\2\301\1\303\1\0\20\301\1\0\2\21"+
    "\1\304\4\21\1\26\2\21\1\26\5\21\2\26\1\21"+
    "\2\26\1\21\13\26\1\126\2\26\1\0\1\26\1\46"+
    "\1\0\13\46\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\1\0\2\46\1\0\2\26\3\0\2\26\1\0"+
    "\1\26\2\0\1\26\1\0\1\21\1\305\5\21\1\26"+
    "\2\21\1\26\5\21\2\26\1\21\2\26\1\21\13\26"+
    "\1\126\2\26\1\0\1\26\1\46\1\0\13\46\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\1\0\2\46"+
    "\1\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\7\21\1\26\2\21\1\26\5\21\2\26\1\21"+
    "\1\306\1\26\1\21\13\26\1\126\2\26\1\0\1\26"+
    "\1\46\1\0\13\46\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\1\0\2\46\1\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\1\0\2\21\1\273\4\21"+
    "\1\26\2\21\1\26\5\21\2\26\1\21\2\26\1\21"+
    "\13\26\1\126\2\26\1\0\1\26\1\46\1\0\13\46"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\1\0"+
    "\2\46\1\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\4\26\1\307\34\26\1\145\2\26\1\0"+
    "\1\26\15\0\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\4\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\7\21\1\26\2\21\1\26\5\21\2\26"+
    "\1\310\2\26\1\21\13\26\1\126\2\26\1\0\1\26"+
    "\1\46\1\0\13\46\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\1\0\2\46\1\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\1\0\7\21\1\26\2\21"+
    "\1\26\1\21\1\311\1\21\1\312\1\21\2\26\1\21"+
    "\2\26\1\21\13\26\1\126\2\26\1\0\1\26\1\46"+
    "\1\0\13\46\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\1\0\2\46\1\0\2\26\3\0\2\26\1\0"+
    "\1\26\2\0\1\26\1\0\1\21\1\313\5\21\1\26"+
    "\2\21\1\26\2\21\1\141\2\21\2\26\1\314\2\26"+
    "\1\21\13\26\1\126\2\26\1\0\1\26\1\46\1\0"+
    "\13\46\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\46\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\7\21\1\153\2\21\1\26\5\21"+
    "\2\26\1\21\2\26\1\21\13\26\1\126\2\26\1\0"+
    "\1\26\1\46\1\0\13\46\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\1\0\2\46\1\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\11\26\1\315"+
    "\27\26\1\145\2\26\1\0\1\26\15\0\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\4\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\16\26\1\316"+
    "\22\26\1\145\2\26\1\0\1\26\15\0\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\4\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\13\26\1\317"+
    "\25\26\1\145\2\26\1\0\1\26\15\0\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\4\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\7\276\1\26"+
    "\2\276\1\26\5\276\2\26\1\276\2\26\1\276\13\26"+
    "\1\276\2\26\1\0\1\26\1\277\1\0\12\277\1\320"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\1\0"+
    "\2\277\1\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\3\26\1\321\35\26\1\145\2\26\1\0"+
    "\1\26\15\0\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\4\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\7\21\1\26\2\21\1\26\5\21\2\26"+
    "\1\21\2\26\1\21\1\322\12\26\1\126\2\26\1\0"+
    "\1\26\1\46\1\0\13\46\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\1\0\2\46\1\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\7\21\1\26"+
    "\2\21\1\26\5\21\2\26\1\21\2\26\1\21\4\26"+
    "\1\323\6\26\1\126\2\26\1\0\1\26\1\46\1\0"+
    "\13\46\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\46\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\7\21\1\26\2\21\1\26\5\21"+
    "\1\153\1\26\1\21\2\26\1\21\13\26\1\126\2\26"+
    "\1\0\1\26\1\46\1\0\13\46\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\1\0\2\46\1\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\7\21"+
    "\1\26\1\21\1\324\1\26\5\21\2\26\1\21\2\26"+
    "\1\21\13\26\1\126\2\26\1\0\1\26\1\46\1\0"+
    "\13\46\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\46\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\7\21\1\26\2\21\1\26\5\21"+
    "\2\26\1\21\1\325\1\26\1\21\13\26\1\126\2\26"+
    "\1\0\1\26\1\46\1\0\13\46\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\1\0\2\46\1\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\3\21"+
    "\1\326\3\21\1\26\2\21\1\26\5\21\2\26\1\21"+
    "\2\26\1\21\13\26\1\126\2\26\1\0\1\26\1\46"+
    "\1\0\13\46\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\1\0\2\46\1\0\2\26\3\0\2\26\1\0"+
    "\1\26\2\0\1\26\1\0\4\21\1\327\2\21\1\26"+
    "\2\21\1\26\5\21\1\26\1\330\1\21\2\26\1\21"+
    "\13\26\1\126\2\26\1\0\1\26\1\46\1\0\13\46"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\1\0"+
    "\2\46\1\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\4\21\1\274\2\21\1\26\2\21\1\26"+
    "\5\21\2\26\1\21\2\26\1\21\13\26\1\126\2\26"+
    "\1\0\1\26\1\46\1\0\13\46\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\1\0\2\46\1\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\14\26"+
    "\1\331\24\26\1\145\2\26\1\0\1\26\15\0\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\4\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\4\26"+
    "\1\332\34\26\1\145\2\26\1\0\1\26\15\0\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\4\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\1\333"+
    "\40\26\1\145\2\26\1\0\1\26\15\0\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\4\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\10\26\1\334"+
    "\3\26\1\335\24\26\1\145\2\26\1\0\1\26\15\0"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\4\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\11\26\1\153\4\26\1\153\22\26\1\145\2\26\1\0"+
    "\1\26\15\0\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\4\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\7\336\1\37\2\336\1\37\5\336\2\37"+
    "\1\336\2\37\1\336\13\37\1\336\2\37\1\0\1\37"+
    "\1\337\1\0\12\337\1\340\2\37\2\0\1\37\2\0"+
    "\1\37\1\127\1\37\1\0\2\337\1\0\2\37\3\0"+
    "\2\37\1\0\1\37\2\0\1\37\35\0\2\341\2\0"+
    "\1\341\5\0\1\342\5\0\1\342\31\0\2\341\1\0"+
    "\1\341\4\0\2\343\1\0\1\343\2\0\2\343\15\0"+
    "\1\343\6\0\2\343\1\0\5\343\1\0\1\343\24\0"+
    "\1\343\6\0\1\343\4\0\2\343\1\0\1\343\7\0"+
    "\1\166\2\0\2\167\1\0\1\167\21\0\1\167\1\171"+
    "\1\172\2\0\2\171\2\167\1\173\1\166\40\0\2\171"+
    "\1\0\1\172\7\0\1\166\2\0\2\167\24\0\2\172"+
    "\2\0\2\172\2\167\1\344\1\166\40\0\2\172\1\0"+
    "\1\172\4\0\3\345\1\346\3\345\1\347\2\345\1\347"+
    "\5\345\2\347\1\345\2\347\1\345\6\347\2\174\2\347"+
    "\1\174\1\345\2\347\1\0\1\350\1\351\1\352\12\351"+
    "\1\353\1\347\6\0\1\347\1\0\1\347\1\0\2\351"+
    "\1\0\2\347\3\0\2\174\1\0\1\174\2\0\1\347"+
    "\4\0\1\166\2\0\2\167\24\0\2\174\2\0\2\174"+
    "\2\167\1\0\1\166\40\0\2\174\1\0\1\174\3\0"+
    "\50\175\1\354\10\175\1\176\4\175\1\0\2\175\1\0"+
    "\24\175\1\355\7\177\1\355\2\177\1\355\5\177\2\355"+
    "\1\177\2\355\1\177\13\355\1\177\4\355\1\177\1\355"+
    "\1\356\12\177\13\355\2\177\15\355\1\0\7\46\1\0"+
    "\2\46\1\0\5\46\2\0\1\46\2\0\1\46\13\0"+
    "\1\46\4\0\1\46\1\0\1\46\1\357\11\46\13\0"+
    "\2\46\16\0\7\201\1\202\2\201\1\202\5\201\2\202"+
    "\1\201\2\202\1\201\13\202\1\201\2\202\1\360\1\202"+
    "\1\203\1\0\13\203\2\202\2\0\1\202\2\0\1\202"+
    "\1\0\1\202\1\0\2\203\1\0\2\202\3\0\2\202"+
    "\1\0\1\202\2\0\1\202\1\0\41\202\1\361\2\202"+
    "\1\360\1\202\15\0\2\202\2\0\1\202\2\0\1\202"+
    "\1\0\1\202\4\0\2\202\3\0\2\202\1\0\1\202"+
    "\2\0\1\202\1\0\7\203\1\0\2\203\1\0\5\203"+
    "\2\0\1\203\2\0\1\203\13\0\1\203\2\0\1\360"+
    "\1\0\1\203\1\0\13\203\13\0\2\203\15\0\50\204"+
    "\1\362\10\204\1\363\4\204\4\0\24\204\1\0\7\203"+
    "\1\0\2\203\1\0\5\203\2\0\1\203\2\0\1\203"+
    "\13\0\1\203\4\0\1\203\1\0\13\203\13\0\2\203"+
    "\16\0\7\46\1\0\2\46\1\0\5\46\2\0\1\46"+
    "\2\0\1\46\13\0\1\46\4\0\1\46\1\0\13\46"+
    "\13\0\2\46\6\0\1\364\6\0\1\365\7\207\1\365"+
    "\2\207\1\365\5\207\2\365\1\207\2\365\1\207\13\365"+
    "\1\207\4\365\1\207\1\365\3\207\1\366\7\207\13\365"+
    "\2\207\15\365\66\210\1\0\2\210\1\0\24\210\61\0"+
    "\1\367\10\0\1\367\24\0\7\370\1\371\2\370\1\371"+
    "\5\370\2\371\1\370\2\371\1\370\13\371\1\370\2\371"+
    "\1\0\1\371\1\372\1\0\13\372\2\371\2\0\1\371"+
    "\1\0\1\367\1\371\1\0\1\371\1\0\2\372\1\0"+
    "\2\371\3\0\2\371\1\0\1\371\2\0\1\371\1\0"+
    "\41\371\1\373\2\371\1\0\1\371\12\0\1\367\2\0"+
    "\2\371\2\0\1\371\1\0\1\367\1\371\1\0\1\371"+
    "\4\0\2\371\3\0\2\371\1\0\1\371\2\0\1\371"+
    "\1\0\7\372\1\0\2\372\1\0\5\372\2\0\1\372"+
    "\2\0\1\372\13\0\1\372\4\0\1\372\1\0\13\372"+
    "\6\0\1\367\4\0\2\372\15\0\1\211\7\214\1\211"+
    "\2\214\1\211\5\214\2\211\1\374\2\211\1\214\6\211"+
    "\1\375\3\211\1\375\1\214\4\211\1\214\1\211\13\214"+
    "\2\211\1\0\2\211\1\0\5\211\2\214\6\211\2\375"+
    "\5\211\72\0\1\367\23\0\61\220\1\221\4\220\1\0"+
    "\2\220\1\0\2\220\1\376\107\220\1\0\2\220\1\0"+
    "\24\220\74\0\1\377\22\0\7\46\1\0\2\46\1\0"+
    "\5\46\2\0\1\46\2\0\1\46\13\0\1\46\4\0"+
    "\1\u0100\1\0\13\46\13\0\2\46\1\u0101\15\0\7\223"+
    "\1\224\2\223\1\224\5\223\2\224\1\223\2\224\1\223"+
    "\6\224\2\0\2\224\1\0\1\223\2\224\1\0\1\224"+
    "\1\46\1\0\13\46\1\224\6\0\1\224\1\0\1\224"+
    "\1\0\2\46\1\0\2\224\11\0\1\224\1\0\7\u0102"+
    "\1\65\2\u0102\1\65\5\u0102\2\65\1\u0102\2\65\1\u0102"+
    "\13\65\1\u0102\2\65\1\0\1\65\1\u0103\1\0\12\u0103"+
    "\1\u0104\2\65\2\0\1\65\2\0\1\65\1\0\1\65"+
    "\1\0\2\u0103\1\0\2\65\3\0\2\65\1\0\1\65"+
    "\2\0\1\65\61\230\1\231\4\230\1\0\2\230\1\0"+
    "\2\230\2\0\106\230\1\0\2\230\1\0\24\230\74\0"+
    "\1\u0105\22\0\7\234\1\235\2\234\1\235\5\234\2\235"+
    "\1\234\2\235\1\234\13\235\1\234\2\235\1\0\1\235"+
    "\1\236\1\0\13\236\2\235\2\0\1\235\2\0\1\235"+
    "\1\0\1\235\1\0\2\236\1\0\2\235\3\0\2\235"+
    "\1\0\1\235\2\0\1\235\1\0\41\235\1\u0106\2\235"+
    "\1\0\1\235\15\0\2\235\2\0\1\235\2\0\1\235"+
    "\1\0\1\235\4\0\2\235\3\0\2\235\1\0\1\235"+
    "\2\0\1\235\1\0\7\236\1\0\2\236\1\0\5\236"+
    "\2\0\1\236\2\0\1\236\13\0\1\236\4\0\1\236"+
    "\1\0\13\236\13\0\2\236\15\0\50\237\1\u0107\10\237"+
    "\1\u0108\4\237\4\0\24\237\74\75\1\u0109\1\0\114\75"+
    "\1\u010a\1\u010b\20\75\1\0\7\246\1\247\2\246\1\247"+
    "\5\246\2\247\1\246\2\247\1\246\13\247\1\246\2\247"+
    "\1\0\1\247\1\250\1\0\13\250\2\247\2\0\1\247"+
    "\2\0\1\247\1\0\1\247\1\0\2\250\1\0\2\247"+
    "\3\0\2\247\1\0\1\247\2\0\1\247\1\0\41\247"+
    "\1\u010c\2\247\1\0\1\247\15\0\2\247\2\0\1\247"+
    "\2\0\1\247\1\0\1\247\4\0\2\247\3\0\2\247"+
    "\1\0\1\247\2\0\1\247\1\0\7\250\1\0\2\250"+
    "\1\0\5\250\2\0\1\250\2\0\1\250\13\0\1\250"+
    "\4\0\1\250\1\0\13\250\13\0\2\250\15\0\50\251"+
    "\1\u010d\10\251\1\u010e\4\251\4\0\24\251\1\0\7\101"+
    "\1\102\2\101\1\102\5\101\2\102\1\101\2\102\1\101"+
    "\13\102\1\101\2\102\1\0\1\102\1\103\1\0\12\103"+
    "\1\u010f\2\102\2\0\1\102\2\0\1\102\1\0\1\102"+
    "\1\0\2\103\1\0\2\102\3\0\2\102\1\0\1\102"+
    "\2\0\1\102\50\255\1\u0110\10\255\1\257\4\255\1\0"+
    "\2\255\1\0\24\255\1\0\7\u0111\1\106\2\u0111\1\106"+
    "\5\u0111\2\106\1\u0111\2\106\1\u0111\13\106\1\u0111\2\106"+
    "\1\0\1\106\1\u0112\1\0\12\u0112\1\u0113\2\106\2\0"+
    "\1\106\2\0\1\106\1\0\1\106\1\0\2\u0112\1\0"+
    "\2\106\3\0\2\106\1\0\1\106\2\0\1\106\61\111"+
    "\1\262\12\111\1\u0114\1\0\20\111\61\107\1\110\4\107"+
    "\1\111\2\107\1\111\2\107\1\261\1\113\20\107\74\111"+
    "\1\u0114\1\0\20\111\61\u0115\1\113\4\u0115\1\0\2\u0115"+
    "\1\0\2\u0115\1\u0116\1\113\20\u0115\74\0\1\270\22\0"+
    "\2\u0117\1\0\1\u0117\2\0\2\u0117\15\0\1\u0117\6\0"+
    "\2\u0117\1\0\5\u0117\1\0\1\u0117\24\0\1\u0117\6\0"+
    "\1\u0117\4\0\2\u0117\1\0\1\u0117\40\0\1\267\3\0"+
    "\2\267\44\0\2\267\52\0\1\270\13\0\1\122\115\0"+
    "\1\122\35\0\3\21\1\141\3\21\1\26\2\21\1\26"+
    "\5\21\2\26\1\21\2\26\1\21\13\26\1\126\2\26"+
    "\1\0\1\26\1\46\1\0\13\46\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\1\0\2\46\1\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\1\u0118"+
    "\6\21\1\26\2\21\1\26\5\21\2\26\1\21\2\26"+
    "\1\21\13\26\1\126\2\26\1\0\1\26\1\46\1\0"+
    "\13\46\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\46\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\2\21\1\u0119\4\21\1\26\2\21"+
    "\1\26\5\21\2\26\1\21\2\26\1\21\13\26\1\126"+
    "\2\26\1\0\1\26\1\46\1\0\13\46\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\1\0\2\46\1\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\7\276\1\26\2\276\1\26\5\276\2\26\1\276\2\26"+
    "\1\276\13\26\1\276\2\26\1\0\1\26\1\277\1\0"+
    "\13\277\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\277\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\7\277\1\0\2\277\1\0\5\277"+
    "\2\0\1\277\2\0\1\277\13\0\1\277\4\0\1\277"+
    "\1\0\13\277\10\0\1\127\2\0\2\277\16\0\7\277"+
    "\1\0\2\277\1\0\5\277\2\0\1\277\2\0\1\277"+
    "\13\0\1\277\4\0\1\277\1\0\13\277\13\0\2\277"+
    "\15\0\61\301\1\302\4\301\1\0\2\301\1\0\2\301"+
    "\2\0\106\301\1\0\2\301\1\0\24\301\74\0\1\u011a"+
    "\22\0\4\21\1\u011b\2\21\1\26\2\21\1\26\5\21"+
    "\2\26\1\21\2\26\1\21\13\26\1\126\2\26\1\0"+
    "\1\26\1\46\1\0\13\46\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\1\0\2\46\1\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\7\21\1\26"+
    "\1\21\1\u011c\1\26\5\21\2\26\1\21\2\26\1\21"+
    "\13\26\1\126\2\26\1\0\1\26\1\46\1\0\13\46"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\1\0"+
    "\2\46\1\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\3\26\1\u011d\35\26\1\145\2\26\1\0"+
    "\1\26\15\0\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\4\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\3\26\1\u011e\35\26\1\145\2\26\1\0"+
    "\1\26\15\0\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\4\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\7\21\1\26\2\21\1\26\4\21\1\141"+
    "\2\26\1\21\2\26\1\21\13\26\1\126\2\26\1\0"+
    "\1\26\1\46\1\0\13\46\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\1\0\2\46\1\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\2\21\1\u011f"+
    "\4\21\1\26\2\21\1\26\5\21\2\26\1\21\2\26"+
    "\1\21\13\26\1\126\2\26\1\0\1\26\1\46\1\0"+
    "\13\46\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\46\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\7\21\1\26\1\151\1\21\1\26"+
    "\5\21\2\26\1\21\2\26\1\21\13\26\1\126\2\26"+
    "\1\0\1\26\1\46\1\0\13\46\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\1\0\2\46\1\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\7\21"+
    "\1\26\2\21\1\26\1\21\1\u0120\3\21\2\26\1\21"+
    "\2\26\1\21\13\26\1\126\2\26\1\0\1\26\1\46"+
    "\1\0\13\46\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\1\0\2\46\1\0\2\26\3\0\2\26\1\0"+
    "\1\26\2\0\1\26\1\0\3\21\1\u0121\3\21\1\26"+
    "\2\21\1\26\5\21\2\26\1\21\2\26\1\21\13\26"+
    "\1\126\2\26\1\0\1\26\1\46\1\0\13\46\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\1\0\2\46"+
    "\1\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\2\26\1\u0122\36\26\1\145\2\26\1\0\1\26"+
    "\15\0\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\4\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\31\26\1\u0123\7\26\1\145\2\26\1\0\1\26"+
    "\15\0\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\4\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\1\26\1\u0124\37\26\1\145\2\26\1\0\1\26"+
    "\15\0\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\4\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\16\26\1\u0125\22\26\1\145\2\26\1\0\1\26"+
    "\15\0\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\4\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\3\26\1\u0126\35\26\1\145\2\26\1\0\1\26"+
    "\15\0\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\4\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\15\26\1\u0127\23\26\1\145\2\26\1\0\1\26"+
    "\15\0\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\4\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\7\21\1\26\1\21\1\u0128\1\26\5\21\2\26"+
    "\1\21\2\26\1\21\13\26\1\126\2\26\1\0\1\26"+
    "\1\46\1\0\13\46\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\1\0\2\46\1\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\1\0\10\26\1\u0129\1\u012a"+
    "\27\26\1\145\2\26\1\0\1\26\15\0\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\4\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\7\21\1\26"+
    "\1\21\1\u012b\1\26\5\21\2\26\1\21\2\26\1\21"+
    "\13\26\1\126\2\26\1\0\1\26\1\46\1\0\13\46"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\1\0"+
    "\2\46\1\0\2\26\3\0\2\26\1\0\1\26\2\0"+
    "\1\26\1\0\7\21\1\26\2\21\1\26\5\21\2\26"+
    "\1\u012c\2\26\1\21\13\26\1\126\2\26\1\0\1\26"+
    "\1\46\1\0\13\46\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\1\0\2\46\1\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\1\0\22\26\1\u012d\16\26"+
    "\1\145\2\26\1\0\1\26\15\0\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\4\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\1\0\11\26\1\u012e\27\26"+
    "\1\145\2\26\1\0\1\26\15\0\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\4\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\1\0\5\26\1\153\33\26"+
    "\1\145\2\26\1\0\1\26\15\0\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\4\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\1\0\27\26\1\u012f\11\26"+
    "\1\145\2\26\1\0\1\26\15\0\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\4\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\1\0\4\26\1\u0130\34\26"+
    "\1\145\2\26\1\0\1\26\15\0\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\4\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\1\0\24\26\1\u0131\14\26"+
    "\1\145\2\26\1\0\1\26\15\0\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\4\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\1\0\7\336\1\37\2\336"+
    "\1\37\5\336\2\37\1\336\2\37\1\336\13\37\1\336"+
    "\2\37\1\0\1\37\1\337\1\0\13\337\2\37\2\0"+
    "\1\37\2\0\1\37\1\127\1\37\1\0\2\337\1\0"+
    "\2\37\3\0\2\37\1\0\1\37\2\0\1\37\1\0"+
    "\7\337\1\0\2\337\1\0\5\337\2\0\1\337\2\0"+
    "\1\337\13\0\1\337\4\0\1\337\1\0\13\337\10\0"+
    "\1\127\2\0\2\337\16\0\7\337\1\0\2\337\1\0"+
    "\5\337\2\0\1\337\2\0\1\337\13\0\1\337\4\0"+
    "\1\337\1\0\13\337\13\0\2\337\24\0\2\167\24\0"+
    "\2\341\2\0\2\341\2\167\42\0\2\341\1\0\1\341"+
    "\40\0\2\341\2\0\1\341\45\0\2\341\1\0\1\341"+
    "\4\0\2\343\1\0\1\343\2\0\2\343\1\0\1\167"+
    "\13\0\1\343\5\0\1\167\2\343\1\0\5\343\1\u0132"+
    "\1\343\24\0\1\343\6\0\1\343\4\0\2\343\1\0"+
    "\1\343\7\0\1\166\2\0\2\167\24\0\2\174\2\0"+
    "\1\174\1\0\2\167\1\0\1\166\40\0\2\174\1\0"+
    "\1\174\4\0\7\345\1\347\2\345\1\347\5\345\2\347"+
    "\1\345\2\347\1\345\13\347\1\345\2\347\1\0\1\347"+
    "\1\351\1\0\13\351\2\347\2\0\1\347\2\0\1\347"+
    "\1\0\1\347\1\0\2\351\1\0\2\347\3\0\2\347"+
    "\1\0\1\347\2\0\1\347\1\0\7\345\1\347\2\345"+
    "\1\347\5\345\2\347\1\345\2\347\1\345\13\347\1\345"+
    "\2\347\1\0\1\347\1\u0133\1\0\4\351\1\u0133\6\351"+
    "\2\347\2\0\1\347\2\0\1\347\1\0\1\347\1\0"+
    "\2\351\1\0\2\347\3\0\2\347\1\0\1\347\2\0"+
    "\1\347\1\0\41\347\1\u0134\2\347\1\0\1\347\15\0"+
    "\2\347\2\0\1\347\2\0\1\347\1\0\1\347\4\0"+
    "\2\347\3\0\2\347\1\0\1\347\2\0\1\347\1\0"+
    "\41\347\1\u0134\2\347\1\0\1\347\1\342\5\0\1\342"+
    "\6\0\2\347\2\0\1\347\2\0\1\347\1\0\1\347"+
    "\4\0\2\347\3\0\2\347\1\0\1\347\2\0\1\347"+
    "\1\0\7\351\1\0\2\351\1\0\5\351\2\0\1\351"+
    "\2\0\1\351\13\0\1\351\4\0\1\351\1\0\13\351"+
    "\13\0\2\351\15\0\50\352\1\u0135\10\352\1\u0136\4\352"+
    "\4\0\24\352\51\355\1\u0137\45\355\7\177\1\355\2\177"+
    "\1\355\5\177\2\355\1\177\2\355\1\177\13\355\1\177"+
    "\4\355\1\177\1\355\1\356\1\u0138\11\177\13\355\2\177"+
    "\15\355\1\0\7\46\1\0\2\46\1\0\5\46\2\0"+
    "\1\46\2\0\1\46\13\0\1\46\4\0\1\46\1\0"+
    "\1\u0139\12\46\13\0\2\46\16\0\7\201\1\202\2\201"+
    "\1\202\5\201\2\202\1\201\2\202\1\201\6\202\2\0"+
    "\2\202\1\0\1\201\2\202\1\0\1\202\1\203\1\204"+
    "\12\203\1\u013a\1\202\6\0\1\202\1\0\1\202\1\0"+
    "\2\203\1\0\2\202\11\0\1\202\1\0\7\201\1\202"+
    "\2\201\1\202\5\201\2\202\1\201\2\202\1\201\13\202"+
    "\1\201\2\202\1\360\1\202\1\203\1\0\12\203\1\u013a"+
    "\2\202\2\0\1\202\2\0\1\202\1\0\1\202\1\0"+
    "\2\203\1\0\2\202\3\0\2\202\1\0\1\202\2\0"+
    "\1\202\45\0\1\360\50\0\50\204\1\u013b\10\204\1\363"+
    "\4\204\1\0\2\204\1\0\24\204\110\0\1\u013c\5\0"+
    "\54\365\1\u013d\42\365\7\207\1\365\2\207\1\365\5\207"+
    "\2\365\1\207\2\365\1\207\13\365\1\207\4\365\1\207"+
    "\1\365\3\207\1\366\5\207\1\u013e\1\207\13\365\2\207"+
    "\15\365\1\0\7\370\1\371\2\370\1\371\5\370\2\371"+
    "\1\370\2\371\1\370\13\371\1\370\2\371\1\0\1\371"+
    "\1\372\1\0\13\372\2\371\2\0\1\371\2\0\1\371"+
    "\1\0\1\371\1\0\2\372\1\0\2\371\3\0\2\371"+
    "\1\0\1\371\2\0\1\371\1\0\41\371\1\373\2\371"+
    "\1\0\1\371\15\0\2\371\2\0\1\371\2\0\1\371"+
    "\1\0\1\371\4\0\2\371\3\0\2\371\1\0\1\371"+
    "\2\0\1\371\1\0\7\372\1\0\2\372\1\0\5\372"+
    "\2\0\1\372\2\0\1\372\13\0\1\372\4\0\1\372"+
    "\1\0\13\372\13\0\2\372\16\0\7\370\1\371\2\370"+
    "\1\371\5\370\2\371\1\370\2\371\1\370\13\371\1\370"+
    "\2\371\1\0\1\371\1\372\1\0\12\372\1\u013f\2\371"+
    "\2\0\1\371\2\0\1\371\1\0\1\371\1\0\2\372"+
    "\1\0\2\371\3\0\2\371\1\0\1\371\2\0\1\371"+
    "\1\0\2\u0140\1\372\1\u0140\2\372\1\u0140\1\u0141\2\372"+
    "\1\0\5\372\2\0\1\372\2\0\1\u0140\6\0\1\u0142"+
    "\1\u0141\1\0\2\u0141\1\372\2\u0141\1\0\1\u0141\1\372"+
    "\1\0\13\372\6\0\1\367\1\u0141\3\0\2\372\1\0"+
    "\1\u0141\4\0\2\u0141\1\0\1\u0141\40\0\1\u0143\3\0"+
    "\1\u0143\17\0\1\367\10\0\1\367\14\0\2\u0143\5\0"+
    "\74\377\1\u0144\21\377\1\0\7\46\1\0\2\46\1\0"+
    "\5\46\2\0\1\46\2\0\1\46\13\0\1\46\4\0"+
    "\1\223\1\0\13\46\13\0\2\46\117\0\1\u0145\14\0"+
    "\7\u0102\1\65\2\u0102\1\65\5\u0102\2\65\1\u0102\2\65"+
    "\1\u0102\13\65\1\u0102\2\65\1\0\1\65\1\u0103\1\0"+
    "\13\u0103\2\65\2\0\1\65\2\0\1\65\1\0\1\65"+
    "\1\0\2\u0103\1\0\2\65\3\0\2\65\1\0\1\65"+
    "\2\0\1\65\1\0\7\u0103\1\0\2\u0103\1\0\5\u0103"+
    "\2\0\1\u0103\2\0\1\u0103\13\0\1\u0103\4\0\1\u0103"+
    "\1\0\13\u0103\13\0\2\u0103\15\0\74\u0105\1\u0146\1\0"+
    "\20\u0105\1\0\7\234\1\235\2\234\1\235\5\234\2\235"+
    "\1\234\2\235\1\234\13\235\1\234\2\235\1\0\1\235"+
    "\1\236\1\0\12\236\1\240\2\235\2\0\1\235\2\0"+
    "\1\235\1\0\1\235\1\0\2\236\1\0\2\235\3\0"+
    "\2\235\1\0\1\235\2\0\1\235\50\237\1\u0147\10\237"+
    "\1\u0108\4\237\1\0\2\237\1\0\24\237\74\75\2\0"+
    "\20\75\74\0\1\u0148\22\0\7\246\1\247\2\246\1\247"+
    "\5\246\2\247\1\246\2\247\1\246\13\247\1\246\2\247"+
    "\1\0\1\247\1\250\1\0\12\250\1\252\2\247\2\0"+
    "\1\247\2\0\1\247\1\0\1\247\1\0\2\250\1\0"+
    "\2\247\3\0\2\247\1\0\1\247\2\0\1\247\50\251"+
    "\1\u0149\10\251\1\u010e\4\251\1\0\2\251\1\0\24\251"+
    "\1\0\7\u0111\1\106\2\u0111\1\106\5\u0111\2\106\1\u0111"+
    "\2\106\1\u0111\13\106\1\u0111\2\106\1\0\1\106\1\u0112"+
    "\1\0\13\u0112\2\106\2\0\1\106\2\0\1\106\1\0"+
    "\1\106\1\0\2\u0112\1\0\2\106\3\0\2\106\1\0"+
    "\1\106\2\0\1\106\1\0\7\u0112\1\0\2\u0112\1\0"+
    "\5\u0112\2\0\1\u0112\2\0\1\u0112\13\0\1\u0112\4\0"+
    "\1\u0112\1\0\13\u0112\13\0\2\u0112\15\0\74\111\1\u014a"+
    "\1\0\20\111\66\u0115\1\0\2\u0115\1\0\2\u0115\1\u0116"+
    "\1\113\20\u0115\1\0\5\21\1\141\1\21\1\26\2\21"+
    "\1\26\5\21\2\26\1\21\2\26\1\21\13\26\1\126"+
    "\2\26\1\0\1\26\1\46\1\0\13\46\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\1\0\2\46\1\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\2\21\1\141\4\21\1\26\2\21\1\26\5\21\2\26"+
    "\1\21\2\26\1\21\13\26\1\126\2\26\1\0\1\26"+
    "\1\46\1\0\13\46\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\1\0\2\46\1\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\74\u011a\1\u014b\1\0\20\u011a"+
    "\1\0\7\21\1\26\2\21\1\26\3\21\1\u014c\1\21"+
    "\2\26\1\21\2\26\1\21\13\26\1\126\2\26\1\0"+
    "\1\26\1\46\1\0\13\46\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\1\0\2\46\1\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\3\21\1\u014d"+
    "\3\21\1\26\2\21\1\26\5\21\2\26\1\21\2\26"+
    "\1\21\13\26\1\126\2\26\1\0\1\26\1\46\1\0"+
    "\13\46\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\46\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\16\26\1\153\22\26\1\145\2\26"+
    "\1\0\1\26\15\0\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\4\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\13\26\1\u014e\25\26\1\145\2\26"+
    "\1\0\1\26\15\0\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\4\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\4\21\1\141\2\21\1\26\2\21"+
    "\1\26\5\21\2\26\1\21\2\26\1\21\13\26\1\126"+
    "\2\26\1\0\1\26\1\46\1\0\13\46\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\1\0\2\46\1\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\3\26\1\u014f\35\26\1\145\2\26\1\0\1\26\15\0"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\4\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\10\26\1\u0150\30\26\1\145\2\26\1\0\1\26\15\0"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\4\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\11\26\1\u0151\27\26\1\145\2\26\1\0\1\26\15\0"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\4\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\16\26\1\u0152\22\26\1\145\2\26\1\0\1\26\15\0"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\4\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\1\u0153\40\26\1\145\2\26\1\0\1\26\15\0\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\4\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\16\26"+
    "\1\u0153\22\26\1\145\2\26\1\0\1\26\15\0\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\4\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\14\26"+
    "\1\u0154\24\26\1\145\2\26\1\0\1\26\15\0\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\4\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\6\21"+
    "\1\141\1\26\2\21\1\26\5\21\2\26\1\21\2\26"+
    "\1\21\13\26\1\126\2\26\1\0\1\26\1\46\1\0"+
    "\13\46\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\46\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\7\21\1\26\2\21\1\26\3\21"+
    "\1\u0155\1\21\2\26\1\21\2\26\1\21\13\26\1\126"+
    "\2\26\1\0\1\26\1\46\1\0\13\46\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\1\0\2\46\1\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\14\26\1\u0156\24\26\1\145\2\26\1\0\1\26\15\0"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\4\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\3\26\1\153\35\26\1\145\2\26\1\0\1\26\15\0"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\4\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\1\26\1\u0157\37\26\1\145\2\26\1\0\1\26\15\0"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\4\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\3\26\1\u0158\35\26\1\145\2\26\1\0\1\26\15\0"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\4\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\1\26\1\u0159\37\26\1\145\2\26\1\0\1\26\15\0"+
    "\2\26\2\0\1\26\2\0\1\26\1\127\1\26\4\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\7\345\1\347\2\345\1\347\5\345\2\347\1\345\2\347"+
    "\1\345\6\347\2\0\2\347\1\0\1\345\2\347\1\0"+
    "\1\347\1\351\1\352\12\351\1\353\1\347\6\0\1\347"+
    "\1\0\1\347\1\0\2\351\1\0\2\347\11\0\1\347"+
    "\1\0\7\351\1\0\2\351\1\0\5\351\2\0\1\351"+
    "\2\0\1\351\6\0\2\341\2\0\1\341\1\351\4\0"+
    "\1\351\1\0\13\351\13\0\2\351\6\0\2\341\1\0"+
    "\1\341\4\0\7\345\1\347\2\345\1\347\5\345\2\347"+
    "\1\345\2\347\1\345\13\347\1\345\2\347\1\0\1\347"+
    "\1\351\1\0\12\351\1\353\2\347\2\0\1\347\2\0"+
    "\1\347\1\0\1\347\1\0\2\351\1\0\2\347\3\0"+
    "\2\347\1\0\1\347\2\0\1\347\50\352\1\u015a\10\352"+
    "\1\u0136\4\352\1\0\2\352\1\0\24\352\51\355\1\u0137"+
    "\1\u015b\43\355\1\u015c\7\u0139\1\u015c\2\u0139\1\u015c\5\u0139"+
    "\2\u015c\1\u0139\2\u015c\1\u0139\13\u015c\1\u0139\4\u015c\1\u0139"+
    "\1\u015c\5\u0139\1\u015d\5\u0139\13\u015c\2\u0139\15\u015c\45\204"+
    "\1\u015e\2\204\1\362\10\204\1\363\4\204\4\0\24\204"+
    "\43\0\1\u015f\46\0\1\u0160\3\0\54\365\1\u013d\5\365"+
    "\1\u0161\33\365\1\0\2\u0162\1\372\1\u0162\2\372\1\u0162"+
    "\1\u0163\2\372\1\0\5\372\2\0\1\372\2\0\1\u0162"+
    "\6\0\2\u0163\1\0\2\u0163\1\372\2\u0163\1\0\1\u0163"+
    "\1\372\1\0\13\372\7\0\1\u0163\3\0\2\372\1\0"+
    "\1\u0163\4\0\2\u0163\1\0\1\u0163\4\0\2\u0163\1\0"+
    "\1\u0163\2\0\2\u0163\15\0\1\u0163\6\0\2\u0163\1\0"+
    "\2\u0163\1\0\2\u0163\1\0\1\u0163\24\0\1\u0163\6\0"+
    "\1\u0163\4\0\2\u0163\1\0\1\u0163\4\0\2\u0163\1\0"+
    "\1\u0163\2\0\2\u0163\15\0\1\u0163\6\0\1\u0164\1\u0163"+
    "\1\0\2\u0163\1\0\2\u0163\1\0\1\u0163\24\0\1\u0163"+
    "\6\0\1\u0163\4\0\2\u0163\1\0\1\u0163\40\0\1\211"+
    "\3\0\1\211\17\0\1\367\10\0\1\367\14\0\2\211"+
    "\5\0\74\377\1\u0165\21\377\43\0\1\u0166\52\0\74\u0105"+
    "\1\u0167\1\0\20\u0105\74\0\1\u0168\21\0\74\u011a\1\u0169"+
    "\1\0\20\u011a\1\0\1\21\1\u016a\5\21\1\26\2\21"+
    "\1\26\5\21\2\26\1\21\2\26\1\21\13\26\1\126"+
    "\2\26\1\0\1\26\1\46\1\0\13\46\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\1\0\2\46\1\0"+
    "\2\26\3\0\2\26\1\0\1\26\2\0\1\26\1\0"+
    "\6\21\1\u016b\1\26\2\21\1\26\5\21\2\26\1\21"+
    "\2\26\1\21\13\26\1\126\2\26\1\0\1\26\1\46"+
    "\1\0\13\46\2\26\2\0\1\26\2\0\1\26\1\127"+
    "\1\26\1\0\2\46\1\0\2\26\3\0\2\26\1\0"+
    "\1\26\2\0\1\26\1\0\6\26\1\u016c\32\26\1\145"+
    "\2\26\1\0\1\26\15\0\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\4\0\2\26\3\0\2\26\1\0"+
    "\1\26\2\0\1\26\1\0\17\26\1\u016d\21\26\1\145"+
    "\2\26\1\0\1\26\15\0\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\4\0\2\26\3\0\2\26\1\0"+
    "\1\26\2\0\1\26\1\0\11\26\1\u016e\27\26\1\145"+
    "\2\26\1\0\1\26\15\0\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\4\0\2\26\3\0\2\26\1\0"+
    "\1\26\2\0\1\26\1\0\14\26\1\u016f\24\26\1\145"+
    "\2\26\1\0\1\26\15\0\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\4\0\2\26\3\0\2\26\1\0"+
    "\1\26\2\0\1\26\1\0\4\26\1\153\34\26\1\145"+
    "\2\26\1\0\1\26\15\0\2\26\2\0\1\26\2\0"+
    "\1\26\1\127\1\26\4\0\2\26\3\0\2\26\1\0"+
    "\1\26\2\0\1\26\1\0\1\u0170\40\26\1\145\2\26"+
    "\1\0\1\26\15\0\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\4\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\7\21\1\26\2\21\1\26\1\141"+
    "\4\21\2\26\1\21\2\26\1\21\13\26\1\126\2\26"+
    "\1\0\1\26\1\46\1\0\13\46\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\1\0\2\46\1\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\16\26"+
    "\1\u0171\22\26\1\145\2\26\1\0\1\26\15\0\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\4\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\30\26"+
    "\1\u012e\10\26\1\145\2\26\1\0\1\26\15\0\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\4\0\2\26"+
    "\3\0\2\26\1\0\1\26\2\0\1\26\1\0\1\u0172"+
    "\40\26\1\145\2\26\1\0\1\26\15\0\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\4\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\1\0\4\26\1\u016d"+
    "\34\26\1\145\2\26\1\0\1\26\15\0\2\26\2\0"+
    "\1\26\2\0\1\26\1\127\1\26\4\0\2\26\3\0"+
    "\2\26\1\0\1\26\2\0\1\26\56\u015c\1\u0173\40\u015c"+
    "\7\u0139\1\u015c\2\u0139\1\u015c\5\u0139\2\u015c\1\u0139\2\u015c"+
    "\1\u0139\13\u015c\1\u0139\4\u015c\1\u0139\1\u015c\5\u0139\1\u0174"+
    "\5\u0139\13\u015c\2\u0139\15\u015c\1\204\7\u0175\1\u0176\2\u0175"+
    "\1\u0176\5\u0175\2\u0176\1\u0175\2\u0176\1\u0175\6\u0176\2\204"+
    "\2\u0176\1\204\1\u0175\2\u0176\1\204\1\u0176\1\u0177\1\u013b"+
    "\10\u0177\1\u0178\1\u0177\1\u0179\1\u0176\1\204\4\0\1\204"+
    "\1\u0176\1\204\1\u0176\1\204\2\u0177\1\204\2\u0176\11\204"+
    "\1\u0176\107\0\1\64\43\0\1\64\61\0\2\u017a\1\372"+
    "\1\u017a\2\372\1\u017a\1\u017b\2\372\1\0\5\372\2\0"+
    "\1\372\2\0\1\u017a\6\0\2\u017b\1\0\2\u017b\1\372"+
    "\2\u017b\1\0\1\u017b\1\372\1\0\13\372\7\0\1\u017b"+
    "\3\0\2\372\1\0\1\u017b\4\0\2\u017b\1\0\1\u017b"+
    "\4\0\2\u017b\1\0\1\u017b\2\0\2\u017b\15\0\1\u017b"+
    "\6\0\2\u017b\1\0\2\u017b\1\0\2\u017b\1\0\1\u017b"+
    "\24\0\1\u017b\6\0\1\u017b\4\0\2\u017b\1\0\1\u017b"+
    "\4\0\2\u017b\1\0\1\u017b\2\0\2\u017b\15\0\1\u017b"+
    "\6\0\1\u017c\1\u017b\1\0\2\u017b\1\0\2\u017b\1\0"+
    "\1\u017b\24\0\1\u017b\6\0\1\u017b\4\0\2\u017b\1\0"+
    "\1\u017b\3\0\74\377\1\u017d\21\377\73\0\1\u017e\22\0"+
    "\74\u0105\2\0\20\u0105\74\u011a\2\0\20\u011a\1\0\1\u017f"+
    "\6\21\1\26\2\21\1\26\5\21\2\26\1\21\2\26"+
    "\1\21\13\26\1\126\2\26\1\0\1\26\1\46\1\0"+
    "\13\46\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\1\0\2\46\1\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\2\26\1\153\36\26\1\145\2\26"+
    "\1\0\1\26\15\0\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\4\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\3\26\1\u0127\35\26\1\145\2\26"+
    "\1\0\1\26\15\0\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\4\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\15\26\1\153\23\26\1\145\2\26"+
    "\1\0\1\26\15\0\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\4\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\6\26\1\u016d\32\26\1\145\2\26"+
    "\1\0\1\26\15\0\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\4\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\14\26\1\u0180\24\26\1\145\2\26"+
    "\1\0\1\26\15\0\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\4\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\3\26\1\u016c\35\26\1\145\2\26"+
    "\1\0\1\26\15\0\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\4\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\1\0\4\26\1\u0181\34\26\1\145\2\26"+
    "\1\0\1\26\15\0\2\26\2\0\1\26\2\0\1\26"+
    "\1\127\1\26\4\0\2\26\3\0\2\26\1\0\1\26"+
    "\2\0\1\26\56\u015c\1\u0182\40\u015c\7\u0139\1\u015c\2\u0139"+
    "\1\u015c\5\u0139\2\u015c\1\u0139\2\u015c\1\u0139\13\u015c\1\u0139"+
    "\4\u015c\1\u0139\1\u015c\1\u0183\4\u0139\1\u0174\5\u0139\13\u015c"+
    "\2\u0139\15\u015c\1\204\7\u0175\1\u0176\2\u0175\1\u0176\5\u0175"+
    "\2\u0176\1\u0175\2\u0176\1\u0175\13\u0176\1\u0175\2\u0176\1\u015e"+
    "\1\u0176\1\u0177\1\362\10\u0177\1\u0178\2\u0177\2\u0176\2\0"+
    "\1\202\1\0\1\204\1\u0176\1\204\1\u0176\1\204\2\u0177"+
    "\1\204\2\u0176\3\204\2\u0176\1\204\1\u0176\2\204\1\u0176"+
    "\1\204\41\u0176\1\u0184\2\u0176\1\u015e\1\u0176\1\204\1\362"+
    "\10\204\1\363\2\204\2\u0176\2\0\1\202\1\0\1\204"+
    "\1\u0176\1\204\1\u0176\4\204\2\u0176\3\204\2\u0176\1\204"+
    "\1\u0176\2\204\1\u0176\1\204\7\u0177\1\204\2\u0177\1\204"+
    "\5\u0177\2\204\1\u0177\2\204\1\u0177\13\204\1\u0177\2\204"+
    "\1\u015e\1\204\1\u0177\1\362\10\u0177\1\u0178\2\u0177\2\204"+
    "\4\0\5\204\2\u0177\16\204\7\u0177\1\204\2\u0177\1\204"+
    "\5\u0177\2\204\1\u0177\2\204\1\u0177\13\204\1\u0177\2\204"+
    "\1\u015e\1\204\1\u0177\1\u013b\10\u0177\1\u0178\2\u0177\2\204"+
    "\1\0\2\204\1\0\5\204\2\u0177\16\204\7\u0177\1\204"+
    "\2\u0177\1\204\5\u0177\2\204\1\u0177\2\204\1\u0177\13\204"+
    "\1\u0177\4\204\1\u0177\1\362\10\u0177\1\u0178\2\u0177\2\204"+
    "\4\0\5\204\2\u0177\15\204\1\0\2\214\1\372\1\214"+
    "\2\372\1\214\1\211\2\372\1\0\5\372\2\0\1\372"+
    "\2\0\1\214\6\0\2\211\1\0\2\211\1\372\2\211"+
    "\1\0\1\211\1\372\1\0\13\372\7\0\1\211\3\0"+
    "\2\372\1\0\1\211\4\0\2\211\1\0\1\211\4\0"+
    "\2\211\1\0\1\211\2\0\2\211\15\0\1\211\6\0"+
    "\2\211\1\0\2\211\1\0\2\211\1\0\1\211\24\0"+
    "\1\211\6\0\1\211\4\0\2\211\1\0\1\211\4\0"+
    "\2\211\1\0\1\211\2\0\2\211\15\0\1\211\6\0"+
    "\2\211\1\0\2\211\1\0\2\211\1\0\1\211\24\0"+
    "\1\217\6\0\1\211\4\0\2\211\1\0\1\211\77\0"+
    "\1\u017d\124\0\1\u0185\13\0\4\21\1\u016b\2\21\1\26"+
    "\2\21\1\26\5\21\2\26\1\21\2\26\1\21\13\26"+
    "\1\126\2\26\1\0\1\26\1\46\1\0\13\46\2\26"+
    "\2\0\1\26\2\0\1\26\1\127\1\26\1\0\2\46"+
    "\1\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\4\26\1\u0127\34\26\1\145\2\26\1\0\1\26"+
    "\15\0\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\4\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\1\0\3\26\1\u0186\35\26\1\145\2\26\1\0\1\26"+
    "\15\0\2\26\2\0\1\26\2\0\1\26\1\127\1\26"+
    "\4\0\2\26\3\0\2\26\1\0\1\26\2\0\1\26"+
    "\51\u015c\1\u0187\4\u015c\1\u0182\40\u015c\7\u0139\1\u015c\2\u0139"+
    "\1\u015c\5\u0139\2\u015c\1\u0139\2\u015c\1\u0139\13\u015c\1\u0139"+
    "\4\u015c\1\u0139\1\u015c\1\u0139\1\u0188\3\u0139\1\u015d\5\u0139"+
    "\13\u015c\2\u0139\15\u015c\1\204\7\u0175\1\u0176\2\u0175\1\u0176"+
    "\5\u0175\2\u0176\1\u0175\2\u0176\1\u0175\13\u0176\1\u0175\2\u0176"+
    "\1\u015e\1\u0176\1\u0177\1\362\10\u0177\1\u0178\1\u0177\1\u0179"+
    "\2\u0176\2\0\1\202\1\0\1\204\1\u0176\1\204\1\u0176"+
    "\1\204\2\u0177\1\204\2\u0176\3\204\2\u0176\1\204\1\u0176"+
    "\2\204\1\u0176\73\0\1\u0189\23\0\6\26\1\u0127\32\26"+
    "\1\145\2\26\1\0\1\26\15\0\2\26\2\0\1\26"+
    "\2\0\1\26\1\127\1\26\4\0\2\26\3\0\2\26"+
    "\1\0\1\26\2\0\1\26\52\u015c\1\u018a\3\u015c\1\u0173"+
    "\37\u015c\101\0\1\224\14\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[25974];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\12\0\1\11\42\1\1\11\1\1\3\11\1\1\1\11"+
    "\5\1\2\11\4\1\1\11\6\1\3\0\1\1\1\0"+
    "\2\1\6\0\42\1\1\0\1\11\1\0\1\1\1\0"+
    "\2\1\2\0\5\1\1\0\4\1\1\0\4\1\2\0"+
    "\1\1\1\0\2\1\1\11\4\1\3\0\3\1\2\0"+
    "\1\1\1\11\2\0\1\11\3\1\2\0\2\1\1\0"+
    "\1\11\1\0\2\1\5\0\1\1\1\11\2\0\7\1"+
    "\2\0\14\1\1\0\17\1\1\0\1\1\1\0\7\1"+
    "\2\0\1\1\1\0\2\1\1\0\2\1\3\0\1\1"+
    "\1\11\5\1\1\0\1\11\1\0\1\1\1\0\2\1"+
    "\1\0\2\1\1\11\2\0\1\1\1\11\1\1\1\11"+
    "\2\0\3\1\3\0\34\1\1\0\2\1\1\11\2\0"+
    "\2\1\1\0\1\1\2\0\1\1\1\0\1\1\6\0"+
    "\4\1\1\0\20\1\1\0\1\1\3\0\1\11\1\1"+
    "\5\0\1\1\1\0\11\1\1\0\5\1\1\0\1\1"+
    "\2\0\1\1\1\0\3\1\1\0\2\1\1\0\1\1"+
    "\1\0\1\1\1\0\1\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[394];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true iff the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true iff the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;
  
  /** 
   * The number of occupied positions in zzBuffer beyond zzEndRead.
   * When a lead/high surrogate has been read from the input stream
   * into the final zzBuffer position, this will have a value of 1;
   * otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** For the backwards DFA of general lookahead statements */
  private boolean [] zzFin = new boolean [ZZ_BUFFERSIZE+1];

  /* user code: */

    private final Set<String> baseClasses;

    private class InterpolationLevel extends MutableInt {

          private final int state;
          InterpolationLevel() {
              this.state = yystate();
          }

          int getState() {
              return state;
          }
    }

    //to get id after $ in interpolated String
    private boolean haveIdInString = false;
    private boolean haveIdInMultilineString = false;
    // Currently opened interpolated Strings. Each int represents the number of the opened left structural braces in the String
    private Deque<InterpolationLevel> nestedString = new ArrayDeque<>();

    private boolean isInterpolatedStringState() {
        return shouldProcessBracesForInterpolated() ||
               haveIdInString ||
               haveIdInMultilineString ||
               yystate() == INSIDE_INTERPOLATED_STRING ||
               yystate() == INSIDE_MULTI_LINE_INTERPOLATED_STRING;
    }

    private boolean shouldProcessBracesForInterpolated() {
      return !nestedString.isEmpty();
    }

    private Set<String> processOutsideString() {
      if (shouldProcessBracesForInterpolated()) nestedString.pop();
      yybegin(COMMON_STATE);
      return process(STRING);
    }

    private Set<String> process(HighlightClasses type){
      if ((type == IDENTIFIER || type == THIS)) {
        if (haveIdInString) {
          haveIdInString = false;
          yybegin(INSIDE_INTERPOLATED_STRING);
        } else if (haveIdInMultilineString) {
          haveIdInMultilineString = false;
          yybegin(INSIDE_MULTI_LINE_INTERPOLATED_STRING);
        }
      }

      if (yystate() == YYINITIAL && type != WHITESPACE && yycharat(0) != '{' && yycharat(0) != '(') {
        yybegin(COMMON_STATE);
      }

      return toCss(type);
    }

    private Set<String> toCss(HighlightClasses type) {
        Set<String> css = new HashSet<>(type.css); // TODO persistent collections
        css.addAll(baseClasses);
        if ((yystate() == COMMON_STATE || yystate() == YYINITIAL || yycharat(0) == '}' && yylength() == 1)
            && !nestedString.isEmpty()) {
            css.addAll(HighlightClasses.INJECTED_LANG.css);
        }
        return css;
    }

    private Set<String> processInsideString(boolean isInsideMultiline) {
        boolean isEscape = yycharat(1) == '$';
        if (!isEscape) {
            if (isInsideMultiline) {
                haveIdInMultilineString = true;
            } else {
                haveIdInString = true;
            }
            yybegin(INJ_COMMON_STATE);
        }

        yypushback(yylength() - 1 - (isEscape ? 1 : 0));
        return process(isEscape ? STRING : INTERPOLATED_IDENTIFIER);
    }



  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  ScalaLexer(java.io.Reader in, Set<String> baseClasses) {
  this.baseClasses = baseClasses;
    this.zzReader = in;
  }


  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x110000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 5796) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException("Reader returned 0 characters. See JFlex examples for workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      /* If numRead == requested, we might have requested to few chars to
         encode a full Unicode character. We assume that a Reader would
         otherwise never return half characters. */
      if (numRead == requested) {
        if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    zzFinalHighSurrogate = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public Set<String> nextSpan() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1: 
            { return process(TEXT);
            } 
            // fall through
          case 36: break;
          case 2: 
            { return process(IDENTIFIER);
            } 
            // fall through
          case 37: break;
          case 3: 
            { return process(CLASS_IDENTIFIER);
            } 
            // fall through
          case 38: break;
          case 4: 
            { return process(NUMBER);
            } 
            // fall through
          case 39: break;
          case 5: 
            { return process(PUNCTUATION);
            } 
            // fall through
          case 40: break;
          case 6: 
            { return process(OPERATOR);
            } 
            // fall through
          case 41: break;
          case 7: 
            { yybegin(YYINITIAL); return process(WHITESPACE);
            } 
            // fall through
          case 42: break;
          case 8: 
            { return process(BAD_CHAR);
            } 
            // fall through
          case 43: break;
          case 9: 
            { if (shouldProcessBracesForInterpolated()) { nestedString.getFirst().increment(); } return process(PUNCTUATION);
            } 
            // fall through
          case 44: break;
          case 10: 
            { if (shouldProcessBracesForInterpolated()) {
                                              InterpolationLevel level = nestedString.getFirst();
                                              level.decrement();

                                              if (level.getValue() == 0) {
                                                yybegin(level.getState());
                                              }
                                            }
                                            return process(PUNCTUATION);
            } 
            // fall through
          case 45: break;
          case 11: 
            { yybegin(INSIDE_INTERPOLATED_STRING); nestedString.push(new InterpolationLevel()); return process(STRING);
            } 
            // fall through
          case 46: break;
          case 12: 
            { return process(STRING);
            } 
            // fall through
          case 47: break;
          case 13: 
            { yybegin(COMMON_STATE); return process(BAD_CHAR);
            } 
            // fall through
          case 48: break;
          case 14: 
            { return processOutsideString();
            } 
            // fall through
          case 49: break;
          case 15: 
            { int length = yylength();
      int number = length;
      for (int i = 1; i < length; i++) {
        if (yycharat(i) == '$') {
          number = i;
          break;
        }
      }

      yypushback(length - number);
      boolean isThis = "this".contentEquals(yytext());
      return process(isThis ? THIS : IDENTIFIER);
            } 
            // fall through
          case 50: break;
          case 16: 
            // general lookahead, find correct zzMarkedPos
            { int zzFState = 6;
              int zzFPos = zzStartRead;
              if (zzFin.length <= zzBufferL.length) { zzFin = new boolean[zzBufferL.length+1]; }
              boolean zzFinL[] = zzFin;
              while (zzFState != -1 && zzFPos < zzMarkedPos) {
                zzFinL[zzFPos] = ((zzAttrL[zzFState] & 1) == 1);
                zzInput = Character.codePointAt(zzBufferL, zzFPos, zzMarkedPos);
                zzFPos += Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
              }
              if (zzFState != -1) { zzFinL[zzFPos++] = ((zzAttrL[zzFState] & 1) == 1); } 
              while (zzFPos <= zzMarkedPos) {
                zzFinL[zzFPos++] = false;
              }

              zzFState = 7;
              zzFPos = zzMarkedPos;
              while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                zzInput = Character.codePointBefore(zzBufferL, zzFPos, zzStartRead);
                zzFPos -= Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
              };
              zzMarkedPos = zzFPos;
            }
            { yybegin(WAIT_FOR_INTERPOLATED_STRING);
  if (yytext().endsWith("\"\"")) yypushback(2);
  return process(haveIdInString || haveIdInMultilineString ? IDENTIFIER : INTERPOLATED_IDENTIFIER);
            } 
            // fall through
          case 51: break;
          case 17: 
            { return process(KEYWORD);
            } 
            // fall through
          case 52: break;
          case 18: 
            { return process(ANNOTATION);
            } 
            // fall through
          case 53: break;
          case 19: 
            { return process(SINGLEL_COMMENT);
            } 
            // fall through
          case 54: break;
          case 20: 
            { return process(SYMBOL);
            } 
            // fall through
          case 55: break;
          case 21: 
            { yybegin(COMMON_STATE);
                                            yypushback(yylength());
                                            return process(PUNCTUATION);
            } 
            // fall through
          case 56: break;
          case 22: 
            { return processInsideString(false);
            } 
            // fall through
          case 57: break;
          case 23: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzStartRead, 1);
            { yybegin(COMMON_STATE); return process(OPERATOR);
            } 
            // fall through
          case 58: break;
          case 24: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzStartRead, 1);
            { return process(STRING);
            } 
            // fall through
          case 59: break;
          case 25: 
            { return processInsideString(true);
            } 
            // fall through
          case 60: break;
          case 26: 
            // general lookahead, find correct zzMarkedPos
            { int zzFState = 8;
              int zzFPos = zzStartRead;
              if (zzFin.length <= zzBufferL.length) { zzFin = new boolean[zzBufferL.length+1]; }
              boolean zzFinL[] = zzFin;
              while (zzFState != -1 && zzFPos < zzMarkedPos) {
                zzFinL[zzFPos] = ((zzAttrL[zzFState] & 1) == 1);
                zzInput = Character.codePointAt(zzBufferL, zzFPos, zzMarkedPos);
                zzFPos += Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
              }
              if (zzFState != -1) { zzFinL[zzFPos++] = ((zzAttrL[zzFState] & 1) == 1); } 
              while (zzFPos <= zzMarkedPos) {
                zzFinL[zzFPos++] = false;
              }

              zzFState = 9;
              zzFPos = zzMarkedPos;
              while (!zzFinL[zzFPos] || (zzAttrL[zzFState] & 1) != 1) {
                zzInput = Character.codePointBefore(zzBufferL, zzFPos, zzStartRead);
                zzFPos -= Character.charCount(zzInput);
                zzFState = zzTransL[ zzRowMapL[zzFState] + zzCMapL[zzInput] ];
              };
              zzMarkedPos = zzFPos;
            }
            { return process(NUMBER);
            } 
            // fall through
          case 61: break;
          case 27: 
            { return process(CHAR);
            } 
            // fall through
          case 62: break;
          case 28: 
            { yybegin(INSIDE_MULTI_LINE_INTERPOLATED_STRING); nestedString.push(new InterpolationLevel()); return process(STRING);
            } 
            // fall through
          case 63: break;
          case 29: 
            // lookahead expression with fixed base length
            zzMarkedPos = Character.offsetByCodePoints
                (zzBufferL, zzStartRead, zzEndRead - zzStartRead, zzStartRead, 2);
            { return process(STRING);
            } 
            // fall through
          case 64: break;
          case 30: 
            { return process(THIS);
            } 
            // fall through
          case 65: break;
          case 31: 
            { return process(BOOLEAN);
            } 
            // fall through
          case 66: break;
          case 32: 
            { return process(MODIFIER);
            } 
            // fall through
          case 67: break;
          case 33: 
            { return process(NULL);
            } 
            // fall through
          case 68: break;
          case 34: 
            { return process(MULTIL_COMMENT);
            } 
            // fall through
          case 69: break;
          case 35: 
            { yypushback(yylength() - 1); return process(STRING);
            } 
            // fall through
          case 70: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
