/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.test.lang.rule;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.rule.InternalApiBridge;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;
import net.sourceforge.pmd.lang.rule.RuleSetWriter;
import net.sourceforge.pmd.lang.rule.xpath.XPathRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.log.PmdReporter;
import net.sourceforge.pmd.util.log.internal.MessageReporterBase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.event.Level;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractRuleSetFactoryTest {
    private static ValidateDefaultHandler validateDefaultHandler;
    private static SAXParser saxParser;
    protected Set<String> validXPathClassNames = new HashSet<String>();
    private final Set<String> languagesToSkip = new HashSet<String>();

    public AbstractRuleSetFactoryTest() {
        this(new String[0]);
    }

    public AbstractRuleSetFactoryTest(String ... languagesToSkip) {
        this.languagesToSkip.add("dummy");
        this.languagesToSkip.addAll(Arrays.asList(languagesToSkip));
        this.validXPathClassNames.add(XPathRule.class.getName());
    }

    public AbstractRuleSetFactoryTest(Language ... languagesToSkip) {
        this((String[])Arrays.stream(languagesToSkip).map(Language::getId).toArray(String[]::new));
    }

    @BeforeAll
    static void init() throws Exception {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setValidating(true);
        saxParserFactory.setNamespaceAware(true);
        saxParserFactory.setFeature("http://xml.org/sax/features/validation", true);
        saxParserFactory.setFeature("http://apache.org/xml/features/validation/schema", true);
        saxParserFactory.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        validateDefaultHandler = new ValidateDefaultHandler();
        saxParser = saxParserFactory.newSAXParser();
    }

    @Test
    void testAllPMDBuiltInRulesMeetConventions() throws Exception {
        int invalidSinceAttributes = 0;
        int invalidExternalInfoURL = 0;
        int invalidClassName = 0;
        int invalidRegexSuppress = 0;
        int invalidXPathSuppress = 0;
        StringBuilder messages = new StringBuilder();
        List<String> ruleSetFileNames = this.getRuleSetFileNames();
        for (String fileName : ruleSetFileNames) {
            RuleSet ruleSet = this.loadRuleSetByFileName(fileName);
            for (Rule rule : ruleSet.getRules()) {
                if (rule instanceof RuleReference) continue;
                Language language = rule.getLanguage();
                String group = fileName.substring(fileName.lastIndexOf(47) + 1);
                if ((group = group.substring(0, group.indexOf(".xml"))).indexOf(45) >= 0) {
                    group = group.substring(0, group.indexOf(45));
                }
                if (rule.getSince() == null) {
                    ++invalidSinceAttributes;
                    messages.append("Rule ").append(fileName).append("/").append(rule.getName()).append(" is missing 'since' attribute\n");
                }
                if (rule.getExternalInfoUrl() == null || "".equalsIgnoreCase(rule.getExternalInfoUrl())) {
                    ++invalidExternalInfoURL;
                    messages.append("Rule ").append(fileName).append("/").append(rule.getName()).append(" is missing 'externalInfoURL' attribute\n");
                } else {
                    String expectedExternalInfoURL = "https://docs.pmd-code.org/.+/pmd_rules_" + language.getId() + "_" + IOUtil.getFilenameBase((String)fileName) + ".html#" + rule.getName().toLowerCase(Locale.ROOT);
                    if (rule.getExternalInfoUrl() == null || !rule.getExternalInfoUrl().matches(expectedExternalInfoURL)) {
                        ++invalidExternalInfoURL;
                        messages.append("Rule ").append(fileName).append("/").append(rule.getName()).append(" seems to have an invalid 'externalInfoURL' value (").append(rule.getExternalInfoUrl()).append("), it should be:").append(expectedExternalInfoURL).append('\n');
                    }
                }
                String expectedClassName = "net.sourceforge.pmd.lang." + language.getId() + ".rule." + group + "." + rule.getName() + "Rule";
                if (!rule.getRuleClass().equals(expectedClassName) && !this.validXPathClassNames.contains(rule.getRuleClass())) {
                    ++invalidClassName;
                    messages.append("Rule ").append(fileName).append("/").append(rule.getName()).append(" seems to have an invalid 'class' value (").append(rule.getRuleClass()).append("), it should be:").append(expectedClassName).append('\n');
                }
                if (((Optional)rule.getProperty(Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR)).isPresent()) {
                    ++invalidRegexSuppress;
                    messages.append("Rule ").append(fileName).append("/").append(rule.getName()).append(" should not have '").append(Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR.name()).append("', this is intended for end user customization only.\n");
                }
                if (!((Optional)rule.getProperty(Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR)).isPresent()) continue;
                ++invalidXPathSuppress;
                messages.append("Rule ").append(fileName).append("/").append(rule.getName()).append(" should not have '").append(Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR.name()).append("', this is intended for end user customization only.").append(System.lineSeparator());
            }
        }
        if (invalidSinceAttributes > 0 || invalidExternalInfoURL > 0 || invalidClassName > 0 || invalidRegexSuppress > 0 || invalidXPathSuppress > 0) {
            Assertions.fail((String)("All built-in PMD rules need 'since' attribute (" + invalidSinceAttributes + " are missing), a proper ExternalURLInfo (" + invalidExternalInfoURL + " are invalid), a class name meeting conventions (" + invalidClassName + " are invalid), no '" + Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR.name() + "' property (" + invalidRegexSuppress + " are invalid), and no '" + Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR.name() + "' property (" + invalidXPathSuppress + " are invalid)\n" + messages));
        }
    }

    @Test
    void testXmlSchema() throws Exception {
        boolean allValid = true;
        List<String> ruleSetFileNames = this.getRuleSetFileNames();
        for (String fileName : ruleSetFileNames) {
            boolean valid = this.validateAgainstSchema(fileName);
            allValid = allValid && valid;
        }
        Assertions.assertTrue((boolean)allValid, (String)"All XML must parse without producing validation messages.");
    }

    @Test
    void verifyCorrectXmlEncoding() throws Exception {
        boolean allValid = true;
        List<String> ruleSetFileNames = this.getRuleSetFileNames();
        StringBuilder messages = new StringBuilder();
        for (String fileName : ruleSetFileNames) {
            boolean valid = AbstractRuleSetFactoryTest.hasCorrectEncoding(fileName);
            boolean bl = allValid = allValid && valid;
            if (valid) continue;
            messages.append("RuleSet ").append(fileName).append(" is missing XML encoding or not using UTF8\n");
        }
        Assertions.assertTrue((boolean)allValid, (String)("All XML must use correct XML encoding\n" + messages));
    }

    public static boolean hasCorrectEncoding(String fileName) throws IOException {
        try (InputStream inputStream = AbstractRuleSetFactoryTest.loadResourceAsStream(fileName);){
            byte[] expectedBytes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>".getBytes(StandardCharsets.UTF_8);
            byte[] bytes = new byte[expectedBytes.length];
            int count = inputStream.read(bytes);
            if (count != expectedBytes.length || !Arrays.equals(expectedBytes, bytes)) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    @Test
    void testDtd() throws Exception {
        boolean allValid = true;
        List<String> ruleSetFileNames = this.getRuleSetFileNames();
        for (String fileName : ruleSetFileNames) {
            boolean valid = this.validateAgainstDtd(fileName);
            allValid = allValid && valid;
        }
        Assertions.assertTrue((boolean)allValid, (String)"All XML must parse without producing validation messages.");
    }

    @Test
    void testReadWriteRoundTrip() throws Exception {
        List<String> ruleSetFileNames = this.getRuleSetFileNames();
        for (String fileName : ruleSetFileNames) {
            this.testRuleSet(fileName);
        }
    }

    private List<String> getRuleSetFileNames() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (Language language : LanguageRegistry.PMD.getLanguages()) {
            if (this.languagesToSkip.contains(language.getId())) continue;
            result.addAll(this.getRuleSetFileNames(language.getId()));
        }
        return result;
    }

    private List<String> getRuleSetFileNames(String language) throws IOException {
        ArrayList<String> ruleSetFileNames = new ArrayList<String>();
        ruleSetFileNames.addAll(this.getRuleSetFileNames(language, "rulesets/" + language + "/rulesets.properties"));
        ruleSetFileNames.addAll(this.getRuleSetFileNames(language, "category/" + language + "/categories.properties"));
        return ruleSetFileNames;
    }

    private List<String> getRuleSetFileNames(String language, String propertiesPath) throws IOException {
        ArrayList<String> ruleSetFileNames = new ArrayList<String>();
        Properties properties = new Properties();
        InputStream input = AbstractRuleSetFactoryTest.loadResourceAsStream(propertiesPath);
        if (input == null) {
            System.err.println("No rulesets found for language " + language + " at " + propertiesPath);
            return Collections.emptyList();
        }
        try (InputStream is = input;){
            properties.load(is);
        }
        String fileNames = properties.getProperty("rulesets.filenames");
        StringTokenizer st = new StringTokenizer(fileNames, ",");
        while (st.hasMoreTokens()) {
            ruleSetFileNames.add(st.nextToken());
        }
        return ruleSetFileNames;
    }

    private RuleSet loadRuleSetByFileName(String ruleSetFileName) {
        final StringBuilder messages = new StringBuilder();
        class Reporter
        extends MessageReporterBase {
            Reporter() {
            }

            protected void logImpl(Level level, String message) {
                messages.append(message).append(System.lineSeparator());
            }
        }
        RuleSet ruleSet = InternalApiBridge.withReporter((RuleSetLoader)new RuleSetLoader(), (PmdReporter)new Reporter()).loadFromResource(ruleSetFileName);
        MatcherAssert.assertThat((String)"There should be no warnings while loading the ruleset", (Object)messages.toString(), (Matcher)Matchers.emptyString());
        return ruleSet;
    }

    private boolean validateAgainstSchema(String fileName) throws IOException, SAXException {
        try (InputStream inputStream = AbstractRuleSetFactoryTest.loadResourceAsStream(fileName);){
            boolean valid = this.validateAgainstSchema(inputStream);
            if (!valid) {
                System.err.println("Validation against XML Schema failed for: " + fileName);
            }
            boolean bl = valid;
            return bl;
        }
    }

    private boolean validateAgainstSchema(InputStream inputStream) throws IOException, SAXException {
        saxParser.parse(inputStream, (DefaultHandler)validateDefaultHandler.resetValid());
        inputStream.close();
        return validateDefaultHandler.isValid();
    }

    private boolean validateAgainstDtd(String fileName) throws IOException, SAXException {
        try (InputStream inputStream = AbstractRuleSetFactoryTest.loadResourceAsStream(fileName);){
            boolean valid = this.validateAgainstDtd(inputStream);
            if (!valid) {
                System.err.println("Validation against DTD failed for: " + fileName);
            }
            boolean bl = valid;
            return bl;
        }
    }

    private boolean validateAgainstDtd(InputStream inputStream) throws IOException, SAXException {
        String file = this.readFullyToString(inputStream);
        inputStream.close();
        String rulesetNamespace = "http://pmd.sourceforge.net/ruleset/2.0.0";
        file = file.replaceAll("<\\?xml [ a-zA-Z0-9=\".-]*\\?>", "");
        file = file.replaceAll("xmlns=\"" + rulesetNamespace + "\"", "");
        file = file.replaceAll("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"", "");
        file = file.replaceAll("xsi:schemaLocation=\"" + rulesetNamespace + " https://pmd.sourceforge.io/ruleset_\\d_0_0.xsd\"", "");
        file = "http://pmd.sourceforge.net/ruleset/2.0.0".equals(rulesetNamespace) ? "<?xml version=\"1.0\"?>" + System.lineSeparator() + "<!DOCTYPE ruleset SYSTEM \"https://pmd.sourceforge.io/ruleset_2_0_0.dtd\">" + System.lineSeparator() + file : "<?xml version=\"1.0\"?>" + System.lineSeparator() + "<!DOCTYPE ruleset>" + System.lineSeparator() + file;
        try (ByteArrayInputStream modifiedStream = new ByteArrayInputStream(file.getBytes());){
            saxParser.parse((InputStream)modifiedStream, (DefaultHandler)validateDefaultHandler.resetValid());
        }
        return validateDefaultHandler.isValid();
    }

    private String readFullyToString(InputStream inputStream) throws IOException {
        StringBuilder buf = new StringBuilder(65536);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                buf.append(System.lineSeparator());
            }
            String string = buf.toString();
            return string;
        }
    }

    private static InputStream loadResourceAsStream(String resource) {
        return AbstractRuleSetFactoryTest.class.getClassLoader().getResourceAsStream(resource);
    }

    private void testRuleSet(String fileName) throws IOException, SAXException {
        RuleSet ruleSet1 = this.loadRuleSetByFileName(fileName);
        ByteArrayOutputStream outputStream1 = new ByteArrayOutputStream();
        RuleSetWriter writer1 = new RuleSetWriter((OutputStream)outputStream1);
        writer1.write(ruleSet1);
        writer1.close();
        String xml2 = new String(outputStream1.toByteArray());
        RuleSetLoader loader = new RuleSetLoader();
        RuleSet ruleSet2 = loader.loadFromString("readRuleSet1.xml", xml2);
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        RuleSetWriter writer2 = new RuleSetWriter((OutputStream)outputStream2);
        writer2.write(ruleSet2);
        writer2.close();
        String xml3 = new String(outputStream2.toByteArray());
        RuleSet ruleSet3 = loader.loadFromString("readRuleSet2.xml", xml3);
        Assertions.assertTrue((boolean)this.validateAgainstSchema(new ByteArrayInputStream(xml2.getBytes())), (String)("1st roundtrip RuleSet XML is not valid against Schema (filename: " + fileName + ")"));
        Assertions.assertTrue((boolean)this.validateAgainstSchema(new ByteArrayInputStream(xml3.getBytes())), (String)("2nd roundtrip RuleSet XML is not valid against Schema (filename: " + fileName + ")"));
        Assertions.assertTrue((boolean)this.validateAgainstDtd(new ByteArrayInputStream(xml2.getBytes())), (String)("1st roundtrip RuleSet XML is not valid against DTD (filename: " + fileName + ")"));
        Assertions.assertTrue((boolean)this.validateAgainstDtd(new ByteArrayInputStream(xml3.getBytes())), (String)("2nd roundtrip RuleSet XML is not valid against DTD (filename: " + fileName + ")"));
        this.assertEqualsRuleSet("Original RuleSet and 1st roundtrip Ruleset not the same (filename: " + fileName + ")", ruleSet1, ruleSet2);
        this.assertEqualsRuleSet("1st roundtrip Ruleset and 2nd roundtrip RuleSet not the same (filename: " + fileName + ")", ruleSet2, ruleSet3);
        Assertions.assertEquals((Object)xml2, (Object)xml3, (String)("1st roundtrip RuleSet XML and 2nd roundtrip RuleSet XML (filename: " + fileName + ")"));
    }

    private void assertEqualsRuleSet(String message, RuleSet ruleSet1, RuleSet ruleSet2) {
        Assertions.assertEquals((Object)ruleSet1.getName(), (Object)ruleSet2.getName(), (String)(message + ", RuleSet name"));
        Assertions.assertEquals((Object)ruleSet1.getDescription(), (Object)ruleSet2.getDescription(), (String)(message + ", RuleSet description"));
        Assertions.assertEquals((Object)ruleSet1.getFileExclusions(), (Object)ruleSet2.getFileExclusions(), (String)(message + ", RuleSet exclude patterns"));
        Assertions.assertEquals((Object)ruleSet1.getFileInclusions(), (Object)ruleSet2.getFileInclusions(), (String)(message + ", RuleSet include patterns"));
        Assertions.assertEquals((int)ruleSet1.getRules().size(), (int)ruleSet2.getRules().size(), (String)(message + ", RuleSet rule count"));
        for (int i = 0; i < ruleSet1.getRules().size(); ++i) {
            Rule rule2;
            Rule rule1 = (Rule)((List)ruleSet1.getRules()).get(i);
            Assertions.assertFalse((rule1 instanceof RuleReference != (rule2 = (Rule)((List)ruleSet2.getRules()).get(i)) instanceof RuleReference ? 1 : 0) != 0, (String)(message + ", Different RuleReference"));
            if (rule1 instanceof RuleReference) {
                RuleReference ruleReference1 = (RuleReference)rule1;
                RuleReference ruleReference2 = (RuleReference)rule2;
                Assertions.assertEquals((Object)ruleReference1.getOverriddenMinimumLanguageVersion(), (Object)ruleReference2.getOverriddenMinimumLanguageVersion(), (String)(message + ", RuleReference overridden minimum language version"));
                Assertions.assertEquals((Object)ruleReference1.getOverriddenMaximumLanguageVersion(), (Object)ruleReference2.getOverriddenMaximumLanguageVersion(), (String)(message + ", RuleReference overridden maximum language version"));
                Assertions.assertEquals((Object)ruleReference1.isOverriddenDeprecated(), (Object)ruleReference2.isOverriddenDeprecated(), (String)(message + ", RuleReference overridden deprecated"));
                Assertions.assertEquals((Object)ruleReference1.getOverriddenName(), (Object)ruleReference2.getOverriddenName(), (String)(message + ", RuleReference overridden name"));
                Assertions.assertEquals((Object)ruleReference1.getOverriddenDescription(), (Object)ruleReference2.getOverriddenDescription(), (String)(message + ", RuleReference overridden description"));
                Assertions.assertEquals((Object)ruleReference1.getOverriddenMessage(), (Object)ruleReference2.getOverriddenMessage(), (String)(message + ", RuleReference overridden message"));
                Assertions.assertEquals((Object)ruleReference1.getOverriddenExternalInfoUrl(), (Object)ruleReference2.getOverriddenExternalInfoUrl(), (String)(message + ", RuleReference overridden external info url"));
                Assertions.assertEquals((Object)ruleReference1.getOverriddenPriority(), (Object)ruleReference2.getOverriddenPriority(), (String)(message + ", RuleReference overridden priority"));
                Assertions.assertEquals((Object)ruleReference1.getOverriddenExamples(), (Object)ruleReference2.getOverriddenExamples(), (String)(message + ", RuleReference overridden examples"));
            }
            Assertions.assertEquals((Object)rule1.getName(), (Object)rule2.getName(), (String)(message + ", Rule name"));
            Assertions.assertEquals((Object)rule1.getRuleClass(), (Object)rule2.getRuleClass(), (String)(message + ", Rule class"));
            Assertions.assertEquals((Object)rule1.getDescription(), (Object)rule2.getDescription(), (String)(message + ", Rule description " + rule1.getName()));
            Assertions.assertEquals((Object)rule1.getMessage(), (Object)rule2.getMessage(), (String)(message + ", Rule message"));
            Assertions.assertEquals((Object)rule1.getExternalInfoUrl(), (Object)rule2.getExternalInfoUrl(), (String)(message + ", Rule external info url"));
            Assertions.assertEquals((Object)rule1.getPriority(), (Object)rule2.getPriority(), (String)(message + ", Rule priority"));
            Assertions.assertEquals((Object)rule1.getExamples(), (Object)rule2.getExamples(), (String)(message + ", Rule examples"));
            List propertyDescriptors1 = rule1.getPropertyDescriptors();
            List propertyDescriptors2 = rule2.getPropertyDescriptors();
            Assertions.assertEquals((Object)propertyDescriptors1, (Object)propertyDescriptors2, (String)(message + ", Rule property descriptor "));
            for (int j = 0; j < propertyDescriptors1.size(); ++j) {
                Object value1 = rule1.getProperty((PropertyDescriptor)propertyDescriptors1.get(j));
                Object value2 = rule2.getProperty((PropertyDescriptor)propertyDescriptors2.get(j));
                if (value1 instanceof Pattern && value2 instanceof Pattern) {
                    value1 = ((Pattern)value1).pattern();
                    value2 = ((Pattern)value2).pattern();
                }
                Assertions.assertEquals((Object)value1, (Object)value2, (String)(message + ", Rule " + rule1.getName() + " property " + ((PropertyDescriptor)propertyDescriptors1.get(j)).name()));
            }
            Assertions.assertEquals((int)propertyDescriptors1.size(), (int)propertyDescriptors2.size(), (String)(message + ", Rule property descriptor count"));
        }
    }

    private static class ValidateDefaultHandler
    extends DefaultHandler {
        private boolean valid = true;
        private final Map<String, String> schemaMapping = new HashMap<String, String>();

        ValidateDefaultHandler() {
            this.schemaMapping.put("https://pmd.sourceforge.io/ruleset_2_0_0.xsd", "ruleset_2_0_0.xsd");
            this.schemaMapping.put("https://pmd.sourceforge.io/ruleset_2_0_0.dtd", "ruleset_2_0_0.dtd");
        }

        public ValidateDefaultHandler resetValid() {
            this.valid = true;
            return this;
        }

        public boolean isValid() {
            return this.valid;
        }

        @Override
        public void error(SAXParseException e) {
            this.log("Error", e);
        }

        @Override
        public void fatalError(SAXParseException e) {
            this.log("FatalError", e);
        }

        @Override
        public void warning(SAXParseException e) {
            this.log("Warning", e);
        }

        private void log(String prefix, SAXParseException e) {
            String message = prefix + " at (" + e.getLineNumber() + ", " + e.getColumnNumber() + "): " + e.getMessage();
            System.err.println(message);
            this.valid = false;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException {
            String resource = this.schemaMapping.get(systemId);
            if (resource != null) {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(resource);
                if (inputStream == null) {
                    throw new FileNotFoundException(resource);
                }
                return new InputSource(inputStream);
            }
            throw new IllegalArgumentException("No clue how to handle: publicId=" + publicId + ", systemId=" + systemId);
        }
    }
}

