/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import com.github.stefanbirkner.systemlambda.Statement;
import com.github.stefanbirkner.systemlambda.SystemLambda;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import net.sourceforge.pmd.internal.Slf4jSimpleConfiguration;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.io.TempDir;

public abstract class AbstractAntTestHelper {
    @TempDir
    private Path tempFolder;
    protected String pathToTestScript = "target/test-classes/net/sourceforge/pmd/ant/xml";
    protected String antTestScriptFilename;
    private Project antProject;
    private StringBuilder log = new StringBuilder();
    private String output;

    @BeforeEach
    public void setUp() throws IOException {
        this.validatePostConstruct();
        this.antProject = new Project();
        this.antProject.init();
        this.antProject.addBuildListener((BuildListener)new AntBuildListener());
        ProjectHelper.configureProject((Project)this.antProject, (File)new File(this.pathToTestScript + File.separator + this.antTestScriptFilename));
        Path tmpFile = Files.createTempFile(this.tempFolder, "pmd-ant-tests", null, new FileAttribute[0]);
        Files.deleteIfExists(tmpFile);
        this.antProject.setProperty("tmpfile", tmpFile.toAbsolutePath().toString());
    }

    @AfterAll
    static void resetLogging() {
        Slf4jSimpleConfiguration.reconfigureDefaultLogLevel(null);
    }

    public File currentTempFile() {
        String tmpname = this.antProject.getProperty("tmpfile");
        return tmpname == null ? null : new File(tmpname);
    }

    private void validatePostConstruct() {
        if (this.pathToTestScript == null || "".equals(this.pathToTestScript) || this.antTestScriptFilename == null || "".equals(this.antTestScriptFilename)) {
            throw new IllegalStateException("Unit tests for Ant script badly initialized");
        }
    }

    public String executeTarget(String target) {
        try {
            AbstractAntTestHelper.restoreLocale(() -> SystemLambda.restoreSystemProperties(() -> {
                this.output = AbstractAntTestHelper.tapSystemOut(() -> this.antProject.executeTarget(target));
            }));
            return this.output;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getLog() {
        return this.log.toString();
    }

    public void assertOutputContaining(String text) {
        MatcherAssert.assertThat((Object)this.output, (Matcher)Matchers.containsString((String)text));
    }

    public void assertContains(String text, String toFind) {
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.containsString((String)toFind));
    }

    public void assertDoesntContain(String text, String toFind) {
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)toFind)));
    }

    private static void restoreLocale(Statement statement) throws Exception {
        Locale originalLocale = Locale.getDefault();
        try {
            statement.execute();
        }
        finally {
            Locale.setDefault(originalLocale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String tapSystemOut(Statement statement) throws Exception {
        PrintStream originalOut = System.out;
        ByteArrayOutputStream text = new ByteArrayOutputStream();
        String currentDefaultCharset = System.getProperty("file.encoding");
        try {
            PrintStream replacement = new PrintStream((OutputStream)text, true, currentDefaultCharset);
            System.setOut(replacement);
            statement.execute();
        }
        finally {
            System.setOut(originalOut);
        }
        String result = text.toString(currentDefaultCharset);
        return result.replace(System.lineSeparator(), "\n");
    }

    private final class AntBuildListener
    extends DefaultLogger {
        private AntBuildListener() {
            this.msgOutputLevel = 2;
        }

        protected void printMessage(String message, PrintStream stream, int priority) {
            AbstractAntTestHelper.this.log.append(message);
        }

        public void messageLogged(BuildEvent buildEvent) {
            if (buildEvent.getPriority() <= 2) {
                AbstractAntTestHelper.this.log.append(buildEvent.getMessage());
            }
        }
    }
}

