/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetLoader;
import net.sourceforge.pmd.ant.SourceLanguage;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class AbstractLanguageVersionTest {
    protected static Language getLanguage(String name) {
        return LanguageRegistry.PMD.getLanguageByFullName(name);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testFindVersionsForLanguageNameAndVersion(TestDescriptor testDescriptor) {
        SourceLanguage sourceLanguage = new SourceLanguage();
        sourceLanguage.setName(testDescriptor.getName());
        sourceLanguage.setVersion(testDescriptor.getVersion());
        Language language = AbstractLanguageVersionTest.getLanguage(sourceLanguage.getName());
        LanguageVersion languageVersion = null;
        if (language != null) {
            languageVersion = language.getVersion(sourceLanguage.getVersion());
        }
        Assertions.assertEquals((Object)testDescriptor.getExpected(), languageVersion);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testRegisteredRulesets(TestDescriptor testDescriptor) throws Exception {
        if (testDescriptor.getExpected() == null) {
            return;
        }
        Properties props = new Properties();
        String rulesetsProperties = "/category/" + testDescriptor.getSimpleTerseName() + "/categories.properties";
        try (InputStream inputStream = this.getClass().getResourceAsStream(rulesetsProperties);){
            if (inputStream == null) {
                throw new IOException();
            }
            props.load(inputStream);
        }
        this.assertRulesetsAndCategoriesProperties(props);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testOldRegisteredRulesets(TestDescriptor testDescriptor) throws Exception {
        if (testDescriptor.getExpected() == null) {
            return;
        }
        Properties props = new Properties();
        String rulesetsProperties = "/rulesets/" + testDescriptor.getSimpleTerseName() + "/rulesets.properties";
        InputStream inputStream = this.getClass().getResourceAsStream(rulesetsProperties);
        if (inputStream != null) {
            try (InputStream in = inputStream;){
                props.load(in);
            }
            this.assertRulesetsAndCategoriesProperties(props);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testVersionsAreDistinct(TestDescriptor testDescriptor) {
        LanguageVersion expected = testDescriptor.getExpected();
        if (expected == null) {
            return;
        }
        Language lang = expected.getLanguage();
        int count = 0;
        for (LanguageVersion lv : lang.getVersions()) {
            if (!lv.equals(expected)) continue;
            ++count;
        }
        Assertions.assertEquals((int)1, (int)count, (String)("Expected exactly one occurrence of " + expected + " in the language versions of its language"));
    }

    private void assertRulesetsAndCategoriesProperties(Properties props) throws IOException {
        String[] rulesets;
        String rulesetFilenames = props.getProperty("rulesets.filenames");
        Assertions.assertNotNull((Object)rulesetFilenames);
        RuleSetLoader rulesetLoader = new RuleSetLoader();
        if (rulesetFilenames.trim().isEmpty()) {
            return;
        }
        for (String r : rulesets = rulesetFilenames.split(",")) {
            RuleSet ruleset = rulesetLoader.loadFromResource(r);
            Assertions.assertNotNull((Object)ruleset);
        }
    }

    public static class TestDescriptor {
        private final String name;
        private final String version;
        private final String simpleTerseName;
        private final LanguageVersion expected;

        public TestDescriptor(String name, String terseName, String version, LanguageVersion expected) {
            this.name = name;
            this.version = version;
            this.simpleTerseName = terseName;
            this.expected = expected;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSimpleTerseName() {
            return this.simpleTerseName;
        }

        public LanguageVersion getExpected() {
            return this.expected;
        }
    }
}

