/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.testframework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetLoadException;
import net.sourceforge.pmd.RuleSetLoader;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.test.schema.RuleTestCollection;
import net.sourceforge.pmd.test.schema.RuleTestDescriptor;
import net.sourceforge.pmd.test.schema.TestSchemaParser;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.xml.sax.InputSource;

public abstract class RuleTst {
    protected void setUp() {
    }

    protected List<Rule> getRules() {
        return Collections.emptyList();
    }

    public static Rule findRule(String ruleSet, String ruleName) {
        try {
            RuleSet parsedRset = new RuleSetLoader().warnDeprecated(false).loadFromResource(ruleSet);
            Rule rule = parsedRset.getRuleByName(ruleName);
            if (rule == null) {
                Assertions.fail((String)("Rule " + ruleName + " not found in ruleset " + ruleSet));
            } else {
                rule.setRuleSetName(ruleSet);
            }
            return rule;
        }
        catch (RuleSetLoadException e) {
            e.printStackTrace();
            Assertions.fail((String)("Couldn't find ruleset " + ruleSet));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runTest(RuleTestDescriptor test) {
        Rule rule = test.getRule();
        rule = this.reinitializeRule(rule);
        Map oldProperties = rule.getPropertiesByPropertyDescriptor();
        try {
            int res;
            Report report;
            try {
                String dysfunctionReason;
                if (test.getProperties() != null) {
                    for (Map.Entry<Object, Object> entry : test.getProperties().entrySet()) {
                        String propertyName = (String)entry.getKey();
                        PropertyDescriptor propertyDescriptor = rule.getPropertyDescriptor(propertyName);
                        if (propertyDescriptor == null) {
                            throw new IllegalArgumentException("No such property '" + propertyName + "' on Rule " + rule.getName());
                        }
                        Object value = propertyDescriptor.valueFrom((String)entry.getValue());
                        rule.setProperty(propertyDescriptor, value);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(dysfunctionReason = rule.dysfunctionReason()))) {
                    throw new RuntimeException("Rule is not configured correctly: " + dysfunctionReason);
                }
                report = this.processUsingStringReader(test, rule);
                res = report.getViolations().size();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException('\"' + test.getDescription() + "\" failed", e);
            }
            if (test.getExpectedProblems() != res) {
                this.printReport(test, report);
            }
            Assertions.assertEquals((int)test.getExpectedProblems(), (int)res, (String)('\"' + test.getDescription() + "\" resulted in wrong number of failures,"));
            this.assertMessages(report, test);
            this.assertLineNumbers(report, test);
        }
        finally {
            for (Map.Entry entry : oldProperties.entrySet()) {
                rule.setProperty((PropertyDescriptor)entry.getKey(), entry.getValue());
            }
        }
    }

    private Rule reinitializeRule(Rule rule) {
        return rule.deepCopy();
    }

    private void assertMessages(Report report, RuleTestDescriptor test) {
        if (report == null || test.getExpectedMessages().isEmpty()) {
            return;
        }
        List expectedMessages = test.getExpectedMessages();
        if (report.getViolations().size() != expectedMessages.size()) {
            throw new RuntimeException("Test setup error: number of expected messages doesn't match number of violations for test case '" + test.getDescription() + "'");
        }
        int index = 0;
        for (RuleViolation violation : report.getViolations()) {
            String actual = violation.getDescription();
            if (!((String)expectedMessages.get(index)).equals(actual)) {
                this.printReport(test, report);
            }
            Assertions.assertEquals(expectedMessages.get(index), (Object)actual, (String)('\"' + test.getDescription() + "\" produced wrong message on violation number " + (index + 1) + "."));
            ++index;
        }
    }

    private void assertLineNumbers(Report report, RuleTestDescriptor test) {
        if (report == null || test.getExpectedLineNumbers().isEmpty()) {
            return;
        }
        List expected = test.getExpectedLineNumbers();
        if (report.getViolations().size() != expected.size()) {
            throw new RuntimeException("Test setup error: number of expected line numbers " + expected.size() + " doesn't match number of violations " + report.getViolations().size() + " for test case '" + test.getDescription() + "'");
        }
        int index = 0;
        for (RuleViolation violation : report.getViolations()) {
            Integer actual = violation.getBeginLine();
            if (((Integer)expected.get(index)).intValue() != actual.intValue()) {
                this.printReport(test, report);
            }
            Assertions.assertEquals((Integer)((Integer)expected.get(index)), (Integer)actual, (String)('\"' + test.getDescription() + "\" violation on wrong line number: violation number " + (index + 1) + "."));
            ++index;
        }
    }

    private void printReport(RuleTestDescriptor test, Report report) {
        System.out.println("--------------------------------------------------------------");
        System.out.println("Test Failure: " + test.getDescription());
        System.out.println(" -> Expected " + test.getExpectedProblems() + " problem(s), " + report.getViolations().size() + " problem(s) found.");
        System.out.println(" -> Expected messages: " + test.getExpectedMessages());
        System.out.println(" -> Expected line numbers: " + test.getExpectedLineNumbers());
        System.out.println();
        TextRenderer renderer = new TextRenderer();
        renderer.setWriter((Writer)new StringWriter());
        try {
            renderer.start();
            renderer.renderFileReport(report);
            renderer.end();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println(renderer.getWriter().toString());
        System.out.println("--------------------------------------------------------------");
    }

    private Report processUsingStringReader(RuleTestDescriptor test, Rule rule) {
        return this.runTestFromString(test.getCode(), rule, test.getLanguageVersion());
    }

    Report runTestFromString(String code, Rule rule, LanguageVersion languageVersion) {
        PMDConfiguration configuration = new PMDConfiguration();
        configuration.setIgnoreIncrementalAnalysis(true);
        configuration.setDefaultLanguageVersion(languageVersion);
        configuration.setThreads(1);
        configuration.prependAuxClasspath(".");
        try (PmdAnalysis pmd = PmdAnalysis.create((PMDConfiguration)configuration);){
            pmd.files().addFile(TextFile.forCharSeq((CharSequence)code, (String)"testFile", (LanguageVersion)languageVersion));
            pmd.addRuleSet(RuleSet.forSingleRule((Rule)rule));
            pmd.addListener(GlobalAnalysisListener.exceptionThrower());
            Report report = pmd.performAnalysisAndCollectReport();
            return report;
        }
    }

    private String getCleanRuleName(Rule rule) {
        String fullClassName = rule.getClass().getName();
        if (fullClassName.equals(rule.getName())) {
            String packageName = rule.getClass().getPackage().getName();
            return fullClassName.substring(packageName.length() + 1);
        }
        return rule.getName();
    }

    RuleTestCollection parseTestCollection(Rule rule) {
        String testsFileName = this.getCleanRuleName(rule);
        return this.parseTestCollection(rule, testsFileName);
    }

    private RuleTestCollection parseTestCollection(Rule rule, String testsFileName) {
        return this.parseTestXml(rule, testsFileName, "xml/");
    }

    private RuleTestCollection parseTestXml(Rule rule, String testsFileName, String baseDirectory) {
        RuleTestCollection ruleTestCollection;
        block9: {
            String testXmlFileName = baseDirectory + testsFileName + ".xml";
            String absoluteUriToTestXmlFile = new File(".").getAbsoluteFile().toURI() + "/src/test/resources/" + this.getClass().getPackage().getName().replaceAll("\\.", "/") + "/" + testXmlFileName;
            InputStream inputStream = this.getClass().getResourceAsStream(testXmlFileName);
            try {
                if (inputStream == null) {
                    throw new RuntimeException("Couldn't find " + testXmlFileName);
                }
                InputSource source = new InputSource();
                source.setByteStream(inputStream);
                source.setSystemId(testXmlFileName);
                TestSchemaParser parser = new TestSchemaParser();
                RuleTestCollection ruleTestCollection2 = parser.parse(rule, source);
                ruleTestCollection2.setAbsoluteUriToTestXmlFile(absoluteUriToTestXmlFile);
                ruleTestCollection = ruleTestCollection2;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't parse " + testXmlFileName + ", due to: " + e, e);
                }
            }
            inputStream.close();
        }
        return ruleTestCollection;
    }

    public void runTests(Rule rule) {
        this.runTests(this.parseTestCollection(rule));
    }

    public void runTests(Rule rule, String testsFileName) {
        this.runTests(this.parseTestCollection(rule, testsFileName));
    }

    private void runTests(RuleTestCollection tests) {
        for (RuleTestDescriptor test : tests.getTests()) {
            this.runTest(test);
        }
    }

    @TestFactory
    Collection<DynamicTest> ruleTests() {
        this.setUp();
        ArrayList<Rule> rules = new ArrayList<Rule>(this.getRules());
        rules.sort(Comparator.comparing(Rule::getName));
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        for (Rule r : rules) {
            RuleTestCollection ruleTests = this.parseTestCollection(r);
            RuleTestDescriptor focused = ruleTests.getFocusedTestOrNull();
            for (RuleTestDescriptor t : ruleTests.getTests()) {
                if (focused != null && !focused.equals(t)) {
                    t.setDisabled(true);
                }
                tests.add(this.toDynamicTest(ruleTests, t));
            }
        }
        return tests;
    }

    private DynamicTest toDynamicTest(RuleTestCollection collection, RuleTestDescriptor testDescriptor) {
        URI testSourceUri = URI.create(collection.getAbsoluteUriToTestXmlFile() + "?line=" + testDescriptor.getLineNumber());
        if (testDescriptor.isDisabled()) {
            return DynamicTest.dynamicTest((String)("[IGNORED] " + testDescriptor.getDescription()), (URI)testSourceUri, () -> {});
        }
        return DynamicTest.dynamicTest((String)testDescriptor.getDescription(), (URI)testSourceUri, () -> this.runTest(testDescriptor));
    }
}

