/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.testframework;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.RulesetsFactoryUtils;
import net.sourceforge.pmd.SourceCodeProcessor;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.test.schema.RuleTestCollection;
import net.sourceforge.pmd.test.schema.RuleTestDescriptor;
import net.sourceforge.pmd.test.schema.TestSchemaParser;
import net.sourceforge.pmd.testframework.TestDescriptor;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.xml.sax.InputSource;

public abstract class RuleTst {
    protected void setUp() {
    }

    protected List<Rule> getRules() {
        return Collections.emptyList();
    }

    public Rule findRule(String ruleSet, String ruleName) {
        try {
            Rule rule = RulesetsFactoryUtils.defaultFactory().createRuleSets(ruleSet).getRuleByName(ruleName);
            if (rule == null) {
                Assert.fail((String)("Rule " + ruleName + " not found in ruleset " + ruleSet));
            } else {
                rule.setRuleSetName(ruleSet);
            }
            return rule;
        }
        catch (RuleSetNotFoundException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't find ruleset " + ruleSet));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @InternalApi
    public void runTest(TestDescriptor test) {
        Rule rule = test.getRule();
        rule = this.reinitializeRule(rule);
        Map oldProperties = rule.getPropertiesByPropertyDescriptor();
        try {
            int res;
            Report report;
            try {
                String dysfunctionReason;
                if (test.getProperties() != null) {
                    for (Map.Entry<Object, Object> entry : test.getProperties().entrySet()) {
                        String propertyName = (String)entry.getKey();
                        PropertyDescriptor propertyDescriptor = rule.getPropertyDescriptor(propertyName);
                        if (propertyDescriptor == null) {
                            throw new IllegalArgumentException("No such property '" + propertyName + "' on Rule " + rule.getName());
                        }
                        Object value = propertyDescriptor.valueFrom((String)entry.getValue());
                        rule.setProperty(propertyDescriptor, value);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(dysfunctionReason = rule.dysfunctionReason()))) {
                    throw new RuntimeException("Rule is not configured correctly: " + dysfunctionReason);
                }
                report = this.processUsingStringReader(test, rule);
                res = report.size();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException('\"' + test.getDescription() + "\" failed", e);
            }
            if (test.getNumberOfProblemsExpected() != res) {
                this.printReport(test, report);
            }
            Assert.assertEquals((String)('\"' + test.getDescription() + "\" resulted in wrong number of failures,"), (long)test.getNumberOfProblemsExpected(), (long)res);
            this.assertMessages(report, test);
            this.assertLineNumbers(report, test);
        }
        finally {
            for (Map.Entry entry : oldProperties.entrySet()) {
                rule.setProperty((PropertyDescriptor)entry.getKey(), entry.getValue());
            }
        }
    }

    protected Rule reinitializeRule(Rule rule) {
        return this.findRule(rule.getRuleSetName(), rule.getName());
    }

    private void assertMessages(Report report, TestDescriptor test) {
        if (report == null || test.getExpectedMessages().isEmpty()) {
            return;
        }
        List<String> expectedMessages = test.getExpectedMessages();
        if (report.size() != expectedMessages.size()) {
            throw new RuntimeException("Test setup error: number of expected messages doesn't match number of violations for test case '" + test.getDescription() + "'");
        }
        Iterator it = report.iterator();
        int index = 0;
        while (it.hasNext()) {
            RuleViolation violation = (RuleViolation)it.next();
            String actual = violation.getDescription();
            if (!expectedMessages.get(index).equals(actual)) {
                this.printReport(test, report);
            }
            Assert.assertEquals((String)('\"' + test.getDescription() + "\" produced wrong message on violation number " + (index + 1) + "."), (Object)expectedMessages.get(index), (Object)actual);
            ++index;
        }
    }

    private void assertLineNumbers(Report report, TestDescriptor test) {
        if (report == null || test.getExpectedLineNumbers().isEmpty()) {
            return;
        }
        List<Integer> expected = test.getExpectedLineNumbers();
        if (report.size() != expected.size()) {
            throw new RuntimeException("Test setup error: number of expected line numbers " + expected.size() + " doesn't match number of violations " + report.size() + " for test case '" + test.getDescription() + "'");
        }
        Iterator it = report.iterator();
        int index = 0;
        while (it.hasNext()) {
            RuleViolation violation = (RuleViolation)it.next();
            Integer actual = violation.getBeginLine();
            if (expected.get(index).intValue() != actual.intValue()) {
                this.printReport(test, report);
            }
            Assert.assertEquals((String)('\"' + test.getDescription() + "\" violation on wrong line number: violation number " + (index + 1) + "."), (Object)expected.get(index), (Object)actual);
            ++index;
        }
    }

    private void printReport(TestDescriptor test, Report report) {
        System.out.println("--------------------------------------------------------------");
        System.out.println("Test Failure: " + test.getDescription());
        System.out.println(" -> Expected " + test.getNumberOfProblemsExpected() + " problem(s), " + report.size() + " problem(s) found.");
        System.out.println(" -> Expected messages: " + test.getExpectedMessages());
        System.out.println(" -> Expected line numbers: " + test.getExpectedLineNumbers());
        System.out.println("Test Method Name: " + test.getTestMethodName());
        System.out.println("    @org.junit.Test public void " + test.getTestMethodName() + "() {}");
        System.out.println();
        TextRenderer renderer = new TextRenderer();
        renderer.setWriter((Writer)new StringWriter());
        try {
            renderer.start();
            renderer.renderFileReport(report);
            renderer.end();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println(renderer.getWriter().toString());
        System.out.println("--------------------------------------------------------------");
    }

    private Report processUsingStringReader(TestDescriptor test, Rule rule) throws PMDException {
        Report report = new Report();
        this.runTestFromString(test, rule, report);
        return report;
    }

    @Deprecated
    @InternalApi
    public void runTestFromString(String code, Rule rule, Report report, LanguageVersion languageVersion) {
        this.runTestFromString(code, rule, report, languageVersion, true);
    }

    @Deprecated
    @InternalApi
    public void runTestFromString(String code, Rule rule, Report report, LanguageVersion languageVersion, boolean isUseAuxClasspath) {
        try {
            PMDConfiguration configuration = new PMDConfiguration();
            configuration.setDefaultLanguageVersion(languageVersion);
            configuration.setIgnoreIncrementalAnalysis(true);
            configuration.prependAuxClasspath(".");
            RuleContext ctx = new RuleContext();
            ctx.setReport(report);
            ctx.setSourceCodeFile(new File("n/a"));
            ctx.setLanguageVersion(languageVersion);
            ctx.setIgnoreExceptions(false);
            RuleSet rules = RuleSet.forSingleRule((Rule)rule);
            SourceCodeProcessor sourceCodeProcessor = new SourceCodeProcessor(configuration);
            sourceCodeProcessor.processSourceCode((Reader)new StringReader(code), new RuleSets(rules), ctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    @InternalApi
    public void runTestFromString(TestDescriptor test, Rule rule, Report report) {
        this.runTestFromString(test.getCode(), rule, report, test.getLanguageVersion(), test.isUseAuxClasspath());
    }

    @Deprecated
    @InternalApi
    protected String getCleanRuleName(Rule rule) {
        String fullClassName = rule.getClass().getName();
        if (fullClassName.equals(rule.getName())) {
            String packageName = rule.getClass().getPackage().getName();
            return fullClassName.substring(packageName.length() + 1);
        }
        return rule.getName();
    }

    @Deprecated
    @InternalApi
    public TestDescriptor[] extractTestsFromXml(Rule rule) {
        String testsFileName = this.getCleanRuleName(rule);
        return this.extractTestsFromXml(rule, testsFileName);
    }

    RuleTestCollection parseTestCollection(Rule rule) {
        String testsFileName = this.getCleanRuleName(rule);
        return this.parseTestXml(rule, testsFileName, "xml/");
    }

    @Deprecated
    @InternalApi
    public TestDescriptor[] extractTestsFromXml(Rule rule, String testsFileName) {
        return this.extractTestsFromXml(rule, testsFileName, "xml/");
    }

    @Deprecated
    @InternalApi
    public TestDescriptor[] extractTestsFromXml(Rule rule, String testsFileName, String baseDirectory) {
        RuleTestCollection collection = this.parseTestXml(rule, testsFileName, baseDirectory);
        return this.toLegacyArray(collection);
    }

    private TestDescriptor[] toLegacyArray(RuleTestCollection collection) {
        TestDescriptor[] result = new TestDescriptor[collection.getTests().size()];
        for (int i = 0; i < collection.getTests().size(); ++i) {
            result[i] = new TestDescriptor((RuleTestDescriptor)collection.getTests().get(i));
        }
        return result;
    }

    private RuleTestCollection parseTestXml(Rule rule, String testsFileName, String baseDirectory) {
        RuleTestCollection ruleTestCollection;
        block9: {
            String testXmlFileName = baseDirectory + testsFileName + ".xml";
            InputStream inputStream = this.getClass().getResourceAsStream(testXmlFileName);
            try {
                if (inputStream == null) {
                    throw new RuntimeException("Couldn't find " + testXmlFileName);
                }
                InputSource source = new InputSource();
                source.setByteStream(inputStream);
                source.setSystemId(testXmlFileName);
                TestSchemaParser parser = new TestSchemaParser();
                ruleTestCollection = parser.parse(rule, source);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't parse " + testXmlFileName + ", due to: " + e, e);
                }
            }
            inputStream.close();
        }
        return ruleTestCollection;
    }

    public void runTests(Rule rule) {
        this.runTests(this.extractTestsFromXml(rule));
    }

    public void runTests(Rule rule, String testsFileName) {
        this.runTests(this.extractTestsFromXml(rule, testsFileName));
    }

    @Deprecated
    @InternalApi
    public void runTests(TestDescriptor[] tests) {
        for (int i = 0; i < tests.length; ++i) {
            this.runTest(tests[i]);
        }
    }
}

