/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cli;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.regex.Pattern;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.internal.util.AssertionUtil;
import org.apache.tools.ant.util.TeeOutputStream;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.contrib.java.lang.system.SystemErrRule;
import org.junit.contrib.java.lang.system.SystemOutRule;

@Deprecated
public abstract class BaseCLITest {
    protected static final String TEST_OUPUT_DIRECTORY = "target/cli-tests/";
    protected static final String SOURCE_FOLDER = "src/test/resources/net/sourceforge/pmd/cli";
    @Rule
    public SystemErrRule systemErrRule = new SystemErrRule().muteForSuccessfulTests();
    @Rule
    public SystemOutRule systemOutRule = new SystemOutRule().muteForSuccessfulTests();

    @BeforeClass
    public static void setUp() throws Exception {
        System.setProperty("net.sourceforge.pmd.cli.noExit", "true");
        File testOuputDir = new File(TEST_OUPUT_DIRECTORY);
        if (!testOuputDir.exists()) {
            Assert.assertTrue((String)("failed to create output directory for test:" + testOuputDir.getAbsolutePath()), (boolean)testOuputDir.mkdirs());
        }
    }

    protected void createTestOutputFile(String filename) {
        try {
            PrintStream out = new PrintStream(Files.newOutputStream(new File(filename).toPath(), new OpenOption[0]));
            System.setOut(out);
            System.setErr(out);
        }
        catch (IOException e) {
            Assert.fail((String)("Can't create file " + filename + " for test."));
        }
    }

    @Deprecated
    protected String runTest(String[] args, String testname) {
        return this.runTest(args, testname, 0);
    }

    @Deprecated
    protected String runTest(String[] args, String testname, int expectedExitCode) {
        String filename = TEST_OUPUT_DIRECTORY + testname + ".txt";
        long start = System.currentTimeMillis();
        this.createTestOutputFile(filename);
        System.out.println("Start running test " + testname);
        PMD.StatusCode statusCode = PMD.runPmd((String[])args);
        Assert.assertEquals((long)expectedExitCode, (long)statusCode.toInt());
        System.out.println("Test finished successfully after " + (System.currentTimeMillis() - start) + "ms.");
        return filename;
    }

    protected String runTest(String ... args) {
        return this.runTest(PMD.StatusCode.OK, args);
    }

    @Deprecated
    protected String runTest(int expectedExitCode, String ... args) {
        switch (expectedExitCode) {
            case 0: {
                return this.runTest(PMD.StatusCode.OK, args);
            }
            case 1: {
                return this.runTest(PMD.StatusCode.ERROR, args);
            }
            case 4: {
                return this.runTest(PMD.StatusCode.VIOLATIONS_FOUND, args);
            }
        }
        throw AssertionUtil.shouldNotReachHere((String)("unknown status code " + expectedExitCode));
    }

    protected String runTest(PMD.StatusCode expectedExitCode, String ... args) {
        ByteArrayOutputStream console = new ByteArrayOutputStream();
        PrintStream out = new PrintStream((OutputStream)new TeeOutputStream((OutputStream)console, (OutputStream)System.out));
        PrintStream err = new PrintStream((OutputStream)new TeeOutputStream((OutputStream)console, (OutputStream)System.err));
        System.setOut(out);
        System.setErr(err);
        PMD.StatusCode statusCode = PMD.runPmd((String[])args);
        Assert.assertEquals((Object)expectedExitCode, (Object)statusCode);
        return console.toString();
    }

    @Deprecated
    protected void runPMDWith(String[] args) {
        PMD.main((String[])args);
    }

    @Deprecated
    protected void checkStatusCode(int expectedExitCode) {
        int statusCode = this.getStatusCode();
        if (statusCode != expectedExitCode) {
            Assert.fail((String)("PMD failed with status code:" + statusCode));
        }
    }

    @Deprecated
    protected int getStatusCode() {
        return Integer.parseInt(System.getProperty("net.sourceforge.pmd.cli.status"));
    }

    public static Matcher<String> containsPattern(final String regex) {
        return new BaseMatcher<String>(){
            final Pattern pattern;
            {
                this.pattern = Pattern.compile(regex);
            }

            public void describeTo(Description description) {
                description.appendText("a string containing the pattern '" + this.pattern + "'");
            }

            public boolean matches(Object o) {
                return o instanceof String && this.pattern.matcher((String)o).find();
            }
        };
    }
}

