/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.io.File;
import java.io.IOException;
import net.sourceforge.pmd.annotation.InternalApi;
import org.apache.tools.ant.BuildFileRule;
import org.apache.tools.ant.Project;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.contrib.java.lang.system.SystemErrRule;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractAntTestHelper {
    @Rule
    @Deprecated
    @InternalApi
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    @Deprecated
    @InternalApi
    public final BuildFileRule buildRule = new BuildFileRule();
    @Rule
    @Deprecated
    @InternalApi
    public final SystemErrRule systemErrRule = new SystemErrRule().muteForSuccessfulTests();
    protected String pathToTestScript = new File("target/clover/test-classes").exists() ? "target/clover/test-classes/net/sourceforge/" + this.mvnWorkaround : "target/test-classes/net/sourceforge/" + this.mvnWorkaround;
    protected String antTestScriptFilename;
    @Deprecated
    @InternalApi
    public String mvnWorkaround = "pmd/ant/xml";

    @Before
    public void setUp() throws IOException {
        this.validatePostConstruct();
        this.buildRule.configureProject(this.pathToTestScript + File.separator + this.antTestScriptFilename);
        File newFile = this.tempFolder.newFile();
        newFile.delete();
        this.buildRule.getProject().setProperty("tmpfile", newFile.getAbsolutePath());
        Project project = this.buildRule.getProject();
        if (!project.getBaseDir().toString().endsWith(this.mvnWorkaround)) {
            project.setBasedir(project.getBaseDir().toString() + File.separator + this.pathToTestScript);
        }
    }

    public File currentTempFile() {
        String tmpname = this.buildRule.getProject().getProperty("tmpfile");
        return tmpname == null ? null : new File(tmpname);
    }

    private void validatePostConstruct() {
        if (this.pathToTestScript == null || "".equals(this.pathToTestScript) || this.antTestScriptFilename == null || "".equals(this.antTestScriptFilename) || this.mvnWorkaround == null || "".equals(this.mvnWorkaround)) {
            throw new IllegalStateException("Unit tests for Ant script badly initialized");
        }
    }

    public void executeTarget(String target) {
        this.buildRule.executeTarget(target);
        System.err.println(this.buildRule.getLog());
    }

    public void assertOutputContaining(String text) {
        MatcherAssert.assertThat((Object)this.buildRule.getOutput(), (Matcher)Matchers.containsString((String)text));
    }

    public void assertContains(String text, String toFind) {
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.containsString((String)toFind));
    }

    public void assertDoesntContain(String text, String toFind) {
        MatcherAssert.assertThat((Object)text, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)toFind)));
    }
}

