/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.testframework;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.lang.LanguageVersion;
import org.junit.Ignore;

@Ignore(value="this is not a unit test")
public class TestDescriptor {
    private Rule rule;
    private Properties properties;
    private String description;
    private int numberOfProblemsExpected;
    private List<String> expectedMessages = new ArrayList<String>();
    private List<Integer> expectedLineNumbers = new ArrayList<Integer>();
    private String code;
    private LanguageVersion languageVersion;
    private boolean reinitializeRule = true;
    private boolean isRegressionTest = true;
    private boolean useAuxClasspath = true;
    private int numberInDocument = -1;

    public TestDescriptor() {
    }

    public TestDescriptor(String code, String description, int numberOfProblemsExpected, Rule rule) {
        this(code, description, numberOfProblemsExpected, rule, rule.getLanguage().getDefaultVersion());
    }

    public TestDescriptor(String code, String description, int numberOfProblemsExpected, Rule rule, LanguageVersion languageVersion) {
        this.rule = rule;
        this.code = code;
        this.description = description;
        this.numberOfProblemsExpected = numberOfProblemsExpected;
        this.languageVersion = languageVersion;
    }

    public int getNumberInDocument() {
        return this.numberInDocument;
    }

    public void setNumberInDocument(int numberInDocument) {
        this.numberInDocument = numberInDocument;
    }

    public void setExpectedMessages(List<String> messages) {
        this.expectedMessages.clear();
        this.expectedMessages.addAll(messages);
    }

    public List<String> getExpectedMessages() {
        return this.expectedMessages;
    }

    public void setExpectedLineNumbers(List<Integer> expectedLineNumbers) {
        this.expectedLineNumbers.clear();
        this.expectedLineNumbers.addAll(expectedLineNumbers);
    }

    public List<Integer> getExpectedLineNumbers() {
        return this.expectedLineNumbers;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getCode() {
        return this.code;
    }

    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public int getNumberOfProblemsExpected() {
        return this.numberOfProblemsExpected;
    }

    public Rule getRule() {
        return this.rule;
    }

    public boolean getReinitializeRule() {
        return this.reinitializeRule;
    }

    public void setReinitializeRule(boolean reinitializeRule) {
        this.reinitializeRule = reinitializeRule;
    }

    public static boolean inRegressionTestMode() {
        boolean inRegressionMode = true;
        try {
            String property = System.getProperty("pmd.regress");
            if (property != null) {
                inRegressionMode = Boolean.parseBoolean(property);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid system property 'pmd.regress'", e);
        }
        return inRegressionMode;
    }

    public boolean isRegressionTest() {
        return this.isRegressionTest;
    }

    public void setRegressionTest(boolean isRegressionTest) {
        this.isRegressionTest = isRegressionTest;
    }

    public void setUseAuxClasspath(boolean useAuxClasspath) {
        this.useAuxClasspath = useAuxClasspath;
    }

    public boolean isUseAuxClasspath() {
        return this.useAuxClasspath;
    }

    public String getTestMethodName() {
        return this.getRule().getName() + "_" + this.getNumberInDocument() + "_" + this.getDescription().replaceAll("\n|\r", "_").replaceAll("[^\\w\\d_$]", "_").replaceAll("\\s+", "_");
    }
}

