/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RulesetsFactoryUtils;
import net.sourceforge.pmd.ant.SourceLanguage;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.Parser;
import net.sourceforge.pmd.lang.ParserOptions;
import net.sourceforge.pmd.util.ResourceLoader;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AbstractLanguageVersionTest {
    private String name;
    private String version;
    private String simpleTerseName;
    private String terseName;
    private LanguageVersion expected;

    public AbstractLanguageVersionTest(String name, String terseName, String version, LanguageVersion expected) {
        this.name = name;
        this.version = version;
        this.simpleTerseName = terseName;
        this.terseName = terseName;
        if (version != null && !version.isEmpty()) {
            this.terseName = this.terseName + " " + version;
        }
        this.expected = expected;
    }

    @Test
    public void testGetLanguageVersionForTerseName() {
        Assert.assertEquals((Object)this.expected, (Object)LanguageRegistry.findLanguageVersionByTerseName((String)this.terseName));
    }

    @Test
    public void testFindVersionsForLanguageNameAndVersion() {
        SourceLanguage sourceLanguage = new SourceLanguage();
        sourceLanguage.setName(this.name);
        sourceLanguage.setVersion(this.version);
        Language language = LanguageRegistry.getLanguage((String)sourceLanguage.getName());
        LanguageVersion languageVersion = null;
        if (language != null) {
            languageVersion = language.getVersion(sourceLanguage.getVersion());
        }
        Assert.assertEquals((Object)this.expected, languageVersion);
    }

    private boolean supportsRules() {
        if (this.expected == null || this.expected.getLanguage().getRuleChainVisitorClass() == null || this.expected.getLanguageVersionHandler() == null) {
            return false;
        }
        LanguageVersionHandler languageVersionHandler = this.expected.getLanguageVersionHandler();
        ParserOptions defaultParserOptions = languageVersionHandler.getDefaultParserOptions();
        Parser parser = languageVersionHandler.getParser(defaultParserOptions);
        return parser.canParse();
    }

    @Test
    public void testRegisteredRulesets() throws Exception {
        if (!this.supportsRules()) {
            return;
        }
        ResourceLoader rl = new ResourceLoader();
        Properties props = new Properties();
        String rulesetsProperties = "category/" + this.simpleTerseName + "/categories.properties";
        try (InputStream inputStream = rl.loadClassPathResourceAsStreamOrThrow(rulesetsProperties);){
            props.load(inputStream);
        }
        this.assertRulesetsAndCategoriesProperties(rl, props);
    }

    @Test
    public void testOldRegisteredRulesets() throws Exception {
        if (this.expected == null || this.expected.getLanguage().getRuleChainVisitorClass() == null) {
            return;
        }
        ResourceLoader rl = new ResourceLoader();
        Properties props = new Properties();
        String rulesetsProperties = "rulesets/" + this.simpleTerseName + "/rulesets.properties";
        InputStream inputStream = rl.loadClassPathResourceAsStream(rulesetsProperties);
        if (inputStream != null) {
            try (InputStream in = inputStream;){
                props.load(in);
            }
            this.assertRulesetsAndCategoriesProperties(rl, props);
        }
    }

    @Test
    public void testVersionsAreDistinct() {
        if (this.expected == null) {
            return;
        }
        Language lang = this.expected.getLanguage();
        int count = 0;
        for (LanguageVersion lv : lang.getVersions()) {
            if (!lv.equals(this.expected)) continue;
            ++count;
        }
        Assert.assertEquals((String)("Expected exactly one occurrence of " + this.expected + " in the language versions of its language"), (long)1L, (long)count);
    }

    private void assertRulesetsAndCategoriesProperties(ResourceLoader rl, Properties props) throws IOException, RuleSetNotFoundException {
        String[] rulesets;
        String rulesetFilenames = props.getProperty("rulesets.filenames");
        Assert.assertNotNull((Object)rulesetFilenames);
        RuleSetFactory factory = RulesetsFactoryUtils.defaultFactory();
        if (rulesetFilenames.trim().isEmpty()) {
            return;
        }
        for (String r : rulesets = rulesetFilenames.split(",")) {
            try (InputStream stream = rl.loadClassPathResourceAsStream(r);){
                Assert.assertNotNull((Object)stream);
            }
            RuleSet ruleset = factory.createRuleSet(r);
            Assert.assertNotNull((Object)ruleset);
        }
    }
}

