/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.ant;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildFileRule;
import org.apache.tools.ant.Project;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractAntTestHelper {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public final BuildFileRule buildRule = new BuildFileRule();
    protected String pathToTestScript = new File("target/clover/test-classes").exists() ? "target/clover/test-classes/net/sourceforge/" + this.mvnWorkaround : "target/test-classes/net/sourceforge/" + this.mvnWorkaround;
    protected String antTestScriptFilename;
    public String mvnWorkaround = "pmd/ant/xml";

    @Before
    public void setUp() throws IOException {
        this.validatePostConstruct();
        this.buildRule.configureProject(this.pathToTestScript + File.separator + this.antTestScriptFilename);
        File newFile = this.tempFolder.newFile();
        newFile.delete();
        this.buildRule.getProject().setProperty("tmpfile", newFile.getAbsolutePath());
        Project project = this.buildRule.getProject();
        if (!project.getBaseDir().toString().endsWith(this.mvnWorkaround)) {
            project.setBasedir(project.getBaseDir().toString() + File.separator + this.pathToTestScript);
        }
    }

    public File currentTempFile() {
        String tmpname = this.buildRule.getProject().getProperty("tmpfile");
        return tmpname == null ? null : new File(tmpname);
    }

    private void validatePostConstruct() {
        if (this.pathToTestScript == null || "".equals(this.pathToTestScript) || this.antTestScriptFilename == null || "".equals(this.antTestScriptFilename) || this.mvnWorkaround == null || "".equals(this.mvnWorkaround)) {
            throw new IllegalStateException("Unit tests for Ant script badly initialized");
        }
    }

    public void executeTarget(String target) {
        this.buildRule.executeTarget(target);
    }

    public void assertOutputContaining(String text) {
        this.assertContains(this.buildRule.getOutput(), text);
    }

    public void assertContains(String text, String toFind) {
        Assert.assertTrue((String)("Expected to find \"" + toFind + "\", but it's missing"), (boolean)text.contains(toFind));
    }

    public void assertDoesntContain(String text, String toFind) {
        Assert.assertTrue((String)("Expected no occurrence of \"" + toFind + "\", but found at least one"), (!text.contains(toFind) ? 1 : 0) != 0);
    }
}

