/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.io.InputStream;
import java.util.Properties;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.ant.SourceLanguage;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.util.ResourceLoader;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AbstractLanguageVersionTest {
    private String name;
    private String version;
    private String simpleTerseName;
    private String terseName;
    private LanguageVersion expected;

    public AbstractLanguageVersionTest(String name, String terseName, String version, LanguageVersion expected) {
        this.name = name;
        this.version = version;
        this.simpleTerseName = terseName;
        this.terseName = terseName;
        if (version != null && !version.isEmpty()) {
            this.terseName = this.terseName + " " + version;
        }
        this.expected = expected;
    }

    @Test
    public void testGetLanguageVersionForTerseName() {
        Assert.assertEquals((Object)this.expected, (Object)LanguageRegistry.findLanguageVersionByTerseName((String)this.terseName));
    }

    @Test
    public void testFindVersionsForLanguageNameAndVersion() {
        SourceLanguage sourceLanguage = new SourceLanguage();
        sourceLanguage.setName(this.name);
        sourceLanguage.setVersion(this.version);
        Language language = LanguageRegistry.getLanguage((String)sourceLanguage.getName());
        LanguageVersion languageVersion = null;
        if (language != null) {
            languageVersion = language.getVersion(sourceLanguage.getVersion());
        }
        Assert.assertEquals((Object)this.expected, languageVersion);
    }

    @Test
    public void testRegisteredRulesets() throws Exception {
        String[] rulesets;
        if (this.expected == null || this.expected.getLanguage().getRuleChainVisitorClass() == null) {
            return;
        }
        Properties props = new Properties();
        String rulesetsProperties = "rulesets/" + this.simpleTerseName + "/rulesets.properties";
        try (InputStream inputStream = ResourceLoader.loadResourceAsStream((String)rulesetsProperties);){
            props.load(inputStream);
        }
        String rulesetFilenames = props.getProperty("rulesets.filenames");
        Assert.assertNotNull((Object)rulesetFilenames);
        RuleSetFactory factory = new RuleSetFactory();
        if (rulesetFilenames.trim().isEmpty()) {
            return;
        }
        for (String r : rulesets = rulesetFilenames.split(",")) {
            InputStream stream = ResourceLoader.loadResourceAsStream((String)r);
            Assert.assertNotNull((Object)stream);
            stream.close();
            RuleSet ruleset = factory.createRuleSet(r);
            Assert.assertNotNull((Object)ruleset);
        }
    }
}

