/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.testframework;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.PMDException;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import net.sourceforge.pmd.RuleSetNotFoundException;
import net.sourceforge.pmd.RuleSets;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.testframework.TestDescriptor;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class RuleTst {
    public Rule findRule(String ruleSet, String ruleName) {
        try {
            Rule rule = new RuleSetFactory().createRuleSets(ruleSet).getRuleByName(ruleName);
            if (rule == null) {
                Assert.fail((String)("Rule " + ruleName + " not found in ruleset " + ruleSet));
            }
            rule.setRuleSetName(ruleSet);
            return rule;
        }
        catch (RuleSetNotFoundException e) {
            e.printStackTrace();
            Assert.fail((String)("Couldn't find ruleset " + ruleSet));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest(TestDescriptor test) {
        Rule rule = test.getRule();
        if (test.getReinitializeRule()) {
            rule = this.findRule(rule.getRuleSetName(), rule.getName());
        }
        Map oldProperties = rule.getPropertiesByPropertyDescriptor();
        try {
            int res;
            Report report;
            try {
                if (test.getProperties() != null) {
                    for (Map.Entry<Object, Object> entry : test.getProperties().entrySet()) {
                        String propertyName = (String)entry.getKey();
                        PropertyDescriptor propertyDescriptor = rule.getPropertyDescriptor(propertyName);
                        if (propertyDescriptor == null) {
                            throw new IllegalArgumentException("No such property '" + propertyName + "' on Rule " + rule.getName());
                        }
                        Object value = propertyDescriptor.valueFrom((String)entry.getValue());
                        rule.setProperty(propertyDescriptor, value);
                    }
                }
                report = this.processUsingStringReader(test.getCode(), rule, test.getLanguageVersion());
                res = report.size();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new RuntimeException('\"' + test.getDescription() + "\" failed", t);
            }
            if (test.getNumberOfProblemsExpected() != res) {
                this.printReport(test, report);
            }
            Assert.assertEquals((String)('\"' + test.getDescription() + "\" resulted in wrong number of failures,"), (long)test.getNumberOfProblemsExpected(), (long)res);
            this.assertMessages(report, test);
            this.assertLineNumbers(report, test);
        }
        finally {
            for (Map.Entry entry : oldProperties.entrySet()) {
                rule.setProperty((PropertyDescriptor)entry.getKey(), entry.getValue());
            }
        }
    }

    private void assertMessages(Report report, TestDescriptor test) {
        if (report == null || test.getExpectedMessages().isEmpty()) {
            return;
        }
        List<String> expectedMessages = test.getExpectedMessages();
        if (report.size() != expectedMessages.size()) {
            throw new RuntimeException("Test setup error: number of expected messages doesn't match number of violations for test case '" + test.getDescription() + "'");
        }
        Iterator it = report.iterator();
        int index = 0;
        while (it.hasNext()) {
            RuleViolation violation = (RuleViolation)it.next();
            String actual = violation.getDescription();
            if (!expectedMessages.get(index).equals(actual)) {
                this.printReport(test, report);
            }
            Assert.assertEquals((String)('\"' + test.getDescription() + "\" produced wrong message on violation number " + (index + 1) + "."), (Object)expectedMessages.get(index), (Object)actual);
            ++index;
        }
    }

    private void assertLineNumbers(Report report, TestDescriptor test) {
        if (report == null || test.getExpectedLineNumbers().isEmpty()) {
            return;
        }
        List<Integer> expected = test.getExpectedLineNumbers();
        if (report.getViolationTree().size() != expected.size()) {
            throw new RuntimeException("Test setup error: number of execpted line numbers doesn't match number of violations for test case '" + test.getDescription() + "'");
        }
        Iterator it = report.getViolationTree().iterator();
        int index = 0;
        while (it.hasNext()) {
            RuleViolation violation = (RuleViolation)it.next();
            Integer actual = violation.getBeginLine();
            if (expected.get(index).intValue() != actual.intValue()) {
                this.printReport(test, report);
            }
            Assert.assertEquals((String)('\"' + test.getDescription() + "\" violation on wrong line number: violation number " + (index + 1) + "."), (Object)expected.get(index), (Object)actual);
            ++index;
        }
    }

    private void printReport(TestDescriptor test, Report report) {
        System.out.println("--------------------------------------------------------------");
        System.out.println("Test Failure: " + test.getDescription());
        System.out.println(" -> Expected " + test.getNumberOfProblemsExpected() + " problem(s), " + report.size() + " problem(s) found.");
        System.out.println(" -> Expected messages: " + test.getExpectedMessages());
        System.out.println(" -> Expected line numbers: " + test.getExpectedLineNumbers());
        System.out.println();
        TextRenderer renderer = new TextRenderer();
        renderer.setWriter((Writer)new StringWriter());
        try {
            renderer.start();
            renderer.renderFileReport(report);
            renderer.end();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println(renderer.getWriter().toString());
        System.out.println("--------------------------------------------------------------");
    }

    private Report processUsingStringReader(String code, Rule rule, LanguageVersion languageVersion) throws PMDException {
        Report report = new Report();
        this.runTestFromString(code, rule, report, languageVersion);
        return report;
    }

    public void runTestFromString(String code, Rule rule, Report report, LanguageVersion languageVersion) {
        try {
            PMD p = new PMD();
            p.getConfiguration().setDefaultLanguageVersion(languageVersion);
            p.getConfiguration().prependClasspath(".");
            RuleContext ctx = new RuleContext();
            ctx.setReport(report);
            ctx.setSourceCodeFilename("n/a");
            ctx.setLanguageVersion(languageVersion);
            ctx.setIgnoreExceptions(false);
            RuleSet rules = new RuleSet();
            rules.addRule(rule);
            p.getSourceCodeProcessor().processSourceCode((Reader)new StringReader(code), new RuleSets(rules), ctx);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getCleanRuleName(Rule rule) {
        String fullClassName = rule.getClass().getName();
        if (fullClassName.equals(rule.getName())) {
            String packageName = rule.getClass().getPackage().getName();
            return fullClassName.substring(packageName.length() + 1);
        }
        return rule.getName();
    }

    public TestDescriptor[] extractTestsFromXml(Rule rule) {
        String testsFileName = this.getCleanRuleName(rule);
        return this.extractTestsFromXml(rule, testsFileName);
    }

    public TestDescriptor[] extractTestsFromXml(Rule rule, String testsFileName) {
        return this.extractTestsFromXml(rule, testsFileName, "xml/");
    }

    public TestDescriptor[] extractTestsFromXml(Rule rule, String testsFileName, String baseDirectory) {
        Document doc;
        String testXmlFileName = baseDirectory + testsFileName + ".xml";
        InputStream inputStream = this.getClass().getResourceAsStream(testXmlFileName);
        if (inputStream == null) {
            throw new RuntimeException("Couldn't find " + testXmlFileName);
        }
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = builder.parse(inputStream);
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
            throw new RuntimeException("Couldn't parse " + testXmlFileName + ", due to: " + pce.getMessage());
        }
        catch (FactoryConfigurationError fce) {
            fce.printStackTrace();
            throw new RuntimeException("Couldn't parse " + testXmlFileName + ", due to: " + fce.getMessage());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Couldn't parse " + testXmlFileName + ", due to: " + ioe.getMessage());
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new RuntimeException("Couldn't parse " + testXmlFileName + ", due to: " + se.getMessage());
        }
        return this.parseTests(rule, doc);
    }

    private TestDescriptor[] parseTests(Rule rule, Document doc) {
        Element root = doc.getDocumentElement();
        NodeList testCodes = root.getElementsByTagName("test-code");
        TestDescriptor[] tests = new TestDescriptor[testCodes.getLength()];
        for (int i = 0; i < testCodes.getLength(); ++i) {
            String code;
            String reinitializeRuleValue;
            String reinitializeRuleValue2;
            Element testCode = (Element)testCodes.item(i);
            boolean reinitializeRule = true;
            Node reinitializeRuleAttribute = testCode.getAttributes().getNamedItem("reinitializeRule");
            if (reinitializeRuleAttribute != null && ("false".equalsIgnoreCase(reinitializeRuleValue2 = reinitializeRuleAttribute.getNodeValue()) || "0".equalsIgnoreCase(reinitializeRuleValue2))) {
                reinitializeRule = false;
            }
            boolean isRegressionTest = true;
            Node regressionTestAttribute = testCode.getAttributes().getNamedItem("regressionTest");
            if (regressionTestAttribute != null && "false".equalsIgnoreCase(reinitializeRuleValue = regressionTestAttribute.getNodeValue())) {
                isRegressionTest = false;
            }
            NodeList ruleProperties = testCode.getElementsByTagName("rule-property");
            Properties properties = new Properties();
            for (int j = 0; j < ruleProperties.getLength(); ++j) {
                Node ruleProperty = ruleProperties.item(j);
                String propertyName = ruleProperty.getAttributes().getNamedItem("name").getNodeValue();
                properties.setProperty(propertyName, RuleTst.parseTextNode(ruleProperty));
            }
            NodeList expectedMessagesNodes = testCode.getElementsByTagName("expected-messages");
            ArrayList<String> messages = new ArrayList<String>();
            if (expectedMessagesNodes != null && expectedMessagesNodes.getLength() > 0) {
                Element item = (Element)expectedMessagesNodes.item(0);
                NodeList messagesNodes = item.getElementsByTagName("message");
                for (int j = 0; j < messagesNodes.getLength(); ++j) {
                    messages.add(RuleTst.parseTextNode(messagesNodes.item(j)));
                }
            }
            NodeList expectedLineNumbersNodes = testCode.getElementsByTagName("expected-linenumbers");
            ArrayList<Integer> expectedLineNumbers = new ArrayList<Integer>();
            if (expectedLineNumbersNodes != null && expectedLineNumbersNodes.getLength() > 0) {
                Element item = (Element)expectedLineNumbersNodes.item(0);
                String numbers = item.getTextContent();
                for (String n : numbers.split(" *, *")) {
                    expectedLineNumbers.add(Integer.valueOf(n));
                }
            }
            if ((code = this.getNodeValue(testCode, "code", false)) == null) {
                NodeList coderefs = testCode.getElementsByTagName("code-ref");
                if (coderefs.getLength() == 0) {
                    throw new RuntimeException("Required tag is missing from the test-xml. Supply either a code or a code-ref tag");
                }
                Node coderef = coderefs.item(0);
                String referenceId = coderef.getAttributes().getNamedItem("id").getNodeValue();
                NodeList codeFragments = root.getElementsByTagName("code-fragment");
                for (int j = 0; j < codeFragments.getLength(); ++j) {
                    String fragmentId = codeFragments.item(j).getAttributes().getNamedItem("id").getNodeValue();
                    if (!referenceId.equals(fragmentId)) continue;
                    code = RuleTst.parseTextNode(codeFragments.item(j));
                }
                if (code == null) {
                    throw new RuntimeException("No matching code fragment found for coderef");
                }
            }
            String description = this.getNodeValue(testCode, "description", true);
            int expectedProblems = Integer.parseInt(this.getNodeValue(testCode, "expected-problems", true));
            String languageVersionString = this.getNodeValue(testCode, "source-type", false);
            if (languageVersionString == null) {
                tests[i] = new TestDescriptor(code, description, expectedProblems, rule);
            } else {
                LanguageVersion languageVersion = LanguageRegistry.findLanguageVersionByTerseName((String)languageVersionString);
                if (languageVersion != null) {
                    tests[i] = new TestDescriptor(code, description, expectedProblems, rule, languageVersion);
                } else {
                    throw new RuntimeException("Unknown LanguageVersion for test: " + languageVersionString);
                }
            }
            tests[i].setReinitializeRule(reinitializeRule);
            tests[i].setRegressionTest(isRegressionTest);
            tests[i].setExpectedMessages(messages);
            tests[i].setExpectedLineNumbers(expectedLineNumbers);
            tests[i].setProperties(properties);
            tests[i].setNumberInDocument(i);
        }
        return tests;
    }

    private String getNodeValue(Element parentElm, String nodeName, boolean required) {
        NodeList nodes = parentElm.getElementsByTagName(nodeName);
        if (nodes == null || nodes.getLength() == 0) {
            if (required) {
                throw new RuntimeException("Required tag is missing from the test-xml: " + nodeName);
            }
            return null;
        }
        Node node = nodes.item(0);
        return RuleTst.parseTextNode(node);
    }

    private static String parseTextNode(Node exampleNode) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < exampleNode.getChildNodes().getLength(); ++i) {
            Node node = exampleNode.getChildNodes().item(i);
            if (node.getNodeType() != 4 && node.getNodeType() != 3) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString().trim();
    }
}

