/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import net.sourceforge.pmd.ant.SourceLanguage;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AbstractLanguageVersionTest {
    private String name;
    private String version;
    private String terseName;
    private LanguageVersion expected;

    public AbstractLanguageVersionTest(String name, String terseName, String version, LanguageVersion expected) {
        this.name = name;
        this.version = version;
        this.terseName = terseName;
        if (version != null && !version.isEmpty()) {
            this.terseName = this.terseName + " " + version;
        }
        this.expected = expected;
    }

    @org.junit.Test
    public void testGetLanguageVersionForTerseName() {
        Assert.assertEquals((Object)this.expected, (Object)LanguageRegistry.findLanguageVersionByTerseName((String)this.terseName));
    }

    @org.junit.Test
    public void testFindVersionsForLanguageNameAndVersion() {
        SourceLanguage sourceLanguage = new SourceLanguage();
        sourceLanguage.setName(this.name);
        sourceLanguage.setVersion(this.version);
        Language language = LanguageRegistry.getLanguage((String)sourceLanguage.getName());
        LanguageVersion languageVersion = null;
        if (language != null) {
            languageVersion = language.getVersion(sourceLanguage.getVersion());
        }
        Assert.assertEquals((Object)this.expected, languageVersion);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(AbstractLanguageVersionTest.class);
    }
}

