/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.test.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.test.schema.RuleTestDescriptor;

public class RuleTestCollection {
    private final List<RuleTestDescriptor> tests = new ArrayList<RuleTestDescriptor>();
    private String absoluteUriToTestXmlFile;

    public void addTest(RuleTestDescriptor descriptor) {
        this.tests.add(Objects.requireNonNull(descriptor));
    }

    public List<RuleTestDescriptor> getTests() {
        return Collections.unmodifiableList(this.tests);
    }

    public RuleTestDescriptor getFocusedTestOrNull() {
        RuleTestDescriptor focused = null;
        for (RuleTestDescriptor test : this.tests) {
            if (!test.isFocused()) continue;
            focused = test;
        }
        return focused;
    }

    public String getAbsoluteUriToTestXmlFile() {
        return this.absoluteUriToTestXmlFile;
    }

    public void setAbsoluteUriToTestXmlFile(String absoluteUriToTestXmlFile) {
        this.absoluteUriToTestXmlFile = absoluteUriToTestXmlFile;
    }
}

