/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import net.sourceforge.pmd.lang.swift.antlr4.SwiftLexer;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;

public class SwiftTokenizer
implements Tokenizer {
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        StringBuilder buffer = sourceCode.getCodeBuffer();
        try {
            ANTLRInputStream ais = new ANTLRInputStream(buffer.toString());
            SwiftLexer lexer = new SwiftLexer((CharStream)ais);
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)new ErrorHandler());
            Token token = lexer.nextToken();
            while (token.getType() != -1) {
                if (token.getChannel() != 1) {
                    TokenEntry tokenEntry = new TokenEntry(token.getText(), sourceCode.getFileName(), token.getLine());
                    tokenEntries.add(tokenEntry);
                }
                token = lexer.nextToken();
            }
        }
        catch (ANTLRSyntaxError err) {
            throw new TokenMgrError("Lexical error in file " + sourceCode.getFileName() + " at line " + err.getLine() + ", column " + err.getColumn() + ".  Encountered: " + err.getMessage(), 0);
        }
        finally {
            tokenEntries.add(TokenEntry.getEOF());
        }
    }

    private static class ANTLRSyntaxError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final int line;
        private final int column;

        ANTLRSyntaxError(String msg, int line, int column, RecognitionException cause) {
            super(msg, cause);
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    private static class ErrorHandler
    extends BaseErrorListener {
        private ErrorHandler() {
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            throw new ANTLRSyntaxError(msg, line, charPositionInLine, ex);
        }
    }
}

