/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.scala.ast;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.lang.scala.ast.ASTCase;
import net.sourceforge.pmd.lang.scala.ast.ASTCtorPrimary;
import net.sourceforge.pmd.lang.scala.ast.ASTCtorSecondary;
import net.sourceforge.pmd.lang.scala.ast.ASTDeclDef;
import net.sourceforge.pmd.lang.scala.ast.ASTDeclType;
import net.sourceforge.pmd.lang.scala.ast.ASTDeclVal;
import net.sourceforge.pmd.lang.scala.ast.ASTDeclVar;
import net.sourceforge.pmd.lang.scala.ast.ASTDefnClass;
import net.sourceforge.pmd.lang.scala.ast.ASTDefnDef;
import net.sourceforge.pmd.lang.scala.ast.ASTDefnMacro;
import net.sourceforge.pmd.lang.scala.ast.ASTDefnObject;
import net.sourceforge.pmd.lang.scala.ast.ASTDefnTrait;
import net.sourceforge.pmd.lang.scala.ast.ASTDefnType;
import net.sourceforge.pmd.lang.scala.ast.ASTDefnVal;
import net.sourceforge.pmd.lang.scala.ast.ASTDefnVar;
import net.sourceforge.pmd.lang.scala.ast.ASTEnumeratorGenerator;
import net.sourceforge.pmd.lang.scala.ast.ASTEnumeratorGuard;
import net.sourceforge.pmd.lang.scala.ast.ASTEnumeratorVal;
import net.sourceforge.pmd.lang.scala.ast.ASTImport;
import net.sourceforge.pmd.lang.scala.ast.ASTImporteeName;
import net.sourceforge.pmd.lang.scala.ast.ASTImporteeRename;
import net.sourceforge.pmd.lang.scala.ast.ASTImporteeUnimport;
import net.sourceforge.pmd.lang.scala.ast.ASTImporteeWildcard;
import net.sourceforge.pmd.lang.scala.ast.ASTImporter;
import net.sourceforge.pmd.lang.scala.ast.ASTInit;
import net.sourceforge.pmd.lang.scala.ast.ASTLitBoolean;
import net.sourceforge.pmd.lang.scala.ast.ASTLitByte;
import net.sourceforge.pmd.lang.scala.ast.ASTLitChar;
import net.sourceforge.pmd.lang.scala.ast.ASTLitDouble;
import net.sourceforge.pmd.lang.scala.ast.ASTLitFloat;
import net.sourceforge.pmd.lang.scala.ast.ASTLitInt;
import net.sourceforge.pmd.lang.scala.ast.ASTLitLong;
import net.sourceforge.pmd.lang.scala.ast.ASTLitNull;
import net.sourceforge.pmd.lang.scala.ast.ASTLitShort;
import net.sourceforge.pmd.lang.scala.ast.ASTLitString;
import net.sourceforge.pmd.lang.scala.ast.ASTLitSymbol;
import net.sourceforge.pmd.lang.scala.ast.ASTLitUnit;
import net.sourceforge.pmd.lang.scala.ast.ASTMemberParamClauseGroup;
import net.sourceforge.pmd.lang.scala.ast.ASTModAbstract;
import net.sourceforge.pmd.lang.scala.ast.ASTModAnnot;
import net.sourceforge.pmd.lang.scala.ast.ASTModCase;
import net.sourceforge.pmd.lang.scala.ast.ASTModContravariant;
import net.sourceforge.pmd.lang.scala.ast.ASTModCovariant;
import net.sourceforge.pmd.lang.scala.ast.ASTModFinal;
import net.sourceforge.pmd.lang.scala.ast.ASTModImplicit;
import net.sourceforge.pmd.lang.scala.ast.ASTModInline;
import net.sourceforge.pmd.lang.scala.ast.ASTModLazy;
import net.sourceforge.pmd.lang.scala.ast.ASTModOverride;
import net.sourceforge.pmd.lang.scala.ast.ASTModPrivate;
import net.sourceforge.pmd.lang.scala.ast.ASTModProtected;
import net.sourceforge.pmd.lang.scala.ast.ASTModSealed;
import net.sourceforge.pmd.lang.scala.ast.ASTModValParam;
import net.sourceforge.pmd.lang.scala.ast.ASTModVarParam;
import net.sourceforge.pmd.lang.scala.ast.ASTNameAnonymous;
import net.sourceforge.pmd.lang.scala.ast.ASTNameIndeterminate;
import net.sourceforge.pmd.lang.scala.ast.ASTPatAlternative;
import net.sourceforge.pmd.lang.scala.ast.ASTPatArgClause;
import net.sourceforge.pmd.lang.scala.ast.ASTPatBind;
import net.sourceforge.pmd.lang.scala.ast.ASTPatExtract;
import net.sourceforge.pmd.lang.scala.ast.ASTPatExtractInfix;
import net.sourceforge.pmd.lang.scala.ast.ASTPatInterpolate;
import net.sourceforge.pmd.lang.scala.ast.ASTPatSeqWildcard;
import net.sourceforge.pmd.lang.scala.ast.ASTPatTuple;
import net.sourceforge.pmd.lang.scala.ast.ASTPatTyped;
import net.sourceforge.pmd.lang.scala.ast.ASTPatVar;
import net.sourceforge.pmd.lang.scala.ast.ASTPatWildcard;
import net.sourceforge.pmd.lang.scala.ast.ASTPatXml;
import net.sourceforge.pmd.lang.scala.ast.ASTPkg;
import net.sourceforge.pmd.lang.scala.ast.ASTPkgObject;
import net.sourceforge.pmd.lang.scala.ast.ASTQuasi;
import net.sourceforge.pmd.lang.scala.ast.ASTSelf;
import net.sourceforge.pmd.lang.scala.ast.ASTSource;
import net.sourceforge.pmd.lang.scala.ast.ASTTemplate;
import net.sourceforge.pmd.lang.scala.ast.ASTTermAnnotate;
import net.sourceforge.pmd.lang.scala.ast.ASTTermApply;
import net.sourceforge.pmd.lang.scala.ast.ASTTermApplyInfix;
import net.sourceforge.pmd.lang.scala.ast.ASTTermApplyType;
import net.sourceforge.pmd.lang.scala.ast.ASTTermApplyUnary;
import net.sourceforge.pmd.lang.scala.ast.ASTTermArgClause;
import net.sourceforge.pmd.lang.scala.ast.ASTTermAscribe;
import net.sourceforge.pmd.lang.scala.ast.ASTTermAssign;
import net.sourceforge.pmd.lang.scala.ast.ASTTermBlock;
import net.sourceforge.pmd.lang.scala.ast.ASTTermDo;
import net.sourceforge.pmd.lang.scala.ast.ASTTermEta;
import net.sourceforge.pmd.lang.scala.ast.ASTTermFor;
import net.sourceforge.pmd.lang.scala.ast.ASTTermForYield;
import net.sourceforge.pmd.lang.scala.ast.ASTTermFunction;
import net.sourceforge.pmd.lang.scala.ast.ASTTermIf;
import net.sourceforge.pmd.lang.scala.ast.ASTTermInterpolate;
import net.sourceforge.pmd.lang.scala.ast.ASTTermMatch;
import net.sourceforge.pmd.lang.scala.ast.ASTTermName;
import net.sourceforge.pmd.lang.scala.ast.ASTTermNew;
import net.sourceforge.pmd.lang.scala.ast.ASTTermNewAnonymous;
import net.sourceforge.pmd.lang.scala.ast.ASTTermParam;
import net.sourceforge.pmd.lang.scala.ast.ASTTermParamClause;
import net.sourceforge.pmd.lang.scala.ast.ASTTermPartialFunction;
import net.sourceforge.pmd.lang.scala.ast.ASTTermPlaceholder;
import net.sourceforge.pmd.lang.scala.ast.ASTTermRepeated;
import net.sourceforge.pmd.lang.scala.ast.ASTTermReturn;
import net.sourceforge.pmd.lang.scala.ast.ASTTermSelect;
import net.sourceforge.pmd.lang.scala.ast.ASTTermSuper;
import net.sourceforge.pmd.lang.scala.ast.ASTTermThis;
import net.sourceforge.pmd.lang.scala.ast.ASTTermThrow;
import net.sourceforge.pmd.lang.scala.ast.ASTTermTry;
import net.sourceforge.pmd.lang.scala.ast.ASTTermTryWithHandler;
import net.sourceforge.pmd.lang.scala.ast.ASTTermTuple;
import net.sourceforge.pmd.lang.scala.ast.ASTTermWhile;
import net.sourceforge.pmd.lang.scala.ast.ASTTermXml;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeAnd;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeAnnotate;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeApply;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeApplyInfix;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeArgClause;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeBounds;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeByName;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeExistential;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeFuncParamClause;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeFunction;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeImplicitFunction;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeLambda;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeMethod;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeName;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeOr;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeParam;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeParamClause;
import net.sourceforge.pmd.lang.scala.ast.ASTTypePlaceholder;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeProject;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeRefine;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeRepeated;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeSelect;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeSingleton;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeTuple;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeVar;
import net.sourceforge.pmd.lang.scala.ast.ASTTypeWith;
import net.sourceforge.pmd.lang.scala.ast.AbstractScalaNode;
import net.sourceforge.pmd.lang.scala.ast.ScalaNode;
import scala.meta.Case;
import scala.meta.Ctor;
import scala.meta.Decl;
import scala.meta.Defn;
import scala.meta.Enumerator;
import scala.meta.Import;
import scala.meta.Importee;
import scala.meta.Importer;
import scala.meta.Init;
import scala.meta.Lit;
import scala.meta.Member;
import scala.meta.Mod;
import scala.meta.Name;
import scala.meta.Pat;
import scala.meta.Pkg;
import scala.meta.Self;
import scala.meta.Source;
import scala.meta.Template;
import scala.meta.Term;
import scala.meta.Tree;
import scala.meta.Type;

class ScalaTreeBuilder {
    private static final Map<Class<? extends Tree>, Constructor<? extends ScalaNode<?>>> NODE_TYPE_TO_NODE_ADAPTER_TYPE = new HashMap();
    private final Deque<AbstractScalaNode<?>> nodes = new ArrayDeque();

    ScalaTreeBuilder() {
    }

    private static <T extends Tree> void register(Class<T> nodeType, Class<? extends ScalaNode<T>> nodeAdapterType) {
        try {
            NODE_TYPE_TO_NODE_ADAPTER_TYPE.put(nodeType, nodeAdapterType.getDeclaredConstructor(nodeType));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T extends Tree> AbstractScalaNode<T> createNodeAdapter(T node) {
        try {
            Constructor<ScalaNode<?>> constructor = null;
            for (Class<? extends Tree> treeClass : NODE_TYPE_TO_NODE_ADAPTER_TYPE.keySet()) {
                if (!treeClass.isInstance(node)) continue;
                constructor = NODE_TYPE_TO_NODE_ADAPTER_TYPE.get(treeClass);
            }
            if (constructor == null) {
                throw new IllegalArgumentException("There is no Node adapter class registered for the Node class: " + node.getClass());
            }
            return (AbstractScalaNode)constructor.newInstance(node);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    <T extends Tree> ScalaNode<T> build(T astNode) {
        return this.buildInternal(astNode);
    }

    private <T extends Tree> ScalaNode<T> buildInternal(T astNode) {
        AbstractScalaNode<?> parent;
        AbstractScalaNode<T> node = ScalaTreeBuilder.createNodeAdapter(astNode);
        AbstractScalaNode<?> abstractScalaNode = parent = this.nodes.isEmpty() ? null : this.nodes.peek();
        if (parent != null) {
            parent.addChild(node, parent.getNumChildren());
        }
        this.nodes.push(node);
        int childrenNum = astNode.children().size();
        for (int i = 0; i < childrenNum; ++i) {
            this.buildInternal((Tree)astNode.children().apply(i));
        }
        this.nodes.pop();
        return node;
    }

    static {
        ScalaTreeBuilder.register(Case.class, ASTCase.class);
        ScalaTreeBuilder.register(Ctor.Primary.class, ASTCtorPrimary.class);
        ScalaTreeBuilder.register(Ctor.Secondary.class, ASTCtorSecondary.class);
        ScalaTreeBuilder.register(Decl.Def.class, ASTDeclDef.class);
        ScalaTreeBuilder.register(Decl.Type.class, ASTDeclType.class);
        ScalaTreeBuilder.register(Decl.Val.class, ASTDeclVal.class);
        ScalaTreeBuilder.register(Decl.Var.class, ASTDeclVar.class);
        ScalaTreeBuilder.register(Defn.Class.class, ASTDefnClass.class);
        ScalaTreeBuilder.register(Defn.Def.class, ASTDefnDef.class);
        ScalaTreeBuilder.register(Defn.Macro.class, ASTDefnMacro.class);
        ScalaTreeBuilder.register(Defn.Object.class, ASTDefnObject.class);
        ScalaTreeBuilder.register(Defn.Trait.class, ASTDefnTrait.class);
        ScalaTreeBuilder.register(Defn.Type.class, ASTDefnType.class);
        ScalaTreeBuilder.register(Defn.Val.class, ASTDefnVal.class);
        ScalaTreeBuilder.register(Defn.Var.class, ASTDefnVar.class);
        ScalaTreeBuilder.register(Enumerator.Generator.class, ASTEnumeratorGenerator.class);
        ScalaTreeBuilder.register(Enumerator.Guard.class, ASTEnumeratorGuard.class);
        ScalaTreeBuilder.register(Enumerator.Val.class, ASTEnumeratorVal.class);
        ScalaTreeBuilder.register(Import.class, ASTImport.class);
        ScalaTreeBuilder.register(Importee.Name.class, ASTImporteeName.class);
        ScalaTreeBuilder.register(Importee.Rename.class, ASTImporteeRename.class);
        ScalaTreeBuilder.register(Importee.Unimport.class, ASTImporteeUnimport.class);
        ScalaTreeBuilder.register(Importee.Wildcard.class, ASTImporteeWildcard.class);
        ScalaTreeBuilder.register(Importer.class, ASTImporter.class);
        ScalaTreeBuilder.register(Init.class, ASTInit.class);
        ScalaTreeBuilder.register(Lit.Boolean.class, ASTLitBoolean.class);
        ScalaTreeBuilder.register(Lit.Byte.class, ASTLitByte.class);
        ScalaTreeBuilder.register(Lit.Char.class, ASTLitChar.class);
        ScalaTreeBuilder.register(Lit.Double.class, ASTLitDouble.class);
        ScalaTreeBuilder.register(Lit.Float.class, ASTLitFloat.class);
        ScalaTreeBuilder.register(Lit.Int.class, ASTLitInt.class);
        ScalaTreeBuilder.register(Lit.Long.class, ASTLitLong.class);
        ScalaTreeBuilder.register(Lit.Null.class, ASTLitNull.class);
        ScalaTreeBuilder.register(Lit.Short.class, ASTLitShort.class);
        ScalaTreeBuilder.register(Lit.String.class, ASTLitString.class);
        ScalaTreeBuilder.register(Lit.Symbol.class, ASTLitSymbol.class);
        ScalaTreeBuilder.register(Lit.Unit.class, ASTLitUnit.class);
        ScalaTreeBuilder.register(Member.ParamClauseGroup.class, ASTMemberParamClauseGroup.class);
        ScalaTreeBuilder.register(Mod.Abstract.class, ASTModAbstract.class);
        ScalaTreeBuilder.register(Mod.Annot.class, ASTModAnnot.class);
        ScalaTreeBuilder.register(Mod.Case.class, ASTModCase.class);
        ScalaTreeBuilder.register(Mod.Contravariant.class, ASTModContravariant.class);
        ScalaTreeBuilder.register(Mod.Covariant.class, ASTModCovariant.class);
        ScalaTreeBuilder.register(Mod.Final.class, ASTModFinal.class);
        ScalaTreeBuilder.register(Mod.Implicit.class, ASTModImplicit.class);
        ScalaTreeBuilder.register(Mod.Inline.class, ASTModInline.class);
        ScalaTreeBuilder.register(Mod.Lazy.class, ASTModLazy.class);
        ScalaTreeBuilder.register(Mod.Override.class, ASTModOverride.class);
        ScalaTreeBuilder.register(Mod.Private.class, ASTModPrivate.class);
        ScalaTreeBuilder.register(Mod.Protected.class, ASTModProtected.class);
        ScalaTreeBuilder.register(Mod.Sealed.class, ASTModSealed.class);
        ScalaTreeBuilder.register(Mod.ValParam.class, ASTModValParam.class);
        ScalaTreeBuilder.register(Mod.VarParam.class, ASTModVarParam.class);
        ScalaTreeBuilder.register(Name.Anonymous.class, ASTNameAnonymous.class);
        ScalaTreeBuilder.register(Name.Indeterminate.class, ASTNameIndeterminate.class);
        ScalaTreeBuilder.register(Pat.Alternative.class, ASTPatAlternative.class);
        ScalaTreeBuilder.register(Pat.ArgClause.class, ASTPatArgClause.class);
        ScalaTreeBuilder.register(Pat.Bind.class, ASTPatBind.class);
        ScalaTreeBuilder.register(Pat.Extract.class, ASTPatExtract.class);
        ScalaTreeBuilder.register(Pat.ExtractInfix.class, ASTPatExtractInfix.class);
        ScalaTreeBuilder.register(Pat.Interpolate.class, ASTPatInterpolate.class);
        ScalaTreeBuilder.register(Pat.SeqWildcard.class, ASTPatSeqWildcard.class);
        ScalaTreeBuilder.register(Pat.Tuple.class, ASTPatTuple.class);
        ScalaTreeBuilder.register(Pat.Typed.class, ASTPatTyped.class);
        ScalaTreeBuilder.register(Pat.Var.class, ASTPatVar.class);
        ScalaTreeBuilder.register(Pat.Wildcard.class, ASTPatWildcard.class);
        ScalaTreeBuilder.register(Pat.Xml.class, ASTPatXml.class);
        ScalaTreeBuilder.register(Pkg.class, ASTPkg.class);
        ScalaTreeBuilder.register(Pkg.Object.class, ASTPkgObject.class);
        ScalaTreeBuilder.register(Tree.Quasi.class, ASTQuasi.class);
        ScalaTreeBuilder.register(Self.class, ASTSelf.class);
        ScalaTreeBuilder.register(Source.class, ASTSource.class);
        ScalaTreeBuilder.register(Template.class, ASTTemplate.class);
        ScalaTreeBuilder.register(Term.Annotate.class, ASTTermAnnotate.class);
        ScalaTreeBuilder.register(Term.Apply.class, ASTTermApply.class);
        ScalaTreeBuilder.register(Term.ApplyInfix.class, ASTTermApplyInfix.class);
        ScalaTreeBuilder.register(Term.ApplyType.class, ASTTermApplyType.class);
        ScalaTreeBuilder.register(Term.ApplyUnary.class, ASTTermApplyUnary.class);
        ScalaTreeBuilder.register(Term.ArgClause.class, ASTTermArgClause.class);
        ScalaTreeBuilder.register(Term.Ascribe.class, ASTTermAscribe.class);
        ScalaTreeBuilder.register(Term.Assign.class, ASTTermAssign.class);
        ScalaTreeBuilder.register(Term.Block.class, ASTTermBlock.class);
        ScalaTreeBuilder.register(Term.Do.class, ASTTermDo.class);
        ScalaTreeBuilder.register(Term.Eta.class, ASTTermEta.class);
        ScalaTreeBuilder.register(Term.For.class, ASTTermFor.class);
        ScalaTreeBuilder.register(Term.ForYield.class, ASTTermForYield.class);
        ScalaTreeBuilder.register(Term.Function.class, ASTTermFunction.class);
        ScalaTreeBuilder.register(Term.If.class, ASTTermIf.class);
        ScalaTreeBuilder.register(Term.Interpolate.class, ASTTermInterpolate.class);
        ScalaTreeBuilder.register(Term.Match.class, ASTTermMatch.class);
        ScalaTreeBuilder.register(Term.Name.class, ASTTermName.class);
        ScalaTreeBuilder.register(Term.NewAnonymous.class, ASTTermNewAnonymous.class);
        ScalaTreeBuilder.register(Term.New.class, ASTTermNew.class);
        ScalaTreeBuilder.register(Term.Param.class, ASTTermParam.class);
        ScalaTreeBuilder.register(Term.ParamClause.class, ASTTermParamClause.class);
        ScalaTreeBuilder.register(Term.PartialFunction.class, ASTTermPartialFunction.class);
        ScalaTreeBuilder.register(Term.Placeholder.class, ASTTermPlaceholder.class);
        ScalaTreeBuilder.register(Term.Repeated.class, ASTTermRepeated.class);
        ScalaTreeBuilder.register(Term.Return.class, ASTTermReturn.class);
        ScalaTreeBuilder.register(Term.Select.class, ASTTermSelect.class);
        ScalaTreeBuilder.register(Term.Super.class, ASTTermSuper.class);
        ScalaTreeBuilder.register(Term.This.class, ASTTermThis.class);
        ScalaTreeBuilder.register(Term.Throw.class, ASTTermThrow.class);
        ScalaTreeBuilder.register(Term.Try.class, ASTTermTry.class);
        ScalaTreeBuilder.register(Term.TryWithHandler.class, ASTTermTryWithHandler.class);
        ScalaTreeBuilder.register(Term.Tuple.class, ASTTermTuple.class);
        ScalaTreeBuilder.register(Term.While.class, ASTTermWhile.class);
        ScalaTreeBuilder.register(Term.Xml.class, ASTTermXml.class);
        ScalaTreeBuilder.register(Type.And.class, ASTTypeAnd.class);
        ScalaTreeBuilder.register(Type.Annotate.class, ASTTypeAnnotate.class);
        ScalaTreeBuilder.register(Type.Apply.class, ASTTypeApply.class);
        ScalaTreeBuilder.register(Type.ApplyInfix.class, ASTTypeApplyInfix.class);
        ScalaTreeBuilder.register(Type.ArgClause.class, ASTTypeArgClause.class);
        ScalaTreeBuilder.register(Type.Bounds.class, ASTTypeBounds.class);
        ScalaTreeBuilder.register(Type.ByName.class, ASTTypeByName.class);
        ScalaTreeBuilder.register(Type.Existential.class, ASTTypeExistential.class);
        ScalaTreeBuilder.register(Type.FuncParamClause.class, ASTTypeFuncParamClause.class);
        ScalaTreeBuilder.register(Type.Function.class, ASTTypeFunction.class);
        ScalaTreeBuilder.register(Type.ImplicitFunction.class, ASTTypeImplicitFunction.class);
        ScalaTreeBuilder.register(Type.Lambda.class, ASTTypeLambda.class);
        ScalaTreeBuilder.register(Type.Method.class, ASTTypeMethod.class);
        ScalaTreeBuilder.register(Type.Name.class, ASTTypeName.class);
        ScalaTreeBuilder.register(Type.Or.class, ASTTypeOr.class);
        ScalaTreeBuilder.register(Type.Param.class, ASTTypeParam.class);
        ScalaTreeBuilder.register(Type.ParamClause.class, ASTTypeParamClause.class);
        ScalaTreeBuilder.register(Type.Placeholder.class, ASTTypePlaceholder.class);
        ScalaTreeBuilder.register(Type.Project.class, ASTTypeProject.class);
        ScalaTreeBuilder.register(Type.Refine.class, ASTTypeRefine.class);
        ScalaTreeBuilder.register(Type.Repeated.class, ASTTypeRepeated.class);
        ScalaTreeBuilder.register(Type.Select.class, ASTTypeSelect.class);
        ScalaTreeBuilder.register(Type.Singleton.class, ASTTypeSingleton.class);
        ScalaTreeBuilder.register(Type.Tuple.class, ASTTypeTuple.class);
        ScalaTreeBuilder.register(Type.Var.class, ASTTypeVar.class);
        ScalaTreeBuilder.register(Type.With.class, ASTTypeWith.class);
    }
}

