/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.scala.ast;

import java.util.Comparator;
import net.sourceforge.pmd.lang.ast.AstVisitor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.AbstractNode;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.lang.scala.ast.ScalaNode;
import net.sourceforge.pmd.lang.scala.ast.ScalaVisitor;
import scala.meta.Tree;
import scala.meta.inputs.Position;

abstract class AbstractScalaNode<T extends Tree>
extends AbstractNode<AbstractScalaNode<?>, ScalaNode<?>>
implements ScalaNode<T> {
    private static final Comparator<Position> POS_CMP = Comparator.comparingInt(Position::start).thenComparing(Position::end);
    protected final T node;
    private final Position pos;

    AbstractScalaNode(T treeNode) {
        this.node = treeNode;
        this.pos = this.node.pos();
    }

    public <P, R> R acceptVisitor(AstVisitor<? super P, ? extends R> visitor, P data) {
        if (visitor instanceof ScalaVisitor) {
            return this.acceptVisitor((ScalaVisitor)visitor, data);
        }
        return (R)visitor.cannotVisit((Node)this, data);
    }

    protected abstract <P, R> R acceptVisitor(ScalaVisitor<? super P, ? extends R> var1, P var2);

    protected void addChild(AbstractScalaNode<?> child, int index) {
        super.addChild(child, index);
    }

    @Override
    public boolean isImplicit() {
        return this.pos.end() - this.pos.start() == 0;
    }

    public TextRegion getTextRegion() {
        return TextRegion.fromBothOffsets((int)this.pos.start(), (int)this.pos.end());
    }

    public int compareLocation(Node node) {
        if (node instanceof AbstractScalaNode) {
            return POS_CMP.compare(((AbstractScalaNode)node).pos, this.pos);
        }
        return ScalaNode.super.compareLocation(node);
    }

    public String getXPathNodeName() {
        return this.node.productPrefix().replace(".", "");
    }
}

