/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.util.Properties;
import net.sourceforge.pmd.cpd.ScalaTokenAdapter;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.cpd.token.internal.BaseTokenFilter;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import net.sourceforge.pmd.lang.document.CpdCompat;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.scala.ScalaLanguageModule;
import org.apache.commons.lang3.StringUtils;
import scala.collection.Iterator;
import scala.meta.Dialect;
import scala.meta.inputs.Input;
import scala.meta.inputs.Position;
import scala.meta.internal.tokenizers.ScalametaTokenizer;
import scala.meta.tokenizers.TokenizeException;
import scala.meta.tokens.Token;

public class ScalaTokenizer
implements Tokenizer {
    public static final String SCALA_VERSION_PROPERTY = "net.sourceforge.pmd.scala.version";
    private final Dialect dialect;

    public ScalaTokenizer() {
        this(System.getProperties());
    }

    public ScalaTokenizer(Properties properties) {
        String scalaVersion = properties.getProperty(SCALA_VERSION_PROPERTY);
        LanguageVersion langVer = scalaVersion == null ? ScalaLanguageModule.getInstance().getDefaultVersion() : ScalaLanguageModule.getInstance().getVersion(scalaVersion);
        this.dialect = ScalaLanguageModule.dialectOf(langVer);
    }

    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) throws IOException {
        TextFile textFile = CpdCompat.cpdCompat((SourceCode)sourceCode);
        try (TextDocument textDoc = TextDocument.create((TextFile)textFile);){
            ScalaTokenAdapter token;
            String fullCode = textDoc.getText().toString();
            Input.VirtualFile vf = new Input.VirtualFile(sourceCode.getFileName(), fullCode);
            ScalametaTokenizer tokenizer = new ScalametaTokenizer((Input)vf, this.dialect);
            scala.meta.tokens.Tokens tokens = tokenizer.tokenize();
            ScalaTokenManager scalaTokenManager = new ScalaTokenManager((Iterator<Token>)tokens.iterator(), textDoc);
            ScalaTokenFilter filter = new ScalaTokenFilter(scalaTokenManager);
            while ((token = (ScalaTokenAdapter)filter.getNextToken()) != null) {
                if (StringUtils.isEmpty((CharSequence)token.getImage())) continue;
                TokenEntry cpdToken = new TokenEntry(token.getImage(), token.getReportLocation());
                tokenEntries.add(cpdToken);
            }
        }
        catch (Exception e) {
            if (e instanceof TokenizeException) {
                TokenizeException tokE = (TokenizeException)e;
                Position pos = tokE.pos();
                throw new TokenMgrError(pos.startLine() + 1, pos.startColumn() + 1, textFile.getFileId(), "Scalameta threw", (Throwable)tokE);
            }
            throw e;
        }
        finally {
            tokenEntries.add(TokenEntry.getEOF());
        }
    }

    private static class ScalaTokenFilter
    extends BaseTokenFilter<ScalaTokenAdapter> {
        ScalaTokenFilter(TokenManager<ScalaTokenAdapter> tokenManager) {
            super(tokenManager);
        }

        protected boolean shouldStopProcessing(ScalaTokenAdapter currentToken) {
            return currentToken == null;
        }
    }

    private static class ScalaTokenManager
    implements TokenManager<ScalaTokenAdapter> {
        private final Iterator<Token> tokenIter;
        private final TextDocument textDocument;
        private static final Class<?>[] SKIPPABLE_TOKENS = new Class[]{Token.Space.class, Token.Tab.class, Token.CR.class, Token.LF.class, Token.FF.class, Token.LFLF.class, Token.EOF.class, Token.Comment.class};
        private ScalaTokenAdapter previousComment = null;

        ScalaTokenManager(Iterator<Token> iterator, TextDocument textDocument) {
            this.tokenIter = iterator;
            this.textDocument = textDocument;
        }

        public ScalaTokenAdapter getNextToken() {
            Token token;
            if (!this.tokenIter.hasNext()) {
                return null;
            }
            do {
                if (!this.isComment(token = (Token)this.tokenIter.next())) continue;
                this.previousComment = new ScalaTokenAdapter(token, this.textDocument, this.previousComment);
            } while (token != null && this.skipToken(token) && this.tokenIter.hasNext());
            return new ScalaTokenAdapter(token, this.textDocument, this.previousComment);
        }

        private boolean skipToken(Token token) {
            boolean skip = false;
            if (token.text() != null) {
                for (Class<?> skipTokenClazz : SKIPPABLE_TOKENS) {
                    skip |= skipTokenClazz.isInstance(token);
                }
            }
            return skip;
        }

        private boolean isComment(Token token) {
            return token instanceof Token.Comment;
        }
    }
}

