/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.modelica.resolver;

import net.sourceforge.pmd.lang.modelica.resolver.AbstractModelicaScope;
import net.sourceforge.pmd.lang.modelica.resolver.CompositeName;
import net.sourceforge.pmd.lang.modelica.resolver.InternalModelicaResolverApi;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaClassDeclaration;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaClassType;
import net.sourceforge.pmd.lang.modelica.resolver.ModelicaSourceFileScope;
import net.sourceforge.pmd.lang.modelica.resolver.ResolutionContext;
import net.sourceforge.pmd.lang.modelica.resolver.Watchdog;

public final class ModelicaClassScope
extends AbstractModelicaScope {
    private final ModelicaClassDeclaration classDeclaration;

    ModelicaClassScope(ModelicaClassDeclaration declaration) {
        this.classDeclaration = declaration;
        this.classDeclaration.setOwnScope(this);
    }

    public ModelicaClassType getClassDeclaration() {
        return this.classDeclaration;
    }

    @Override
    public void resolveLexically(ResolutionContext result, CompositeName name) throws Watchdog.CountdownException {
        InternalModelicaResolverApi.resolveFurtherNameComponents(this.classDeclaration, result, name);
        if (this.classDeclaration.isEncapsulated()) {
            this.getRoot().resolveBuiltin(result, name);
        } else {
            ((AbstractModelicaScope)this.getParent()).resolveLexically(result, name);
        }
    }

    @Override
    public String getRepresentation() {
        return "Class:" + this.classDeclaration.getSimpleTypeName();
    }

    String getFullyQualifiedClassName() {
        if (this.getParent() instanceof ModelicaClassScope) {
            return ((ModelicaClassScope)this.getParent()).getFullyQualifiedClassName() + "." + this.classDeclaration.getSimpleTypeName();
        }
        return ((ModelicaSourceFileScope)this.getParent()).getFileFQCN();
    }
}

