/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.test.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.test.ast.BaseNodeAttributePrinter;
import net.sourceforge.pmd.util.StringUtil;
import net.sourceforge.pmd.util.treeexport.TextTreeRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001e\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0014J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014R \u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004*\u0006\u0012\u0002\b\u00030\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lnet/sourceforge/pmd/lang/test/ast/BaseNodeAttributePrinter;", "Lnet/sourceforge/pmd/util/treeexport/TextTreeRenderer;", "()V", "enumDeclaringClass", "Ljava/lang/Class;", "", "getEnumDeclaringClass", "(Ljava/lang/Enum;)Ljava/lang/Class;", "appendNodeInfoLn", "", "out", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "node", "Lnet/sourceforge/pmd/lang/ast/Node;", "fillAttributes", "result", "", "Lnet/sourceforge/pmd/lang/test/ast/BaseNodeAttributePrinter$AttributeInfo;", "ignoreAttribute", "", "attribute", "Lnet/sourceforge/pmd/lang/rule/xpath/Attribute;", "valueToString", "", "value", "", "AttributeInfo", "pmd-lang-test"})
public class BaseNodeAttributePrinter
extends TextTreeRenderer {
    public BaseNodeAttributePrinter() {
        super(true, -1);
    }

    protected boolean ignoreAttribute(@NotNull Node node, @NotNull Attribute attribute) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        return true;
    }

    protected void fillAttributes(@NotNull Node node, @NotNull List<AttributeInfo> result) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Iterator iterator = node.getXPathAttributesIterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"node.xPathAttributesIterator");
        Sequence $this$forEach$iv = SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.asSequence((Iterator)iterator), (Function1)((Function1)new Function1<Attribute, Boolean>(this, node){
            final /* synthetic */ BaseNodeAttributePrinter this$0;
            final /* synthetic */ Node $node;
            {
                this.this$0 = $receiver;
                this.$node = $node;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Attribute it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return this.this$0.ignoreAttribute(this.$node, it);
            }
        })), (Function1)fillAttributes.2.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AttributeInfo it = (AttributeInfo)element$iv;
            boolean bl = false;
            ((Collection)result).add(it);
        }
    }

    protected void appendNodeInfoLn(@NotNull Appendable out, @NotNull Node node) {
        List attrs;
        List list;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        out.append(node.getXPathNodeName());
        List it = list = (List)new ArrayList();
        boolean bl = false;
        this.fillAttributes(node, it);
        List $this$sortBy$iv = attrs = list;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AttributeInfo it = (AttributeInfo)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (AttributeInfo)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
        }
        CollectionsKt.joinTo$default((Iterable)attrs, (Appendable)out, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)((Function1)new Function1<AttributeInfo, CharSequence>(this){
            final /* synthetic */ BaseNodeAttributePrinter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull AttributeInfo it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return '@' + it.getName() + " = " + this.this$0.valueToString(it.getValue());
            }
        }), (int)50, null);
        out.append("\n");
    }

    @Nullable
    protected String valueToString(@Nullable Object value) {
        String string;
        Object object = value;
        if (object instanceof String ? true : object instanceof Chars) {
            string = '\"' + StringUtil.escapeJava((String)value.toString()) + '\"';
        } else if (object instanceof Character) {
            CharSequence charSequence = String.valueOf(((Character)value).charValue());
            Regex regex = new Regex("'");
            String string2 = "\\'";
            string = '\'' + regex.replace(charSequence, string2) + '\'';
        } else if (object instanceof Enum) {
            string = this.getEnumDeclaringClass((Enum)value).getSimpleName() + '.' + ((Enum)value).name();
        } else if (object instanceof Class) {
            String string3 = ((Class)value).getCanonicalName();
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                string = it + ".class";
            } else {
                string = null;
            }
        } else {
            string = (object instanceof Number ? true : object instanceof Boolean) ? value.toString() : (object == null ? "null" : null);
        }
        return string;
    }

    private final Class<?> getEnumDeclaringClass(Enum<?> $this$enumDeclaringClass) {
        Class<Object> clazz;
        Class<?> it = $this$enumDeclaringClass.getClass();
        boolean bl = false;
        if (it.isEnum()) {
            clazz = it;
        } else {
            Class<?> clazz2;
            Class<?> clazz3 = clazz2 = it.getEnclosingClass();
            boolean bl2 = false;
            clazz = clazz3.isEnum() ? clazz2 : null;
            if (clazz == null) {
                throw new IllegalStateException();
            }
        }
        return clazz;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lnet/sourceforge/pmd/lang/test/ast/BaseNodeAttributePrinter$AttributeInfo;", "", "name", "", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "getName", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "pmd-lang-test"})
    public static final class AttributeInfo {
        @NotNull
        private final String name;
        @Nullable
        private final Object value;

        public AttributeInfo(@NotNull String name, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.value = value;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @Nullable
        public final Object component2() {
            return this.value;
        }

        @NotNull
        public final AttributeInfo copy(@NotNull String name, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new AttributeInfo(name, value);
        }

        public static /* synthetic */ AttributeInfo copy$default(AttributeInfo attributeInfo, String string, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                string = attributeInfo.name;
            }
            if ((n & 2) != 0) {
                object = attributeInfo.value;
            }
            return attributeInfo.copy(string, object);
        }

        @NotNull
        public String toString() {
            return "AttributeInfo(name=" + this.name + ", value=" + this.value + ')';
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AttributeInfo)) {
                return false;
            }
            AttributeInfo attributeInfo = (AttributeInfo)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)attributeInfo.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)attributeInfo.value);
        }
    }
}

