/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd.test;

import io.kotest.assertions.FailuresKt;
import io.kotest.assertions.jvmcounter;
import io.kotest.mpp.ReflectionKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.sourceforge.pmd.cpd.CpdCapableLanguage;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.cpd.test.LanguagePropertyConfig;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.TokenMgrError;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.test.BaseTextComparisonTest;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000 <2\u00020\u0001:\u0001<B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\b\b\u0002\u0010\u0018\u001a\u00020\u00032\b\b\u0002\u0010\u0019\u001a\u00020\u0014H\u0007J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010!\u001a\u00020\u0014H\u0007J\u001a\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010\u0019\u001a\u00020\u0014H\u0007J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u0014J\u001a\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u00032\b\b\u0002\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010&\u001a\u00020(2\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020%2\u0006\u0010\"\u001a\u00020#J\u0014\u0010,\u001a\u00060-j\u0002`.*\u00060-j\u0002`.H\u0002J\u0018\u0010/\u001a\u00020\u0016*\u00060-j\u0002`.2\u0006\u00100\u001a\u00020*H\u0002J,\u00101\u001a\u00060-j\u0002`.*\u00060-j\u0002`.2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0002J$\u00101\u001a\u00060-j\u0002`.*\u00060-j\u0002`.2\u0006\u00106\u001a\u0002072\u0006\u00100\u001a\u00020*H\u0002J \u00108\u001a\u000209*\u00060-j\u0002`.2\u0006\u0010:\u001a\u0002092\u0006\u0010;\u001a\u000209H\u0002R\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\n\u00a8\u0006="}, d2={"Lnet/sourceforge/pmd/cpd/test/CpdTextComparisonTest;", "Lnet/sourceforge/pmd/test/BaseTextComparisonTest;", "langId", "", "extensionIncludingDot", "(Ljava/lang/String;Ljava/lang/String;)V", "language", "Lnet/sourceforge/pmd/cpd/CpdCapableLanguage;", "(Lnet/sourceforge/pmd/cpd/CpdCapableLanguage;Ljava/lang/String;)V", "getExtensionIncludingDot", "()Ljava/lang/String;", "getLanguage", "()Lnet/sourceforge/pmd/cpd/CpdCapableLanguage;", "resourceLoader", "Ljava/lang/Class;", "getResourceLoader", "()Ljava/lang/Class;", "resourcePrefix", "getResourcePrefix", "defaultProperties", "Lnet/sourceforge/pmd/cpd/test/LanguagePropertyConfig;", "doTest", "", "fileBaseName", "expectedSuffix", "config", "escapeImage", "str", "expectTokenMgrError", "Lnet/sourceforge/pmd/lang/ast/TokenMgrError;", "source", "fileName", "Lnet/sourceforge/pmd/lang/document/FileId;", "properties", "fileData", "Lnet/sourceforge/pmd/test/BaseTextComparisonTest$FileData;", "newTokenizer", "Lnet/sourceforge/pmd/cpd/Tokenizer;", "sourceCodeOf", "text", "Lnet/sourceforge/pmd/lang/document/TextDocument;", "tokenize", "Lnet/sourceforge/pmd/cpd/Tokens;", "tokenizer", "appendHeader", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "format", "tokens", "formatLine", "escapedImage", "bcol", "", "ecol", "token", "Lnet/sourceforge/pmd/cpd/TokenEntry;", "padCol", "", "colStart", "colWidth", "Companion", "pmd-lang-test"})
public abstract class CpdTextComparisonTest
extends BaseTextComparisonTest {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CpdCapableLanguage language;
    @NotNull
    private final String extensionIncludingDot;
    @Deprecated
    @NotNull
    public static final String Indent = "    ";
    @Deprecated
    public static final int Col0Width = 40;
    @Deprecated
    public static final int Col1Width = 14;
    @Deprecated
    private static final int ImageSize = 34;

    public CpdTextComparisonTest(@NotNull CpdCapableLanguage language2, @NotNull String extensionIncludingDot) {
        Intrinsics.checkNotNullParameter((Object)language2, (String)"language");
        Intrinsics.checkNotNullParameter((Object)extensionIncludingDot, (String)"extensionIncludingDot");
        this.language = language2;
        this.extensionIncludingDot = extensionIncludingDot;
    }

    @NotNull
    public final CpdCapableLanguage getLanguage() {
        return this.language;
    }

    @Override
    @NotNull
    protected String getExtensionIncludingDot() {
        return this.extensionIncludingDot;
    }

    public CpdTextComparisonTest(@NotNull String langId, @NotNull String extensionIncludingDot) {
        Intrinsics.checkNotNullParameter((Object)langId, (String)"langId");
        Intrinsics.checkNotNullParameter((Object)extensionIncludingDot, (String)"extensionIncludingDot");
        Language language2 = LanguageRegistry.CPD.getLanguageById(langId);
        Intrinsics.checkNotNull((Object)language2, (String)"null cannot be cast to non-null type net.sourceforge.pmd.cpd.CpdCapableLanguage");
        this((CpdCapableLanguage)language2, extensionIncludingDot);
    }

    @NotNull
    public final Tokenizer newTokenizer(@NotNull LanguagePropertyConfig config) {
        LanguagePropertyBundle languagePropertyBundle;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        LanguagePropertyBundle it = languagePropertyBundle = this.language.newPropertyBundle();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        config.setProperties(it);
        LanguagePropertyBundle properties = languagePropertyBundle;
        Tokenizer tokenizer = this.language.createCpdTokenizer(properties);
        Intrinsics.checkNotNullExpressionValue((Object)tokenizer, (String)"language.createCpdTokenizer(properties)");
        return tokenizer;
    }

    @Override
    @NotNull
    protected Class<?> getResourceLoader() {
        return this.getClass();
    }

    @Override
    @NotNull
    protected String getResourcePrefix() {
        return "testdata";
    }

    @NotNull
    public LanguagePropertyConfig defaultProperties() {
        return new LanguagePropertyConfig(){

            public void setProperties(@NotNull LanguagePropertyBundle properties) {
                Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            }
        };
    }

    @JvmOverloads
    public final void doTest(@NotNull String fileBaseName, @NotNull String expectedSuffix, @NotNull LanguagePropertyConfig config) {
        Intrinsics.checkNotNullParameter((Object)fileBaseName, (String)"fileBaseName");
        Intrinsics.checkNotNullParameter((Object)expectedSuffix, (String)"expectedSuffix");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super.doTest$pmd_lang_test(fileBaseName, expectedSuffix, (Function1<? super BaseTextComparisonTest.FileData, String>)((Function1)new Function1<BaseTextComparisonTest.FileData, String>(this, config){
            final /* synthetic */ CpdTextComparisonTest this$0;
            final /* synthetic */ LanguagePropertyConfig $config;
            {
                this.this$0 = $receiver;
                this.$config = $config;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull BaseTextComparisonTest.FileData fdata) {
                StringBuilder stringBuilder;
                Intrinsics.checkNotNullParameter((Object)fdata, (String)"fdata");
                Tokens tokens = this.this$0.tokenize(this.this$0.newTokenizer(this.$config), fdata);
                CpdTextComparisonTest cpdTextComparisonTest = this.this$0;
                StringBuilder $this$invoke_u24lambda_u240 = stringBuilder = new StringBuilder();
                boolean bl = false;
                CpdTextComparisonTest.access$format(cpdTextComparisonTest, $this$invoke_u24lambda_u240, tokens);
                String string = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
                return string;
            }
        }));
    }

    public static /* synthetic */ void doTest$default(CpdTextComparisonTest cpdTextComparisonTest, String string, String string2, LanguagePropertyConfig languagePropertyConfig, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTest");
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            languagePropertyConfig = cpdTextComparisonTest.defaultProperties();
        }
        cpdTextComparisonTest.doTest(string, string2, languagePropertyConfig);
    }

    @JvmOverloads
    @NotNull
    public final TokenMgrError expectTokenMgrError(@NotNull String source, @NotNull FileId fileName, @NotNull LanguagePropertyConfig properties) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        return this.expectTokenMgrError(new BaseTextComparisonTest.FileData(fileName, source), properties);
    }

    public static /* synthetic */ TokenMgrError expectTokenMgrError$default(CpdTextComparisonTest cpdTextComparisonTest, String string, FileId fileId, LanguagePropertyConfig languagePropertyConfig, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: expectTokenMgrError");
        }
        if ((n & 2) != 0) {
            FileId fileId2 = FileId.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)fileId2, (String)"UNKNOWN");
            fileId = fileId2;
        }
        if ((n & 4) != 0) {
            languagePropertyConfig = cpdTextComparisonTest.defaultProperties();
        }
        return cpdTextComparisonTest.expectTokenMgrError(string, fileId, languagePropertyConfig);
    }

    @JvmOverloads
    @NotNull
    public final TokenMgrError expectTokenMgrError(@NotNull BaseTextComparisonTest.FileData fileData, @NotNull LanguagePropertyConfig config) {
        Throwable thrownThrowable$iv;
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        boolean $i$f$shouldThrow = false;
        jvmcounter.getAssertionCounter().inc();
        KClass expectedExceptionClass$iv = Reflection.getOrCreateKotlinClass(TokenMgrError.class);
        try {
            boolean bl = false;
            this.tokenize(this.newTokenizer(config), fileData);
            throwable = null;
        }
        catch (Throwable thrown$iv) {
            throwable = thrown$iv;
        }
        throwable = thrownThrowable$iv = throwable;
        if (throwable == null) {
            throw FailuresKt.failure((String)("Expected exception " + ReflectionKt.bestName((KClass)expectedExceptionClass$iv) + " but no exception was thrown."));
        }
        if (!(throwable instanceof TokenMgrError)) {
            if (throwable instanceof AssertionError) {
                throw thrownThrowable$iv;
            }
            throw FailuresKt.failure((String)("Expected exception " + ReflectionKt.bestName((KClass)expectedExceptionClass$iv) + " but a " + Reflection.getOrCreateKotlinClass(thrownThrowable$iv.getClass()).getSimpleName() + " was thrown instead."), (Throwable)thrownThrowable$iv);
        }
        return (TokenMgrError)thrownThrowable$iv;
    }

    public static /* synthetic */ TokenMgrError expectTokenMgrError$default(CpdTextComparisonTest cpdTextComparisonTest, BaseTextComparisonTest.FileData fileData, LanguagePropertyConfig languagePropertyConfig, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: expectTokenMgrError");
        }
        if ((n & 2) != 0) {
            languagePropertyConfig = cpdTextComparisonTest.defaultProperties();
        }
        return cpdTextComparisonTest.expectTokenMgrError(fileData, languagePropertyConfig);
    }

    private final void format(StringBuilder $this$format, Tokens tokens) {
        Intrinsics.checkNotNullExpressionValue((Object)this.appendHeader($this$format).append('\n'), (String)"append('\\n')");
        int curLine = -1;
        for (TokenEntry token : tokens.getTokens()) {
            if (token.isEof()) {
                StringBuilder stringBuilder = $this$format.append("EOF");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(\"EOF\")");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                continue;
            }
            if (curLine != token.getBeginLine()) {
                curLine = token.getBeginLine();
                StringBuilder stringBuilder = $this$format.append('L').append(curLine);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append('L').append(curLine)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            }
            Intrinsics.checkNotNullExpressionValue((Object)token, (String)"token");
            Intrinsics.checkNotNullExpressionValue((Object)this.formatLine($this$format, token, tokens).append('\n'), (String)"append('\\n')");
        }
    }

    private final StringBuilder appendHeader(StringBuilder $this$appendHeader) {
        return this.formatLine($this$appendHeader, "[Image] or [Truncated image[", "Bcol", "Ecol");
    }

    private final StringBuilder formatLine(StringBuilder $this$formatLine, TokenEntry token, Tokens tokens) {
        String string = token.getImage(tokens);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"token.getImage(tokens)");
        return this.formatLine($this$formatLine, this.escapeImage(string), token.getBeginColumn(), token.getEndColumn());
    }

    private final StringBuilder formatLine(StringBuilder $this$formatLine, String escapedImage, Object bcol, Object ecol) {
        int colStart = $this$formatLine.length();
        StringBuilder stringBuilder = $this$formatLine.append(Indent).append(escapedImage);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(Indent).append(escapedImage)");
        colStart = this.padCol(stringBuilder, colStart, 40);
        StringBuilder stringBuilder2 = $this$formatLine.append(Indent).append(bcol);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(Indent).append(bcol)");
        colStart = this.padCol(stringBuilder2, colStart, 14);
        StringBuilder stringBuilder3 = $this$formatLine.append(ecol);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(ecol)");
        return stringBuilder3;
    }

    private final int padCol(StringBuilder $this$padCol, int colStart, int colWidth) {
        int i = 1;
        int n = colStart + colWidth - $this$padCol.length();
        if (i <= n) {
            while (true) {
                $this$padCol.append(' ');
                if (i == n) break;
                ++i;
            }
        }
        return $this$padCol.length();
    }

    private final String escapeImage(String str) {
        String truncated;
        CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)str, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\r\n", (String)"\\r\\n", (boolean)false, (int)4, null), (String)"\t", (String)"\\t", (boolean)false, (int)4, null);
        Object object = new Regex("\\u000D\\u000A|[\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029]");
        String string = "\\\\n";
        charSequence = object.replace(charSequence, string);
        object = new Regex("[]\\[]");
        string = "\\\\$0";
        String escaped = object.replace(charSequence, string);
        String string2 = truncated = StringUtils.truncate((String)escaped, (int)ImageSize);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"truncated");
        if (StringsKt.endsWith$default((CharSequence)string2, (char)'\\', (boolean)false, (int)2, null)) {
            String string3 = truncated;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"truncated");
            if (!StringsKt.endsWith$default((String)string3, (String)"\\\\", (boolean)false, (int)2, null)) {
                String string4 = truncated;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"truncated");
                object = string4;
                int n = 0;
                int n2 = truncated.length() - 1;
                String string5 = ((String)object).substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                truncated = string5;
            }
        }
        return truncated.length() < escaped.length() ? '[' + truncated + '[' : '[' + truncated + ']';
    }

    private final TextDocument sourceCodeOf(BaseTextComparisonTest.FileData fileData) {
        TextDocument textDocument = TextDocument.readOnlyString((CharSequence)fileData.getFileText(), (FileId)fileData.getFileName(), (LanguageVersion)this.language.getDefaultVersion());
        Intrinsics.checkNotNullExpressionValue((Object)textDocument, (String)"readOnlyString(fileData.\u2026 language.defaultVersion)");
        return textDocument;
    }

    @JvmOverloads
    @NotNull
    public final BaseTextComparisonTest.FileData sourceCodeOf(@NotNull String text, @NotNull FileId fileName) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return new BaseTextComparisonTest.FileData(fileName, text);
    }

    public static /* synthetic */ BaseTextComparisonTest.FileData sourceCodeOf$default(CpdTextComparisonTest cpdTextComparisonTest, String string, FileId fileId, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sourceCodeOf");
        }
        if ((n & 2) != 0) {
            FileId fileId2 = FileId.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)fileId2, (String)"UNKNOWN");
            fileId = fileId2;
        }
        return cpdTextComparisonTest.sourceCodeOf(string, fileId);
    }

    @NotNull
    public final Tokens tokenize(@NotNull Tokenizer tokenizer, @NotNull BaseTextComparisonTest.FileData fileData) {
        Tokens tokens;
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Tokens tokens2 = tokens = new Tokens();
        boolean bl = false;
        TextDocument source = this.sourceCodeOf(fileData);
        Tokenizer.tokenize((Tokenizer)tokenizer, (TextDocument)source, (Tokens)tokens2);
        return tokens;
    }

    @JvmOverloads
    public final void doTest(@NotNull String fileBaseName, @NotNull String expectedSuffix) {
        Intrinsics.checkNotNullParameter((Object)fileBaseName, (String)"fileBaseName");
        Intrinsics.checkNotNullParameter((Object)expectedSuffix, (String)"expectedSuffix");
        CpdTextComparisonTest.doTest$default(this, fileBaseName, expectedSuffix, null, 4, null);
    }

    @JvmOverloads
    public final void doTest(@NotNull String fileBaseName) {
        Intrinsics.checkNotNullParameter((Object)fileBaseName, (String)"fileBaseName");
        CpdTextComparisonTest.doTest$default(this, fileBaseName, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final TokenMgrError expectTokenMgrError(@NotNull String source, @NotNull FileId fileName) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return CpdTextComparisonTest.expectTokenMgrError$default(this, source, fileName, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final TokenMgrError expectTokenMgrError(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return CpdTextComparisonTest.expectTokenMgrError$default(this, source, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final TokenMgrError expectTokenMgrError(@NotNull BaseTextComparisonTest.FileData fileData) {
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        return CpdTextComparisonTest.expectTokenMgrError$default(this, fileData, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final BaseTextComparisonTest.FileData sourceCodeOf(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return CpdTextComparisonTest.sourceCodeOf$default(this, text, null, 2, null);
    }

    public static final /* synthetic */ void access$format(CpdTextComparisonTest $this, StringBuilder $receiver, Tokens tokens) {
        $this.format($receiver, tokens);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/sourceforge/pmd/cpd/test/CpdTextComparisonTest$Companion;", "", "()V", "Col0Width", "", "Col1Width", "ImageSize", "getImageSize", "()I", "Indent", "", "pmd-lang-test"})
    private static final class Companion {
        private Companion() {
        }

        public final int getImageSize() {
            return ImageSize;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

