/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.test;

import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.string.MatchersKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.reflect.KCallable;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.TextAvailableNode;
import net.sourceforge.pmd.lang.ast.test.TestUtilsKt;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextRegion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\u001a*\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t\u001a\n\u0010\r\u001a\u00020\u0006*\u00020\u0007\u001a\u001f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\n\b\u0000\u0010\u0010\u0018\u0001*\u00020\u0007*\u00020\u0007H\u0086\b\u001a\u001e\u0010\u0011\u001a\u0002H\u0010\"\n\b\u0000\u0010\u0010\u0018\u0001*\u00020\u0007*\u00020\u0007H\u0086\b\u00a2\u0006\u0002\u0010\u0012\u001a\u0015\u0010\u0013\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0001H\u0086\u0004\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0016"}, d2={"textStr", "", "Lnet/sourceforge/pmd/lang/ast/TextAvailableNode;", "getTextStr", "(Lnet/sourceforge/pmd/lang/ast/TextAvailableNode;)Ljava/lang/String;", "assertBounds", "", "Lnet/sourceforge/pmd/lang/ast/Node;", "bline", "", "bcol", "eline", "ecol", "assertTextRangeIsOk", "getDescendantsOfType", "", "T", "getFirstDescendantOfType", "(Lnet/sourceforge/pmd/lang/ast/Node;)Lnet/sourceforge/pmd/lang/ast/Node;", "shouldHaveText", "str", "textOfReportLocation", "pmd-lang-test"})
public final class NodeExtensionsKt {
    @NotNull
    public static final String getTextStr(@NotNull TextAvailableNode $this$textStr) {
        Intrinsics.checkNotNullParameter((Object)$this$textStr, (String)"<this>");
        String string = $this$textStr.getText().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text.toString()");
        return string;
    }

    public static final void shouldHaveText(@NotNull TextAvailableNode $this$shouldHaveText, @NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveText, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        TestUtilsKt.shouldBe((KCallable)new PropertyReference0Impl($this$shouldHaveText){

            @Nullable
            public Object get() {
                return NodeExtensionsKt.getTextStr((TextAvailableNode)this.receiver);
            }
        }, str);
    }

    public static final /* synthetic */ <T extends Node> List<T> getDescendantsOfType(Node $this$getDescendantsOfType) {
        Intrinsics.checkNotNullParameter((Object)$this$getDescendantsOfType, (String)"<this>");
        boolean $i$f$getDescendantsOfType = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        List list = $this$getDescendantsOfType.descendants(Node.class).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"descendants(T::class.java).toList()");
        return list;
    }

    public static final /* synthetic */ <T extends Node> T getFirstDescendantOfType(Node $this$getFirstDescendantOfType) {
        Intrinsics.checkNotNullParameter((Object)$this$getFirstDescendantOfType, (String)"<this>");
        boolean $i$f$getFirstDescendantOfType = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Node node = $this$getFirstDescendantOfType.descendants(Node.class).firstOrThrow();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"descendants(T::class.java).firstOrThrow()");
        return (T)node;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final String textOfReportLocation(@NotNull Node $this$textOfReportLocation) {
        Intrinsics.checkNotNullParameter((Object)$this$textOfReportLocation, (String)"<this>");
        TextRegion textRegion = $this$textOfReportLocation.getReportLocation().getRegionInFile();
        TextRegion textRegion2 = textRegion;
        if (textRegion == null) return null;
        TextRegion textRegion3 = textRegion2;
        TextDocument textDocument = $this$textOfReportLocation.getTextDocument();
        Intrinsics.checkNotNullExpressionValue((Object)textDocument, (String)"textDocument");
        TextDocument textDocument2 = textDocument;
        TextRegion p0 = textRegion3;
        boolean bl = false;
        Chars chars = textDocument2.sliceOriginalText(p0);
        textRegion2 = chars;
        if (chars == null) return null;
        String string = textRegion2.toString();
        return string;
    }

    public static final void assertTextRangeIsOk(@NotNull Node $this$assertTextRangeIsOk) {
        Intrinsics.checkNotNullParameter((Object)$this$assertTextRangeIsOk, (String)"<this>");
        ShouldKt.shouldNotBe((Object)$this$assertTextRangeIsOk.getReportLocation(), null);
        Node node = $this$assertTextRangeIsOk.getParent();
        if (node == null) {
            return;
        }
        Node parent = node;
        if ($this$assertTextRangeIsOk instanceof TextAvailableNode && parent instanceof TextAvailableNode) {
            String string = ((TextAvailableNode)parent).getText().toString();
            String string2 = ((TextAvailableNode)$this$assertTextRangeIsOk).getText().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.text.toString()");
            MatchersKt.shouldContain((String)string, (String)string2);
        }
    }

    public static final void assertBounds(@NotNull Node $this$assertBounds, int bline, int bcol, int eline, int ecol) {
        FileLocation fileLocation;
        Intrinsics.checkNotNullParameter((Object)$this$assertBounds, (String)"<this>");
        FileLocation $this$assertBounds_u24lambda_u240 = fileLocation = $this$assertBounds.getReportLocation();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$assertBounds_u24lambda_u240, (String)"this");
        TestUtilsKt.shouldBe((KCallable)new Function0<Integer>((Object)$this$assertBounds_u24lambda_u240){

            @NotNull
            public final Integer invoke() {
                return ((FileLocation)this.receiver).getStartLine();
            }
        }, bline);
        TestUtilsKt.shouldBe((KCallable)new Function0<Integer>((Object)$this$assertBounds_u24lambda_u240){

            @NotNull
            public final Integer invoke() {
                return ((FileLocation)this.receiver).getStartColumn();
            }
        }, bcol);
        TestUtilsKt.shouldBe((KCallable)new Function0<Integer>((Object)$this$assertBounds_u24lambda_u240){

            @NotNull
            public final Integer invoke() {
                return ((FileLocation)this.receiver).getEndLine();
            }
        }, eline);
        TestUtilsKt.shouldBe((KCallable)new Function0<Integer>((Object)$this$assertBounds_u24lambda_u240){

            @NotNull
            public final Integer invoke() {
                return ((FileLocation)this.receiver).getEndColumn();
            }
        }, ecol);
    }
}

