/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.test;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.PmdAnalysis;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.ast.test.BaseParsingHelper;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\b\b&\u0018\u0000*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0000*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0004:\u0001]B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\u001d\u001a\u00028\u00002\u0006\u0010\t\u001a\u00020\nH$\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!H\u0002J%\u0010\"\u001a\u00028\u00012\u0006\u0010#\u001a\u00020$2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010%\u001a\u00020&H\u0014\u00a2\u0006\u0002\u0010'J\"\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00062\b\b\u0002\u0010-\u001a\u00020.H\u0007J\u0016\u0010/\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u00100\u001a\u000201J\u0016\u00102\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u00103\u001a\u00020\u0006J:\u00104\u001a\b\u0012\u0004\u0012\u0002H605\"\b\b\u0002\u00106*\u0002072\f\u00108\u001a\b\u0012\u0004\u0012\u0002H60\b2\u0006\u00109\u001a\u00020\u00062\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010;\u001a\u00020\r2\b\u0010:\u001a\u0004\u0018\u00010\u0006J\u0010\u0010<\u001a\u00020=2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0012\u0010>\u001a\u00020$2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u00062\b\b\u0002\u0010:\u001a\u00020BH\u0007J+\u0010C\u001a\u00028\u00012\u0006\u0010D\u001a\u00020\u00062\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010-\u001a\u00020.H\u0007\u00a2\u0006\u0002\u0010EJ%\u0010F\u001a\u00028\u00012\n\u0010G\u001a\u0006\u0012\u0002\b\u00030\b2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u0006H\u0017\u00a2\u0006\u0002\u0010HJ!\u0010I\u001a\u00028\u00012\u0006\u00100\u001a\u0002012\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u0006H\u0017\u00a2\u0006\u0002\u0010JJ \u0010K\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J!\u0010L\u001a\u00028\u00012\u0006\u0010M\u001a\u00020\u00062\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u0006H\u0017\u00a2\u0006\u0002\u0010NJ\u0012\u0010O\u001a\u00020\u00062\n\u0010G\u001a\u0006\u0012\u0002\b\u00030\bJ\u000e\u0010P\u001a\u00020\u00062\u0006\u0010Q\u001a\u00020\u0006J\u0015\u0010R\u001a\u00028\u00002\b\u0010:\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010SJ\u0017\u0010T\u001a\u00028\u00002\b\b\u0002\u0010U\u001a\u00020VH\u0007\u00a2\u0006\u0002\u0010WJ#\u0010X\u001a\u00028\u00002\n\u0010Y\u001a\u0006\u0012\u0002\b\u00030\b2\b\b\u0002\u0010\u001b\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010ZJ\u0013\u0010[\u001a\u00028\u00002\u0006\u0010\\\u001a\u00020\u0006\u00a2\u0006\u0002\u0010SR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0011R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper;", "Self", "T", "Lnet/sourceforge/pmd/lang/ast/RootNode;", "", "langName", "", "rootClass", "Ljava/lang/Class;", "params", "Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper$Params;", "(Ljava/lang/String;Ljava/lang/Class;Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper$Params;)V", "defaultVersion", "Lnet/sourceforge/pmd/lang/LanguageVersion;", "getDefaultVersion", "()Lnet/sourceforge/pmd/lang/LanguageVersion;", "getLangName", "()Ljava/lang/String;", "language", "Lnet/sourceforge/pmd/lang/Language;", "getLanguage", "()Lnet/sourceforge/pmd/lang/Language;", "getParams", "()Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper$Params;", "resourceLoader", "getResourceLoader$pmd_lang_test", "()Ljava/lang/Class;", "resourcePrefix", "getResourcePrefix$pmd_lang_test", "clone", "(Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper$Params;)Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper;", "consume", "input", "Ljava/io/InputStream;", "doParse", "processor", "Lnet/sourceforge/pmd/lang/LanguageProcessor;", "task", "Lnet/sourceforge/pmd/lang/ast/Parser$ParserTask;", "(Lnet/sourceforge/pmd/lang/LanguageProcessor;Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper$Params;Lnet/sourceforge/pmd/lang/ast/Parser$ParserTask;)Lnet/sourceforge/pmd/lang/ast/RootNode;", "executeRule", "Lnet/sourceforge/pmd/Report;", "rule", "Lnet/sourceforge/pmd/Rule;", "code", "fileName", "Lnet/sourceforge/pmd/lang/document/FileId;", "executeRuleOnFile", "path", "Ljava/nio/file/Path;", "executeRuleOnResource", "resourcePath", "getNodes", "", "R", "Lnet/sourceforge/pmd/lang/ast/Node;", "target", "source", "version", "getVersion", "loadLanguages", "Lnet/sourceforge/pmd/lang/LanguageProcessorRegistry;", "newProcessor", "newXpathRule", "Lnet/sourceforge/pmd/lang/rule/XPathRule;", "expr", "Lnet/sourceforge/pmd/lang/rule/xpath/XPathVersion;", "parse", "sourceCode", "(Ljava/lang/String;Ljava/lang/String;Lnet/sourceforge/pmd/lang/document/FileId;)Lnet/sourceforge/pmd/lang/ast/RootNode;", "parseClass", "clazz", "(Ljava/lang/Class;Ljava/lang/String;)Lnet/sourceforge/pmd/lang/ast/RootNode;", "parseFile", "(Ljava/nio/file/Path;Ljava/lang/String;)Lnet/sourceforge/pmd/lang/ast/RootNode;", "parseImpl", "parseResource", "resource", "(Ljava/lang/String;Ljava/lang/String;)Lnet/sourceforge/pmd/lang/ast/RootNode;", "readClassSource", "readResource", "resourceName", "withDefaultVersion", "(Ljava/lang/String;)Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper;", "withProcessing", "doProcess", "", "(Z)Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper;", "withResourceContext", "contextClass", "(Ljava/lang/Class;Ljava/lang/String;)Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper;", "withSuppressMarker", "marker", "Params", "pmd-lang-test"})
public abstract class BaseParsingHelper<Self extends BaseParsingHelper<Self, T>, T extends RootNode> {
    @NotNull
    private final String langName;
    @NotNull
    private final Class<T> rootClass;
    @NotNull
    private final Params params;

    public BaseParsingHelper(@NotNull String langName, @NotNull Class<T> rootClass, @NotNull Params params) {
        Intrinsics.checkNotNullParameter((Object)langName, (String)"langName");
        Intrinsics.checkNotNullParameter(rootClass, (String)"rootClass");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.langName = langName;
        this.rootClass = rootClass;
        this.params = params;
    }

    @NotNull
    protected final String getLangName() {
        return this.langName;
    }

    @NotNull
    protected final Params getParams() {
        return this.params;
    }

    @NotNull
    public final Class<?> getResourceLoader$pmd_lang_test() {
        Class<?> clazz = this.params.getResourceLoader();
        if (clazz == null) {
            clazz = this.getClass();
        }
        return clazz;
    }

    @NotNull
    public final String getResourcePrefix$pmd_lang_test() {
        return this.params.getResourcePrefix();
    }

    @NotNull
    public final LanguageVersion getVersion(@Nullable String version) {
        LanguageVersion languageVersion;
        Language language2 = this.getLanguage();
        if (version == null) {
            LanguageVersion languageVersion2 = language2.getDefaultVersion();
            languageVersion = languageVersion2;
            Intrinsics.checkNotNullExpressionValue((Object)languageVersion2, (String)"language.defaultVersion");
        } else {
            LanguageVersion languageVersion3 = language2.getVersion(version);
            if (languageVersion3 == null) {
                throw new AssertionError((Object)("Unsupported version " + version + " for language " + language2));
            }
            languageVersion = languageVersion3;
        }
        return languageVersion;
    }

    @NotNull
    public final Language getLanguage() {
        Language language2 = this.params.getLanguageRegistry().getLanguageByFullName(this.langName);
        if (language2 == null) {
            BaseParsingHelper $this$_get_language__u24lambda_u241 = this;
            boolean bl = false;
            String string = $this$_get_language__u24lambda_u241.params.getLanguageRegistry().commaSeparatedList(arg_0 -> BaseParsingHelper._get_language_$lambda$1$lambda$0(language.1.langNames.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"params.languageRegistry.\u2026SeparatedList { it.name }");
            String langNames2 = string;
            throw new AssertionError((Object)('\'' + $this$_get_language__u24lambda_u241.langName + "' is not a supported language (available " + langNames2 + ')'));
        }
        return language2;
    }

    @NotNull
    public final LanguageVersion getDefaultVersion() {
        return this.getVersion(this.params.getDefaultVerString());
    }

    @NotNull
    protected abstract Self clone(@NotNull Params var1);

    @JvmOverloads
    @NotNull
    public final Self withProcessing(boolean doProcess) {
        return this.clone(Params.copy$default(this.params, doProcess, null, null, null, null, null, 62, null));
    }

    public static /* synthetic */ BaseParsingHelper withProcessing$default(BaseParsingHelper baseParsingHelper, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withProcessing");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return baseParsingHelper.withProcessing(bl);
    }

    @NotNull
    public final Self withDefaultVersion(@Nullable String version) {
        return this.clone(Params.copy$default(this.params, false, version, null, null, null, null, 61, null));
    }

    @JvmOverloads
    @NotNull
    public final Self withResourceContext(@NotNull Class<?> contextClass, @NotNull String resourcePrefix) {
        Intrinsics.checkNotNullParameter(contextClass, (String)"contextClass");
        Intrinsics.checkNotNullParameter((Object)resourcePrefix, (String)"resourcePrefix");
        return this.clone(Params.copy$default(this.params, false, null, contextClass, resourcePrefix, null, null, 51, null));
    }

    public static /* synthetic */ BaseParsingHelper withResourceContext$default(BaseParsingHelper baseParsingHelper, Class clazz, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: withResourceContext");
        }
        if ((n & 2) != 0) {
            string = "";
        }
        return baseParsingHelper.withResourceContext(clazz, string);
    }

    @NotNull
    public final Self withSuppressMarker(@NotNull String marker) {
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        return this.clone(Params.copy$default(this.params, false, null, null, null, null, marker, 31, null));
    }

    @JvmOverloads
    @NotNull
    public final <R extends Node> List<R> getNodes(@NotNull Class<R> target, @NotNull String source, @Nullable String version) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        List list = BaseParsingHelper.parse$default(this, source, version, null, 4, null).descendants(target).crossFindBoundaries(true).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(source, version).d\u2026Boundaries(true).toList()");
        return list;
    }

    public static /* synthetic */ List getNodes$default(BaseParsingHelper baseParsingHelper, Class clazz, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getNodes");
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        return baseParsingHelper.getNodes(clazz, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final T parse(@NotNull String sourceCode, @Nullable String version, @NotNull FileId fileName) {
        T t;
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        String string = version;
        LanguageVersion lversion = string == null ? this.getDefaultVersion() : this.getVersion(string);
        Params params = Params.copy$default(this.params, false, lversion.getVersion(), null, null, null, null, 61, null);
        TextDocument textDoc = TextDocument.readOnlyString((CharSequence)sourceCode, (FileId)fileName, (LanguageVersion)lversion);
        AutoCloseable autoCloseable = (AutoCloseable)this.loadLanguages(params);
        Throwable throwable = null;
        try {
            LanguageProcessorRegistry reg = (LanguageProcessorRegistry)autoCloseable;
            boolean bl = false;
            Parser.ParserTask task = new Parser.ParserTask(textDoc, SemanticErrorReporter.noop(), reg);
            LanguageProcessor languageProcessor = reg.getProcessor(this.getLanguage());
            Intrinsics.checkNotNullExpressionValue((Object)languageProcessor, (String)"reg.getProcessor(language)");
            t = this.doParse(languageProcessor, params, task);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return t;
    }

    public static /* synthetic */ RootNode parse$default(BaseParsingHelper baseParsingHelper, String string, String string2, FileId fileId, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parse");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            FileId fileId2 = FileId.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)fileId2, (String)"UNKNOWN");
            fileId = fileId2;
        }
        return baseParsingHelper.parse(string, string2, fileId);
    }

    @NotNull
    protected LanguageProcessorRegistry loadLanguages(@NotNull Params params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        LanguageProcessorRegistry languageProcessorRegistry = LanguageProcessorRegistry.singleton((LanguageProcessor)this.newProcessor(params));
        Intrinsics.checkNotNullExpressionValue((Object)languageProcessorRegistry, (String)"singleton(newProcessor(params))");
        return languageProcessorRegistry;
    }

    @NotNull
    protected T doParse(@NotNull LanguageProcessor processor, @NotNull Params params, @NotNull Parser.ParserTask task) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        RootNode root = this.parseImpl(params, processor, task);
        T t = this.rootClass.cast(root);
        Intrinsics.checkNotNullExpressionValue(t, (String)"rootClass.cast(root)");
        return (T)((RootNode)t);
    }

    @JvmOverloads
    @NotNull
    public final LanguageProcessor newProcessor(@NotNull Params params) {
        LanguagePropertyBundle languagePropertyBundle;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        LanguagePropertyBundle $this$newProcessor_u24lambda_u243 = languagePropertyBundle = this.getLanguage().newPropertyBundle();
        boolean bl = false;
        String string = params.getDefaultVerString();
        if (string == null) {
            string = this.getDefaultVersion().getVersion();
        }
        $this$newProcessor_u24lambda_u243.setLanguageVersion(string);
        $this$newProcessor_u24lambda_u243.setProperty(LanguagePropertyBundle.SUPPRESS_MARKER, (Object)params.getSuppressMarker());
        LanguagePropertyBundle props = languagePropertyBundle;
        LanguageProcessor languageProcessor = this.getLanguage().createProcessor(props);
        Intrinsics.checkNotNullExpressionValue((Object)languageProcessor, (String)"language.createProcessor(props)");
        return languageProcessor;
    }

    public static /* synthetic */ LanguageProcessor newProcessor$default(BaseParsingHelper baseParsingHelper, Params params, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newProcessor");
        }
        if ((n & 1) != 0) {
            params = baseParsingHelper.params;
        }
        return baseParsingHelper.newProcessor(params);
    }

    @NotNull
    protected RootNode parseImpl(@NotNull Params params, @NotNull LanguageProcessor processor, @NotNull Parser.ParserTask task) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        RootNode rootNode = processor.services().getParser().parse(task);
        Intrinsics.checkNotNullExpressionValue((Object)rootNode, (String)"processor.services().parser.parse(task)");
        return rootNode;
    }

    @JvmOverloads
    @NotNull
    public T parseResource(@NotNull String resource, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        String string = this.readResource(resource);
        FileId fileId = FileId.fromPathLikeString((String)(this.params.getResourcePrefix() + resource));
        Intrinsics.checkNotNullExpressionValue((Object)fileId, (String)"fromPathLikeString(param\u2026esourcePrefix + resource)");
        return this.parse(string, version, fileId);
    }

    public static /* synthetic */ RootNode parseResource$default(BaseParsingHelper baseParsingHelper, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parseResource");
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return baseParsingHelper.parseResource(string, string2);
    }

    @JvmOverloads
    @NotNull
    public T parseFile(@NotNull Path path, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = IOUtil.readToString((Reader)Files.newBufferedReader(path));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readToString(Files.newBufferedReader(path))");
        FileId fileId = FileId.fromPath((Path)path);
        Intrinsics.checkNotNullExpressionValue((Object)fileId, (String)"fromPath(path)");
        return this.parse(string, version, fileId);
    }

    public static /* synthetic */ RootNode parseFile$default(BaseParsingHelper baseParsingHelper, Path path, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parseFile");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return baseParsingHelper.parseFile(path, string);
    }

    @JvmOverloads
    @NotNull
    public T parseClass(@NotNull Class<?> clazz, @Nullable String version) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)BaseParsingHelper.parse$default(this, this.readClassSource(clazz), version, null, 4, null);
    }

    public static /* synthetic */ RootNode parseClass$default(BaseParsingHelper baseParsingHelper, Class clazz, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: parseClass");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return baseParsingHelper.parseClass(clazz, string);
    }

    @NotNull
    public final String readResource(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        InputStream inputStream = this.getResourceLoader$pmd_lang_test().getResourceAsStream(this.params.getResourcePrefix() + resourceName);
        if (inputStream == null) {
            throw new IllegalArgumentException("Unable to find resource file " + this.params.getResourcePrefix() + resourceName + " from " + this.getResourceLoader$pmd_lang_test());
        }
        InputStream input = inputStream;
        return this.consume(input);
    }

    private final String consume(InputStream input) {
        String string = IOUtil.readToString((InputStream)input, (Charset)StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readToString(input, StandardCharsets.UTF_8)");
        CharSequence charSequence = string;
        Regex regex = new Regex("\\R");
        String string2 = "\n";
        return regex.replace(charSequence, string2);
    }

    @NotNull
    public final String readClassSource(@NotNull Class<?> clazz) {
        InputStream inputStream;
        Class<?> clazz2;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        StringBuilder stringBuilder = new StringBuilder();
        String string = clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.name");
        String sourceFile = stringBuilder.append(StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null)).append(".java").toString();
        String string2 = clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"clazz.name");
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"$", (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder2 = new StringBuilder();
            String string3 = sourceFile;
            int n = 0;
            String string4 = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"clazz.name");
            int n2 = StringsKt.indexOf$default((CharSequence)string4, (char)'$', (int)0, (boolean)false, (int)6, null);
            String string5 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            sourceFile = stringBuilder2.append(string5).append(".java").toString();
        }
        if ((clazz2 = this.params.getResourceLoader()) == null) {
            clazz2 = this.getClass();
        }
        if ((inputStream = clazz2.getClassLoader().getResourceAsStream(sourceFile)) == null) {
            throw new IllegalArgumentException("Unable to find source file " + sourceFile + " for " + clazz);
        }
        InputStream input = inputStream;
        return this.consume(input);
    }

    @JvmOverloads
    @NotNull
    public final XPathRule newXpathRule(@NotNull String expr, @NotNull XPathVersion version) {
        XPathRule xPathRule;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        XPathRule $this$newXpathRule_u24lambda_u244 = xPathRule = new XPathRule(version, expr);
        boolean bl = false;
        $this$newXpathRule_u24lambda_u244.setLanguage(this.getLanguage());
        $this$newXpathRule_u24lambda_u244.setMessage("XPath Rule Failed");
        return xPathRule;
    }

    public static /* synthetic */ XPathRule newXpathRule$default(BaseParsingHelper baseParsingHelper, String string, XPathVersion xPathVersion, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newXpathRule");
        }
        if ((n & 2) != 0) {
            XPathVersion xPathVersion2 = XPathVersion.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)xPathVersion2, (String)"DEFAULT");
            xPathVersion = xPathVersion2;
        }
        return baseParsingHelper.newXpathRule(string, xPathVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    @NotNull
    public final Report executeRule(@NotNull Rule rule, @NotNull String code, @NotNull FileId fileName) {
        Report report;
        PMDConfiguration pMDConfiguration;
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (rule.getLanguage() == null) {
            rule.setLanguage(this.getLanguage());
        }
        PMDConfiguration $this$executeRule_u24lambda_u245 = pMDConfiguration = new PMDConfiguration();
        boolean bl = false;
        $this$executeRule_u24lambda_u245.setSuppressMarker(this.params.getSuppressMarker());
        $this$executeRule_u24lambda_u245.setForceLanguageVersion(this.getDefaultVersion());
        $this$executeRule_u24lambda_u245.setIgnoreIncrementalAnalysis(true);
        $this$executeRule_u24lambda_u245.setThreads(0);
        PMDConfiguration config = pMDConfiguration;
        AutoCloseable autoCloseable = (AutoCloseable)PmdAnalysis.create((PMDConfiguration)config);
        Throwable throwable = null;
        try {
            PmdAnalysis pmd = (PmdAnalysis)autoCloseable;
            boolean bl2 = false;
            pmd.addListener(GlobalAnalysisListener.exceptionThrower());
            pmd.addRuleSet(RuleSet.forSingleRule((Rule)rule));
            pmd.files().addSourceFile(fileName, code);
            Report report2 = pmd.performAnalysisAndCollectReport();
            report = report2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)report, (String)"create(config).use { pmd\u2026CollectReport()\n        }");
        return report;
    }

    public static /* synthetic */ Report executeRule$default(BaseParsingHelper baseParsingHelper, Rule rule, String string, FileId fileId, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeRule");
        }
        if ((n & 4) != 0) {
            FileId fileId2 = FileId.fromPathLikeString((String)("testfile." + (String)baseParsingHelper.getLanguage().getExtensions().get(0)));
            Intrinsics.checkNotNullExpressionValue((Object)fileId2, (String)"fromPathLikeString(\"test\u2026language.extensions[0]}\")");
            fileId = fileId2;
        }
        return baseParsingHelper.executeRule(rule, string, fileId);
    }

    @NotNull
    public final Report executeRuleOnResource(@NotNull Rule rule, @NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        return BaseParsingHelper.executeRule$default(this, rule, this.readResource(resourcePath), null, 4, null);
    }

    @NotNull
    public final Report executeRuleOnFile(@NotNull Rule rule, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        BufferedReader bufferedReader = Files.newBufferedReader(path);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"newBufferedReader(path)");
        String string = TextStreamsKt.readText((Reader)bufferedReader);
        FileId fileId = FileId.fromPath((Path)path);
        Intrinsics.checkNotNullExpressionValue((Object)fileId, (String)"fromPath(path)");
        return this.executeRule(rule, string, fileId);
    }

    @JvmOverloads
    @NotNull
    public final Self withProcessing() {
        return (Self)BaseParsingHelper.withProcessing$default(this, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Self withResourceContext(@NotNull Class<?> contextClass) {
        Intrinsics.checkNotNullParameter(contextClass, (String)"contextClass");
        return (Self)BaseParsingHelper.withResourceContext$default(this, contextClass, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final <R extends Node> List<R> getNodes(@NotNull Class<R> target, @NotNull String source) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return BaseParsingHelper.getNodes$default(this, target, source, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final T parse(@NotNull String sourceCode, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        return (T)BaseParsingHelper.parse$default(this, sourceCode, version, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final T parse(@NotNull String sourceCode) {
        Intrinsics.checkNotNullParameter((Object)sourceCode, (String)"sourceCode");
        return (T)BaseParsingHelper.parse$default(this, sourceCode, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final LanguageProcessor newProcessor() {
        return BaseParsingHelper.newProcessor$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final T parseResource(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        return (T)BaseParsingHelper.parseResource$default(this, resource, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final T parseFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return (T)BaseParsingHelper.parseFile$default(this, path, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final T parseClass(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)BaseParsingHelper.parseClass$default(this, clazz, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final XPathRule newXpathRule(@NotNull String expr) {
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        return BaseParsingHelper.newXpathRule$default(this, expr, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final Report executeRule(@NotNull Rule rule, @NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return BaseParsingHelper.executeRule$default(this, rule, code, null, 4, null);
    }

    private static final String _get_language_$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003JM\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006$"}, d2={"Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper$Params;", "", "doProcess", "", "defaultVerString", "", "resourceLoader", "Ljava/lang/Class;", "resourcePrefix", "languageRegistry", "Lnet/sourceforge/pmd/lang/LanguageRegistry;", "suppressMarker", "(ZLjava/lang/String;Ljava/lang/Class;Ljava/lang/String;Lnet/sourceforge/pmd/lang/LanguageRegistry;Ljava/lang/String;)V", "getDefaultVerString", "()Ljava/lang/String;", "getDoProcess", "()Z", "getLanguageRegistry", "()Lnet/sourceforge/pmd/lang/LanguageRegistry;", "getResourceLoader", "()Ljava/lang/Class;", "getResourcePrefix", "getSuppressMarker", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "pmd-lang-test"})
    public static final class Params {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean doProcess;
        @Nullable
        private final String defaultVerString;
        @Nullable
        private final Class<?> resourceLoader;
        @NotNull
        private final String resourcePrefix;
        @NotNull
        private final LanguageRegistry languageRegistry;
        @NotNull
        private final String suppressMarker;
        @NotNull
        private static final Params default = new Params(true, null, null, "", null, null, 48, null);

        public Params(boolean doProcess, @Nullable String defaultVerString, @Nullable Class<?> resourceLoader, @NotNull String resourcePrefix, @NotNull LanguageRegistry languageRegistry, @NotNull String suppressMarker) {
            Intrinsics.checkNotNullParameter((Object)resourcePrefix, (String)"resourcePrefix");
            Intrinsics.checkNotNullParameter((Object)languageRegistry, (String)"languageRegistry");
            Intrinsics.checkNotNullParameter((Object)suppressMarker, (String)"suppressMarker");
            this.doProcess = doProcess;
            this.defaultVerString = defaultVerString;
            this.resourceLoader = resourceLoader;
            this.resourcePrefix = resourcePrefix;
            this.languageRegistry = languageRegistry;
            this.suppressMarker = suppressMarker;
        }

        public /* synthetic */ Params(boolean bl, String string, Class clazz, String string2, LanguageRegistry languageRegistry, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                LanguageRegistry languageRegistry2 = LanguageRegistry.PMD;
                Intrinsics.checkNotNullExpressionValue((Object)languageRegistry2, (String)"PMD");
                languageRegistry = languageRegistry2;
            }
            if ((n & 0x20) != 0) {
                string3 = "NOPMD";
            }
            this(bl, string, clazz, string2, languageRegistry, string3);
        }

        public final boolean getDoProcess() {
            return this.doProcess;
        }

        @Nullable
        public final String getDefaultVerString() {
            return this.defaultVerString;
        }

        @Nullable
        public final Class<?> getResourceLoader() {
            return this.resourceLoader;
        }

        @NotNull
        public final String getResourcePrefix() {
            return this.resourcePrefix;
        }

        @NotNull
        public final LanguageRegistry getLanguageRegistry() {
            return this.languageRegistry;
        }

        @NotNull
        public final String getSuppressMarker() {
            return this.suppressMarker;
        }

        public final boolean component1() {
            return this.doProcess;
        }

        @Nullable
        public final String component2() {
            return this.defaultVerString;
        }

        @Nullable
        public final Class<?> component3() {
            return this.resourceLoader;
        }

        @NotNull
        public final String component4() {
            return this.resourcePrefix;
        }

        @NotNull
        public final LanguageRegistry component5() {
            return this.languageRegistry;
        }

        @NotNull
        public final String component6() {
            return this.suppressMarker;
        }

        @NotNull
        public final Params copy(boolean doProcess, @Nullable String defaultVerString, @Nullable Class<?> resourceLoader, @NotNull String resourcePrefix, @NotNull LanguageRegistry languageRegistry, @NotNull String suppressMarker) {
            Intrinsics.checkNotNullParameter((Object)resourcePrefix, (String)"resourcePrefix");
            Intrinsics.checkNotNullParameter((Object)languageRegistry, (String)"languageRegistry");
            Intrinsics.checkNotNullParameter((Object)suppressMarker, (String)"suppressMarker");
            return new Params(doProcess, defaultVerString, resourceLoader, resourcePrefix, languageRegistry, suppressMarker);
        }

        public static /* synthetic */ Params copy$default(Params params, boolean bl, String string, Class clazz, String string2, LanguageRegistry languageRegistry, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = params.doProcess;
            }
            if ((n & 2) != 0) {
                string = params.defaultVerString;
            }
            if ((n & 4) != 0) {
                clazz = params.resourceLoader;
            }
            if ((n & 8) != 0) {
                string2 = params.resourcePrefix;
            }
            if ((n & 0x10) != 0) {
                languageRegistry = params.languageRegistry;
            }
            if ((n & 0x20) != 0) {
                string3 = params.suppressMarker;
            }
            return params.copy(bl, string, clazz, string2, languageRegistry, string3);
        }

        @NotNull
        public String toString() {
            return "Params(doProcess=" + this.doProcess + ", defaultVerString=" + this.defaultVerString + ", resourceLoader=" + this.resourceLoader + ", resourcePrefix=" + this.resourcePrefix + ", languageRegistry=" + this.languageRegistry + ", suppressMarker=" + this.suppressMarker + ')';
        }

        public int hashCode() {
            int n = this.doProcess ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result = n;
            result = result * 31 + (this.defaultVerString == null ? 0 : this.defaultVerString.hashCode());
            result = result * 31 + (this.resourceLoader == null ? 0 : this.resourceLoader.hashCode());
            result = result * 31 + this.resourcePrefix.hashCode();
            result = result * 31 + this.languageRegistry.hashCode();
            result = result * 31 + this.suppressMarker.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Params)) {
                return false;
            }
            Params params = (Params)other;
            if (this.doProcess != params.doProcess) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultVerString, (Object)params.defaultVerString)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.resourceLoader, params.resourceLoader)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.resourcePrefix, (Object)params.resourcePrefix)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.languageRegistry, (Object)params.languageRegistry)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.suppressMarker, (Object)params.suppressMarker);
        }

        @NotNull
        public static final Params getDefault() {
            return Companion.getDefault();
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper$Params$Companion;", "", "()V", "default", "Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper$Params;", "getDefault$annotations", "getDefault", "()Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper$Params;", "pmd-lang-test"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Params getDefault() {
                return default;
            }

            @JvmStatic
            public static /* synthetic */ void getDefault$annotations() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

