/*
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 */

package net.sourceforge.pmd.lang.ast.test

import net.sourceforge.pmd.test.BaseTextComparisonTest
import net.sourceforge.pmd.util.treeexport.TreeRenderer


/**
 * Compare a dump of an AST against a saved baseline.
 *
 * @param printer The node printer used to dump the trees
 * @param extensionIncludingDot Extension that the unparsed source file is supposed to have
 */
abstract class BaseTreeDumpTest(
        private val printer: TreeRenderer,
        override val extensionIncludingDot: String
) : BaseTextComparisonTest() {

    abstract val parser: BaseParsingHelper<*, *>

    override val resourceLoader: Class<*>
        get() = parser.resourceLoader

    override val resourcePrefix: String
        get() = parser.resourcePrefix

    /**
     * @see BaseTextComparisonTest.doTest
     */
    fun doTest(fileBaseName: String) {
        super.doTest(fileBaseName, "") { sourceText ->
            buildString {
                printer.renderSubtree(parser.parse(sourceText), this)
            }
        }
    }
}
