/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.test;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J3\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\b\b\u0002\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u001c\u0010\u0017\u001a\u00020\u000e2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0004R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/sourceforge/pmd/test/BaseTextComparisonTest;", "", "()V", "extensionIncludingDot", "", "getExtensionIncludingDot", "()Ljava/lang/String;", "resourceLoader", "Ljava/lang/Class;", "getResourceLoader", "()Ljava/lang/Class;", "resourcePrefix", "getResourcePrefix", "srcTestResources", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "doTest", "", "fileBaseName", "expectedSuffix", "transformTextContent", "Lkotlin/Function1;", "doTest$pmd_lang_test", "findTestFile", "contextClass", "resourcePath", "sourceText", "Companion", "pmd-lang-test"})
public abstract class BaseTextComparisonTest {
    private final Path srcTestResources;
    @NotNull
    public static final String ExpectedExt = ".txt";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected abstract Class<?> getResourceLoader();

    @NotNull
    protected abstract String getResourcePrefix();

    @NotNull
    protected abstract String getExtensionIncludingDot();

    public final void doTest$pmd_lang_test(@NotNull String fileBaseName, @NotNull String expectedSuffix, @NotNull Function1<? super String, String> transformTextContent) {
        Intrinsics.checkParameterIsNotNull((Object)fileBaseName, (String)"fileBaseName");
        Intrinsics.checkParameterIsNotNull((Object)expectedSuffix, (String)"expectedSuffix");
        Intrinsics.checkParameterIsNotNull(transformTextContent, (String)"transformTextContent");
        File expectedFile = this.findTestFile(this.getResourceLoader(), this.getResourcePrefix() + '/' + fileBaseName + expectedSuffix + ExpectedExt).toFile();
        String actual = (String)transformTextContent.invoke((Object)this.sourceText(fileBaseName));
        if (!expectedFile.exists()) {
            File file = expectedFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"expectedFile");
            FilesKt.writeText$default((File)file, (String)actual, null, (int)2, null);
            throw (Throwable)((Object)new AssertionError((Object)("Reference file doesn't exist, created it at " + expectedFile)));
        }
        File file = expectedFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"expectedFile");
        String expected = FilesKt.readText$default((File)file, null, (int)1, null);
        AssertionsKt.assertEquals((Object)Companion.normalize(expected), (Object)Companion.normalize(actual), (String)("File comparison failed, see the reference: " + expectedFile));
    }

    public static /* synthetic */ void doTest$pmd_lang_test$default(BaseTextComparisonTest baseTextComparisonTest, String string, String string2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doTest");
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        baseTextComparisonTest.doTest$pmd_lang_test(string, string2, (Function1<? super String, String>)function1);
    }

    @NotNull
    protected final String sourceText(@NotNull String fileBaseName) {
        File sourceFile;
        Intrinsics.checkParameterIsNotNull((Object)fileBaseName, (String)"fileBaseName");
        File file = sourceFile = this.findTestFile(this.getResourceLoader(), this.getResourcePrefix() + '/' + fileBaseName + this.getExtensionIncludingDot()).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"sourceFile");
        boolean bl = file.isFile();
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Source file " + sourceFile + " is missing";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        String sourceText = Companion.normalize(FilesKt.readText((File)sourceFile, (Charset)Charsets.UTF_8));
        return sourceText;
    }

    private final Path findTestFile(Class<?> contextClass, String resourcePath) {
        Package package_ = contextClass.getPackage();
        Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"contextClass.`package`");
        String string = package_.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"contextClass.`package`.name");
        String path = StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
        Path norm = Paths.get(path + '/' + resourcePath, new String[0]).normalize();
        Path path2 = this.srcTestResources.resolve(norm);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"srcTestResources.resolve(norm)");
        return path2;
    }

    public BaseTextComparisonTest() {
        Object object;
        Object object2;
        block3: {
            block2: {
                BaseTextComparisonTest baseTextComparisonTest = this;
                BaseTextComparisonTest baseTextComparisonTest2 = this;
                boolean bl = false;
                boolean bl2 = false;
                BaseTextComparisonTest it = baseTextComparisonTest;
                boolean bl3 = false;
                object2 = System.getProperty("mvn.project.src.test.resources");
                if (object2 == null) break block2;
                String string = object2;
                boolean bl4 = false;
                boolean bl5 = false;
                String it2 = string;
                boolean bl6 = false;
                object2 = Paths.get(it2, new String[0]).toAbsolutePath();
                if (object2 != null) break block3;
            }
            ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
            Intrinsics.checkExpressionValueIsNotNull((Object)protectionDomain, (String)"javaClass.protectionDomain");
            CodeSource codeSource = protectionDomain.getCodeSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)codeSource, (String)"javaClass.protectionDomain.codeSource");
            URL uRL = codeSource.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"javaClass.protectionDomain.codeSource.location");
            object2 = Paths.get(uRL.getFile(), new String[0]).resolve("../../src/test/resources").normalize();
        }
        baseTextComparisonTest2.srcTestResources = object = object2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/sourceforge/pmd/test/BaseTextComparisonTest$Companion;", "", "()V", "ExpectedExt", "", "normalize", "pmd-lang-test"})
    public static final class Companion {
        @NotNull
        public final String normalize(@NotNull String $this$normalize) {
            Intrinsics.checkParameterIsNotNull((Object)$this$normalize, (String)"$this$normalize");
            CharSequence charSequence = $this$normalize;
            Regex regex = new Regex("\\u000D\\u000A|[\\u000A\\u000B\\u000C\\u000D\\u0085\\u2028\\u2029]");
            String string = "\n";
            boolean bl = false;
            return regex.replace(charSequence, string);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

