/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.test;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.ast.test.BaseParsingHelper;
import net.sourceforge.pmd.util.treeexport.TreeRenderer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u001c\u0010\u0015\u001a\u00020\u00102\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/sourceforge/pmd/lang/ast/test/BaseTreeDumpTest;", "", "printer", "Lnet/sourceforge/pmd/util/treeexport/TreeRenderer;", "extension", "", "(Lnet/sourceforge/pmd/util/treeexport/TreeRenderer;Ljava/lang/String;)V", "getExtension", "()Ljava/lang/String;", "parser", "Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper;", "getParser", "()Lnet/sourceforge/pmd/lang/ast/test/BaseParsingHelper;", "getPrinter", "()Lnet/sourceforge/pmd/util/treeexport/TreeRenderer;", "srcTestResources", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "doTest", "", "fileBaseName", "findTestFile", "contextClass", "Ljava/lang/Class;", "resourcePath", "Companion", "pmd-lang-test"})
public abstract class BaseTreeDumpTest {
    private final Path srcTestResources;
    @NotNull
    private final TreeRenderer printer;
    @NotNull
    private final String extension;
    @NotNull
    public static final String ExpectedExt = ".txt";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract BaseParsingHelper<?, ?> getParser();

    public final void doTest(@NotNull String fileBaseName) {
        StringBuilder stringBuilder;
        File sourceFile;
        Intrinsics.checkParameterIsNotNull((Object)fileBaseName, (String)"fileBaseName");
        File expectedFile = this.findTestFile(this.getParser().getResourceLoader$pmd_lang_test(), this.getParser().getResourcePrefix$pmd_lang_test() + '/' + fileBaseName + ExpectedExt).toFile();
        File file = sourceFile = this.findTestFile(this.getParser().getResourceLoader$pmd_lang_test(), this.getParser().getResourcePrefix$pmd_lang_test() + '/' + fileBaseName + this.extension).toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"sourceFile");
        boolean bl = file.isFile();
        if (_Assertions.ENABLED && !bl) {
            String string = "Source file " + sourceFile + " is missing";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        RootNode parsed = BaseParsingHelper.parse$default(this.getParser(), FilesKt.readText$default((File)sourceFile, null, (int)1, null), null, 2, null);
        StringBuilder it = stringBuilder = new StringBuilder();
        this.printer.renderSubtree((Node)parsed, (Appendable)it);
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().also { p\u2026(parsed, it) }.toString()");
        String actual = string;
        if (!expectedFile.exists()) {
            File file2 = expectedFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"expectedFile");
            FilesKt.writeText$default((File)file2, (String)actual, null, (int)2, null);
            throw (Throwable)((Object)new AssertionError((Object)("Reference file doesn't exist, created it at " + expectedFile)));
        }
        File file3 = expectedFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"expectedFile");
        String expected = FilesKt.readText$default((File)file3, null, (int)1, null);
        AssertionsKt.assertEquals((Object)Companion.normalize(expected), (Object)Companion.normalize(actual), (String)("Tree dump comparison failed, see the reference: " + expectedFile));
    }

    private final Path findTestFile(Class<?> contextClass, String resourcePath) {
        Package package_ = contextClass.getPackage();
        Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"contextClass.`package`");
        String string = package_.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"contextClass.`package`.name");
        String path = StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
        Path path2 = this.srcTestResources.resolve(path + '/' + resourcePath);
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"srcTestResources.resolve(\"$path/$resourcePath\")");
        return path2;
    }

    @NotNull
    public final TreeRenderer getPrinter() {
        return this.printer;
    }

    @NotNull
    public final String getExtension() {
        return this.extension;
    }

    public BaseTreeDumpTest(@NotNull TreeRenderer printer, @NotNull String extension) {
        Object object;
        String string;
        String it;
        Intrinsics.checkParameterIsNotNull((Object)printer, (String)"printer");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        this.printer = printer;
        this.extension = extension;
        BaseTreeDumpTest baseTreeDumpTest = this;
        BaseTreeDumpTest baseTreeDumpTest2 = this;
        BaseTreeDumpTest it2 = baseTreeDumpTest;
        Object object2 = System.getProperty("mvn.project.src.test.resources");
        if (object2 == null || (object2 = Paths.get(it = (string = object2), new String[0]).toAbsolutePath()) == null) {
            ProtectionDomain protectionDomain = this.getClass().getProtectionDomain();
            Intrinsics.checkExpressionValueIsNotNull((Object)protectionDomain, (String)"javaClass.protectionDomain");
            CodeSource codeSource = protectionDomain.getCodeSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)codeSource, (String)"javaClass.protectionDomain.codeSource");
            URL uRL = codeSource.getLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"javaClass.protectionDomain.codeSource.location");
            object2 = Paths.get(uRL.getFile(), new String[0]).resolve("../../src/test/resources").normalize();
        }
        baseTreeDumpTest2.srcTestResources = object = object2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/sourceforge/pmd/lang/ast/test/BaseTreeDumpTest$Companion;", "", "()V", "ExpectedExt", "", "normalize", "pmd-lang-test"})
    public static final class Companion {
        @NotNull
        public final String normalize(@NotNull String $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
            CharSequence charSequence = $receiver;
            Regex regex = new Regex("\\R");
            String string = "\n";
            return regex.replace(charSequence, string);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

