/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFormalParamSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.internal.InternalMethodTypeItf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class UnresolvedMethodSig
implements JMethodSig,
InternalMethodTypeItf {
    private final TypeSystem ts;
    private final JExecutableSymbol sym;

    UnresolvedMethodSig(TypeSystem ts) {
        this.ts = ts;
        this.sym = new UnresolvedMethodSym(ts);
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    @Override
    public JExecutableSymbol getSymbol() {
        return this.sym;
    }

    @Override
    public JMethodSig getErasure() {
        return this;
    }

    @Override
    public JTypeMirror getDeclaringType() {
        return this.ts.UNKNOWN;
    }

    @Override
    public JTypeMirror getReturnType() {
        return this.ts.UNKNOWN;
    }

    @Override
    public JTypeMirror getAnnotatedReceiverType() {
        return this.ts.UNKNOWN;
    }

    @Override
    public List<JTypeMirror> getFormalParameters() {
        return Collections.emptyList();
    }

    @Override
    public List<JTypeVar> getTypeParameters() {
        return Collections.emptyList();
    }

    @Override
    public List<JTypeMirror> getThrownExceptions() {
        return Collections.emptyList();
    }

    @Override
    public JMethodSig withReturnType(JTypeMirror returnType) {
        return this;
    }

    @Override
    public JMethodSig markAsAdapted() {
        return this;
    }

    @Override
    public JMethodSig adaptedMethod() {
        return this;
    }

    @Override
    public JMethodSig withTypeParams(@Nullable List<JTypeVar> tparams) {
        return this;
    }

    @Override
    public JMethodSig subst(Function<? super SubstVar, ? extends @NonNull JTypeMirror> subst) {
        return this;
    }

    @Override
    public JMethodSig withOwner(JTypeMirror newOwner) {
        return this;
    }

    @Override
    public JMethodSig originalMethod() {
        return this;
    }

    @Override
    public InternalMethodTypeItf internalApi() {
        return this;
    }

    public String toString() {
        return this.getName();
    }

    private static class UnresolvedMethodSym
    implements JMethodSymbol {
        private final TypeSystem ts;

        UnresolvedMethodSym(TypeSystem ts) {
            this.ts = ts;
        }

        @Override
        public boolean isUnresolved() {
            return true;
        }

        @Override
        public TypeSystem getTypeSystem() {
            return this.ts;
        }

        @Override
        public boolean isBridge() {
            return false;
        }

        @Override
        public JTypeMirror getReturnType(Substitution subst) {
            return this.ts.NO_TYPE;
        }

        @Override
        public List<JFormalParamSymbol> getFormalParameters() {
            return Collections.emptyList();
        }

        @Override
        public boolean isVarargs() {
            return false;
        }

        @Override
        public int getArity() {
            return 0;
        }

        @Override
        public @Nullable JTypeMirror getAnnotatedReceiverType(Substitution subst) {
            return this.ts.UNKNOWN;
        }

        @Override
        public @NonNull JClassSymbol getEnclosingClass() {
            return (JClassSymbol)this.ts.UNKNOWN.getSymbol();
        }

        @Override
        public List<JTypeMirror> getFormalParameterTypes(Substitution subst) {
            return Collections.emptyList();
        }

        @Override
        public List<JTypeMirror> getThrownExceptionTypes(Substitution subst) {
            return Collections.emptyList();
        }

        @Override
        public List<JTypeVar> getTypeParameters() {
            return Collections.emptyList();
        }

        @Override
        public int getModifiers() {
            return 1;
        }

        @Override
        public String getSimpleName() {
            return "(*unknown method*)";
        }

        public String toString() {
            return this.getSimpleName();
        }
    }
}

