/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.ast;

import java.util.ArrayList;
import java.util.Objects;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTClassLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValue;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValueArrayInitializer;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolEquality;
import net.sourceforge.pmd.lang.java.symbols.internal.SymbolToStrings;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class AstSymbolicAnnot
implements SymbolicValue.SymAnnot {
    private final ASTAnnotation node;
    private final JClassSymbol sym;

    AstSymbolicAnnot(@NonNull ASTAnnotation node, @NonNull JClassSymbol sym) {
        this.node = node;
        this.sym = Objects.requireNonNull(sym);
    }

    @Override
    public @Nullable SymbolicValue getAttribute(String attrName) {
        ASTMemberValue explicitAttr = this.node.getAttribute(attrName);
        if (explicitAttr != null) {
            return AstSymbolicAnnot.ofNode(explicitAttr);
        }
        return this.getAnnotationSymbol().getDefaultAnnotationAttributeValue(attrName);
    }

    @Override
    public @NonNull JClassSymbol getAnnotationSymbol() {
        return this.sym;
    }

    @Override
    public String getSimpleName() {
        return this.node.getSimpleName();
    }

    @Override
    public boolean equals(Object o) {
        return SymbolEquality.ANNOTATION.equals(this, o);
    }

    public int hashCode() {
        return SymbolEquality.ANNOTATION.hash(this);
    }

    public String toString() {
        return SymbolToStrings.AST.toString(this);
    }

    static SymbolicValue ofNode(ASTMemberValue valueNode) {
        ASTAssignableExpr.ASTNamedReferenceExpr refExpr;
        JTypeMirror t;
        if (valueNode == null) {
            return null;
        }
        Object constValue = valueNode.getConstValue();
        if (constValue != null) {
            return SymbolicValue.of(valueNode.getTypeSystem(), constValue);
        }
        if (valueNode instanceof ASTMemberValueArrayInitializer) {
            ArrayList<SymbolicValue> elements = new ArrayList<SymbolicValue>(valueNode.getNumChildren());
            for (ASTMemberValue elt : (ASTMemberValueArrayInitializer)valueNode) {
                SymbolicValue symElt = AstSymbolicAnnot.ofNode(elt);
                if (symElt == null) {
                    return null;
                }
                elements.add(symElt);
            }
            return SymbolicValue.SymArray.forElements(elements);
        }
        if (valueNode instanceof ASTClassLiteral) {
            JTypeDeclSymbol symbol = ((ASTClassLiteral)valueNode).getTypeNode().getTypeMirror().getSymbol();
            if (symbol instanceof JClassSymbol) {
                return SymbolicValue.SymClass.ofBinaryName(symbol.getTypeSystem(), ((JClassSymbol)symbol).getBinaryName());
            }
        } else if (valueNode instanceof ASTAssignableExpr.ASTNamedReferenceExpr && (t = (refExpr = (ASTAssignableExpr.ASTNamedReferenceExpr)valueNode).getTypeMirror()) instanceof JClassType && ((JClassType)t).getSymbol().isEnum()) {
            return SymbolicValue.SymEnum.fromBinaryName(t.getTypeSystem(), ((JClassType)t).getSymbol().getBinaryName(), refExpr.getName());
        }
        return null;
    }
}

